! Copyright (C) 2005, 2006 Doug Coleman.
! See http://factorcode.org/license.txt for BSD license.
USING: accessors assocs hashtables kernel math namespaces words
windows.types vocabs sequences ;
IN: windows.messages

SYMBOL: windows-messages

"windows.messages" words
[ name>> "windows-message" head? not ] filter
[ dup execute swap ] { } map>assoc
windows-messages set-global

: windows-message-name ( n -- name )
    windows-messages get at "unknown message" or ;

CONSTANT: WM_NULL 0x0000
CONSTANT: WM_CREATE 0x0001
CONSTANT: WM_DESTROY 0x0002
CONSTANT: WM_MOVE 0x0003
CONSTANT: WM_SIZE 0x0005
CONSTANT: WM_ACTIVATE 0x0006
CONSTANT: WM_SETFOCUS 0x0007
CONSTANT: WM_KILLFOCUS 0x0008
CONSTANT: WM_ENABLE 0x000A
CONSTANT: WM_SETREDRAW 0x000B
CONSTANT: WM_SETTEXT 0x000C
CONSTANT: WM_GETTEXT 0x000D
CONSTANT: WM_GETTEXTLENGTH 0x000E
CONSTANT: WM_PAINT 0x000F
CONSTANT: WM_CLOSE 0x0010
CONSTANT: WM_QUERYENDSESSION 0x0011
CONSTANT: WM_QUERYOPEN 0x0013
CONSTANT: WM_ENDSESSION 0x0016
CONSTANT: WM_QUIT 0x0012
CONSTANT: WM_ERASEBKGND 0x0014
CONSTANT: WM_SYSCOLORCHANGE 0x0015
CONSTANT: WM_SHOWWINDOW 0x0018
CONSTANT: WM_WININICHANGE 0x001A
CONSTANT: WM_SETTINGCHANGE 0x001A
CONSTANT: WM_DEVMODECHANGE 0x001B
CONSTANT: WM_ACTIVATEAPP 0x001C
CONSTANT: WM_FONTCHANGE 0x001D
CONSTANT: WM_TIMECHANGE 0x001E
CONSTANT: WM_CANCELMODE 0x001F
CONSTANT: WM_SETCURSOR 0x0020
CONSTANT: WM_MOUSEACTIVATE 0x0021
CONSTANT: WM_CHILDACTIVATE 0x0022
CONSTANT: WM_QUEUESYNC 0x0023
CONSTANT: WM_GETMINMAXINFO 0x0024
CONSTANT: WM_PAINTICON 0x0026
CONSTANT: WM_ICONERASEBKGND 0x0027
CONSTANT: WM_NEXTDLGCTL 0x0028
CONSTANT: WM_SPOOLERSTATUS 0x002A
CONSTANT: WM_DRAWITEM 0x002B
CONSTANT: WM_MEASUREITEM 0x002C
CONSTANT: WM_DELETEITEM 0x002D
CONSTANT: WM_VKEYTOITEM 0x002E
CONSTANT: WM_CHARTOITEM 0x002F
CONSTANT: WM_SETFONT 0x0030
CONSTANT: WM_GETFONT 0x0031
CONSTANT: WM_SETHOTKEY 0x0032
CONSTANT: WM_GETHOTKEY 0x0033
CONSTANT: WM_QUERYDRAGICON 0x0037
CONSTANT: WM_COMPAREITEM 0x0039
CONSTANT: WM_GETOBJECT 0x003D
CONSTANT: WM_COMPACTING 0x0041
CONSTANT: WM_COMMNOTIFY 0x0044
CONSTANT: WM_WINDOWPOSCHANGING 0x0046
CONSTANT: WM_WINDOWPOSCHANGED 0x0047
CONSTANT: WM_POWER 0x0048
CONSTANT: WM_COPYDATA 0x004A
CONSTANT: WM_CANCELJOURNAL 0x004B
CONSTANT: WM_NOTIFY 0x004E
CONSTANT: WM_INPUTLANGCHANGEREQUEST 0x0050
CONSTANT: WM_INPUTLANGCHANGE 0x0051
CONSTANT: WM_TCARD 0x0052
CONSTANT: WM_HELP 0x0053
CONSTANT: WM_USERCHANGED 0x0054
CONSTANT: WM_NOTIFYFORMAT 0x0055
CONSTANT: WM_CONTEXTMENU 0x007B
CONSTANT: WM_STYLECHANGING 0x007C
CONSTANT: WM_STYLECHANGED 0x007D
CONSTANT: WM_DISPLAYCHANGE 0x007E
CONSTANT: WM_GETICON 0x007F
CONSTANT: WM_SETICON 0x0080
CONSTANT: WM_NCCREATE 0x0081
CONSTANT: WM_NCDESTROY 0x0082
CONSTANT: WM_NCCALCSIZE 0x0083
CONSTANT: WM_NCHITTEST 0x0084
CONSTANT: WM_NCPAINT 0x0085
CONSTANT: WM_NCACTIVATE 0x0086
CONSTANT: WM_GETDLGCODE 0x0087
CONSTANT: WM_SYNCPAINT 0x0088
CONSTANT: WM_NCMOUSEMOVE 0x00A0
CONSTANT: WM_NCLBUTTONDOWN 0x00A1
CONSTANT: WM_NCLBUTTONUP 0x00A2
CONSTANT: WM_NCLBUTTONDBLCLK 0x00A3
CONSTANT: WM_NCRBUTTONDOWN 0x00A4
CONSTANT: WM_NCRBUTTONUP 0x00A5
CONSTANT: WM_NCRBUTTONDBLCLK 0x00A6
CONSTANT: WM_NCMBUTTONDOWN 0x00A7
CONSTANT: WM_NCMBUTTONUP 0x00A8
CONSTANT: WM_NCMBUTTONDBLCLK 0x00A9
CONSTANT: WM_NCXBUTTONDOWN 0x00AB
CONSTANT: WM_NCXBUTTONUP 0x00AC
CONSTANT: WM_NCXBUTTONDBLCLK 0x00AD
CONSTANT: WM_NCUAHDRAWCAPTION 0x00AE ! undocumented
CONSTANT: WM_NCUAHDRAWFRAME 0x00AF   ! undocumented
CONSTANT: WM_INPUT 0x00FF
CONSTANT: WM_KEYFIRST 0x0100
CONSTANT: WM_KEYDOWN 0x0100
CONSTANT: WM_KEYUP 0x0101
CONSTANT: WM_CHAR 0x0102
CONSTANT: WM_DEADCHAR 0x0103
CONSTANT: WM_SYSKEYDOWN 0x0104
CONSTANT: WM_SYSKEYUP 0x0105
CONSTANT: WM_SYSCHAR 0x0106
CONSTANT: WM_SYSDEADCHAR 0x0107
CONSTANT: WM_UNICHAR 0x0109
CONSTANT: WM_KEYLAST_NT501 0x0109
CONSTANT: UNICODE_NOCHAR 0xFFFF
CONSTANT: WM_KEYLAST_PRE501 0x0108
CONSTANT: WM_IME_STARTCOMPOSITION 0x010D
CONSTANT: WM_IME_ENDCOMPOSITION 0x010E
CONSTANT: WM_IME_COMPOSITION 0x010F
CONSTANT: WM_IME_KEYLAST 0x010F
CONSTANT: WM_INITDIALOG 0x0110
CONSTANT: WM_COMMAND 0x0111
CONSTANT: WM_SYSCOMMAND 0x0112
CONSTANT: WM_TIMER 0x0113
CONSTANT: WM_HSCROLL 0x0114
CONSTANT: WM_VSCROLL 0x0115
CONSTANT: WM_INITMENU 0x0116
CONSTANT: WM_INITMENUPOPUP 0x0117
CONSTANT: WM_MENUSELECT 0x011F
CONSTANT: WM_MENUCHAR 0x0120
CONSTANT: WM_ENTERIDLE 0x0121
CONSTANT: WM_MENURBUTTONUP 0x0122
CONSTANT: WM_MENUDRAG 0x0123
CONSTANT: WM_MENUGETOBJECT 0x0124
CONSTANT: WM_UNINITMENUPOPUP 0x0125
CONSTANT: WM_MENUCOMMAND 0x0126
CONSTANT: WM_CHANGEUISTATE 0x0127
CONSTANT: WM_UPDATEUISTATE 0x0128
CONSTANT: WM_QUERYUISTATE 0x0129
CONSTANT: WM_CTLCOLORMSGBOX 0x0132
CONSTANT: WM_CTLCOLOREDIT 0x0133
CONSTANT: WM_CTLCOLORLISTBOX 0x0134
CONSTANT: WM_CTLCOLORBTN 0x0135
CONSTANT: WM_CTLCOLORDLG 0x0136
CONSTANT: WM_CTLCOLORSCROLLBAR 0x0137
CONSTANT: WM_CTLCOLORSTATIC 0x0138
CONSTANT: WM_MOUSEFIRST 0x0200
CONSTANT: WM_MOUSEMOVE 0x0200
CONSTANT: WM_LBUTTONDOWN 0x0201
CONSTANT: WM_LBUTTONUP 0x0202
CONSTANT: WM_LBUTTONDBLCLK 0x0203
CONSTANT: WM_RBUTTONDOWN 0x0204
CONSTANT: WM_RBUTTONUP 0x0205
CONSTANT: WM_RBUTTONDBLCLK 0x0206
CONSTANT: WM_MBUTTONDOWN 0x0207
CONSTANT: WM_MBUTTONUP 0x0208
CONSTANT: WM_MBUTTONDBLCLK 0x0209
CONSTANT: WM_MOUSEWHEEL 0x020A
CONSTANT: WM_XBUTTONDOWN 0x020B
CONSTANT: WM_XBUTTONUP 0x020C
CONSTANT: WM_XBUTTONDBLCLK 0x020D
CONSTANT: WM_MOUSELAST_5 0x020D
CONSTANT: WM_MOUSELAST_4 0x020A
CONSTANT: WM_MOUSELAST_PRE_4 0x0209
CONSTANT: WM_PARENTNOTIFY 0x0210
CONSTANT: WM_ENTERMENULOOP 0x0211
CONSTANT: WM_EXITMENULOOP 0x0212
CONSTANT: WM_NEXTMENU 0x0213
CONSTANT: WM_SIZING 0x0214
CONSTANT: WM_CAPTURECHANGED 0x0215
CONSTANT: WM_MOVING 0x0216
CONSTANT: WM_POWERBROADCAST 0x0218
CONSTANT: WM_DEVICECHANGE 0x0219
CONSTANT: WM_MDICREATE 0x0220
CONSTANT: WM_MDIDESTROY 0x0221
CONSTANT: WM_MDIACTIVATE 0x0222
CONSTANT: WM_MDIRESTORE 0x0223
CONSTANT: WM_MDINEXT 0x0224
CONSTANT: WM_MDIMAXIMIZE 0x0225
CONSTANT: WM_MDITILE 0x0226
CONSTANT: WM_MDICASCADE 0x0227
CONSTANT: WM_MDIICONARRANGE 0x0228
CONSTANT: WM_MDIGETACTIVE 0x0229
CONSTANT: WM_MDISETMENU 0x0230
CONSTANT: WM_ENTERSIZEMOVE 0x0231
CONSTANT: WM_EXITSIZEMOVE 0x0232
CONSTANT: WM_DROPFILES 0x0233
CONSTANT: WM_MDIREFRESHMENU 0x0234
CONSTANT: WM_IME_SETCONTEXT 0x0281
CONSTANT: WM_IME_NOTIFY 0x0282
CONSTANT: WM_IME_CONTROL 0x0283
CONSTANT: WM_IME_COMPOSITIONFULL 0x0284
CONSTANT: WM_IME_SELECT 0x0285
CONSTANT: WM_IME_CHAR 0x0286
CONSTANT: WM_IME_REQUEST 0x0288
CONSTANT: WM_IME_KEYDOWN 0x0290
CONSTANT: WM_IME_KEYUP 0x0291
CONSTANT: WM_MOUSEHOVER 0x02A1
CONSTANT: WM_MOUSELEAVE 0x02A3
CONSTANT: WM_NCMOUSEHOVER 0x02A0
CONSTANT: WM_NCMOUSELEAVE 0x02A2
CONSTANT: WM_WTSSESSION_CHANGE 0x02B1
CONSTANT: WM_TABLET_FIRST 0x02c0
CONSTANT: WM_TABLET_LAST 0x02df
CONSTANT: WM_CUT 0x0300
CONSTANT: WM_COPY 0x0301
CONSTANT: WM_PASTE 0x0302
CONSTANT: WM_CLEAR 0x0303
CONSTANT: WM_UNDO 0x0304
CONSTANT: WM_RENDERFORMAT 0x0305
CONSTANT: WM_RENDERALLFORMATS 0x0306
CONSTANT: WM_DESTROYCLIPBOARD 0x0307
CONSTANT: WM_DRAWCLIPBOARD 0x0308
CONSTANT: WM_PAINTCLIPBOARD 0x0309
CONSTANT: WM_VSCROLLCLIPBOARD 0x030A
CONSTANT: WM_SIZECLIPBOARD 0x030B
CONSTANT: WM_ASKCBFORMATNAME 0x030C
CONSTANT: WM_CHANGECBCHAIN 0x030D
CONSTANT: WM_HSCROLLCLIPBOARD 0x030E
CONSTANT: WM_QUERYNEWPALETTE 0x030F
CONSTANT: WM_PALETTEISCHANGING 0x0310
CONSTANT: WM_PALETTECHANGED 0x0311
CONSTANT: WM_HOTKEY 0x0312
CONSTANT: WM_PRINT 0x0317
CONSTANT: WM_PRINTCLIENT 0x0318
CONSTANT: WM_APPCOMMAND 0x0319
CONSTANT: WM_THEMECHANGED 0x031A
CONSTANT: WM_HANDHELDFIRST 0x0358
CONSTANT: WM_HANDHELDLAST 0x035F
CONSTANT: WM_AFXFIRST 0x0360
CONSTANT: WM_AFXLAST 0x037F
CONSTANT: WM_PENWINFIRST 0x0380
CONSTANT: WM_PENWINLAST 0x038F
CONSTANT: WM_APP 0x8000
CONSTANT: WM_USER 0x0400
CONSTANT: EM_GETSEL 0x00B0
CONSTANT: EM_SETSEL 0x00B1
CONSTANT: EM_GETRECT 0x00B2
CONSTANT: EM_SETRECT 0x00B3
CONSTANT: EM_SETRECTNP 0x00B4
CONSTANT: EM_SCROLL 0x00B5
CONSTANT: EM_LINESCROLL 0x00B6
CONSTANT: EM_SCROLLCARET 0x00B7
CONSTANT: EM_GETMODIFY 0x00B8
CONSTANT: EM_SETMODIFY 0x00B9
CONSTANT: EM_GETLINECOUNT 0x00BA
CONSTANT: EM_LINEINDEX 0x00BB
CONSTANT: EM_SETHANDLE 0x00BC
CONSTANT: EM_GETHANDLE 0x00BD
CONSTANT: EM_GETTHUMB 0x00BE
CONSTANT: EM_LINELENGTH 0x00C1
CONSTANT: EM_REPLACESEL 0x00C2
CONSTANT: EM_GETLINE 0x00C4
CONSTANT: EM_LIMITTEXT 0x00C5
CONSTANT: EM_CANUNDO 0x00C6
CONSTANT: EM_UNDO 0x00C7
CONSTANT: EM_FMTLINES 0x00C8
CONSTANT: EM_LINEFROMCHAR 0x00C9
CONSTANT: EM_SETTABSTOPS 0x00CB
CONSTANT: EM_SETPASSWORDCHAR 0x00CC
CONSTANT: EM_EMPTYUNDOBUFFER 0x00CD
CONSTANT: EM_GETFIRSTVISIBLELINE 0x00CE
CONSTANT: EM_SETREADONLY 0x00CF
CONSTANT: EM_SETWORDBREAKPROC 0x00D0
CONSTANT: EM_GETWORDBREAKPROC 0x00D1
CONSTANT: EM_GETPASSWORDCHAR 0x00D2
CONSTANT: EM_SETMARGINS 0x00D3
CONSTANT: EM_GETMARGINS 0x00D4
ALIAS: EM_SETLIMITTEXT EM_LIMITTEXT
CONSTANT: EM_GETLIMITTEXT 0x00D5
CONSTANT: EM_POSFROMCHAR 0x00D6
CONSTANT: EM_CHARFROMPOS 0x00D7
CONSTANT: EM_SETIMESTATUS 0x00D8
CONSTANT: EM_GETIMESTATUS 0x00D9
CONSTANT: BM_GETCHECK 0x00F0
CONSTANT: BM_SETCHECK 0x00F1
CONSTANT: BM_GETSTATE 0x00F2
CONSTANT: BM_SETSTATE 0x00F3
CONSTANT: BM_SETSTYLE 0x00F4
CONSTANT: BM_CLICK 0x00F5
CONSTANT: BM_GETIMAGE 0x00F6
CONSTANT: BM_SETIMAGE 0x00F7
CONSTANT: STM_SETICON 0x0170
CONSTANT: STM_GETICON 0x0171
CONSTANT: STM_SETIMAGE 0x0172
CONSTANT: STM_GETIMAGE 0x0173
CONSTANT: STM_MSGMAX 0x0174
CONSTANT: DM_GETDEFID WM_USER
: DM_SETDEFID ( -- n ) WM_USER 1  + ; inline
: DM_REPOSITION ( -- n ) WM_USER 2  + ; inline
CONSTANT: LB_ADDSTRING 0x0180
CONSTANT: LB_INSERTSTRING 0x0181
CONSTANT: LB_DELETESTRING 0x0182
CONSTANT: LB_SELITEMRANGEEX 0x0183
CONSTANT: LB_RESETCONTENT 0x0184
CONSTANT: LB_SETSEL 0x0185
CONSTANT: LB_SETCURSEL 0x0186
CONSTANT: LB_GETSEL 0x0187
CONSTANT: LB_GETCURSEL 0x0188
CONSTANT: LB_GETTEXT 0x0189
CONSTANT: LB_GETTEXTLEN 0x018A
CONSTANT: LB_GETCOUNT 0x018B
CONSTANT: LB_SELECTSTRING 0x018C
CONSTANT: LB_DIR 0x018D
CONSTANT: LB_GETTOPINDEX 0x018E
CONSTANT: LB_FINDSTRING 0x018F
CONSTANT: LB_GETSELCOUNT 0x0190
CONSTANT: LB_GETSELITEMS 0x0191
CONSTANT: LB_SETTABSTOPS 0x0192
CONSTANT: LB_GETHORIZONTALEXTENT 0x0193
CONSTANT: LB_SETHORIZONTALEXTENT 0x0194
CONSTANT: LB_SETCOLUMNWIDTH 0x0195
CONSTANT: LB_ADDFILE 0x0196
CONSTANT: LB_SETTOPINDEX 0x0197
CONSTANT: LB_GETITEMRECT 0x0198
CONSTANT: LB_GETITEMDATA 0x0199
CONSTANT: LB_SETITEMDATA 0x019A
CONSTANT: LB_SELITEMRANGE 0x019B
CONSTANT: LB_SETANCHORINDEX 0x019C
CONSTANT: LB_GETANCHORINDEX 0x019D
CONSTANT: LB_SETCARETINDEX 0x019E
CONSTANT: LB_GETCARETINDEX 0x019F
CONSTANT: LB_SETITEMHEIGHT 0x01A0
CONSTANT: LB_GETITEMHEIGHT 0x01A1
CONSTANT: LB_FINDSTRINGEXACT 0x01A2
CONSTANT: LB_SETLOCALE 0x01A5
CONSTANT: LB_GETLOCALE 0x01A6
CONSTANT: LB_SETCOUNT 0x01A7
CONSTANT: LB_INITSTORAGE 0x01A8
CONSTANT: LB_ITEMFROMPOINT 0x01A9
CONSTANT: LB_MULTIPLEADDSTRING 0x01B1
CONSTANT: LB_GETLISTBOXINFO 0x01B2
CONSTANT: LB_MSGMAX_501 0x01B3
CONSTANT: LB_MSGMAX_WCE4 0x01B1
CONSTANT: LB_MSGMAX_4 0x01B0
CONSTANT: LB_MSGMAX_PRE4 0x01A8
CONSTANT: CB_GETEDITSEL 0x0140
CONSTANT: CB_LIMITTEXT 0x0141
CONSTANT: CB_SETEDITSEL 0x0142
CONSTANT: CB_ADDSTRING 0x0143
CONSTANT: CB_DELETESTRING 0x0144
CONSTANT: CB_DIR 0x0145
CONSTANT: CB_GETCOUNT 0x0146
CONSTANT: CB_GETCURSEL 0x0147
CONSTANT: CB_GETLBTEXT 0x0148
CONSTANT: CB_GETLBTEXTLEN 0x0149
CONSTANT: CB_INSERTSTRING 0x014A
CONSTANT: CB_RESETCONTENT 0x014B
CONSTANT: CB_FINDSTRING 0x014C
CONSTANT: CB_SELECTSTRING 0x014D
CONSTANT: CB_SETCURSEL 0x014E
CONSTANT: CB_SHOWDROPDOWN 0x014F
CONSTANT: CB_GETITEMDATA 0x0150
CONSTANT: CB_SETITEMDATA 0x0151
CONSTANT: CB_GETDROPPEDCONTROLRECT 0x0152
CONSTANT: CB_SETITEMHEIGHT 0x0153
CONSTANT: CB_GETITEMHEIGHT 0x0154
CONSTANT: CB_SETEXTENDEDUI 0x0155
CONSTANT: CB_GETEXTENDEDUI 0x0156
CONSTANT: CB_GETDROPPEDSTATE 0x0157
CONSTANT: CB_FINDSTRINGEXACT 0x0158
CONSTANT: CB_SETLOCALE 0x0159
CONSTANT: CB_GETLOCALE 0x015A
CONSTANT: CB_GETTOPINDEX 0x015B
CONSTANT: CB_SETTOPINDEX 0x015C
CONSTANT: CB_GETHORIZONTALEXTENT 0x015d
CONSTANT: CB_SETHORIZONTALEXTENT 0x015e
CONSTANT: CB_GETDROPPEDWIDTH 0x015f
CONSTANT: CB_SETDROPPEDWIDTH 0x0160
CONSTANT: CB_INITSTORAGE 0x0161
CONSTANT: CB_MULTIPLEADDSTRING 0x0163
CONSTANT: CB_GETCOMBOBOXINFO 0x0164
CONSTANT: CB_MSGMAX_501 0x0165
CONSTANT: CB_MSGMAX_WCE400 0x0163
CONSTANT: CB_MSGMAX_400 0x0162
CONSTANT: CB_MSGMAX_PRE400 0x015B
CONSTANT: SBM_SETPOS 0x00E0
CONSTANT: SBM_GETPOS 0x00E1
CONSTANT: SBM_SETRANGE 0x00E2
CONSTANT: SBM_SETRANGEREDRAW 0x00E6
CONSTANT: SBM_GETRANGE 0x00E3
CONSTANT: SBM_ENABLE_ARROWS 0x00E4
CONSTANT: SBM_SETSCROLLINFO 0x00E9
CONSTANT: SBM_GETSCROLLINFO 0x00EA
CONSTANT: SBM_GETSCROLLBARINFO 0x00EB
CONSTANT: LVM_FIRST 0x1000 ! ListView messages
CONSTANT: TV_FIRST 0x1100 ! TreeView messages
CONSTANT: HDM_FIRST 0x1200 ! Header messages
CONSTANT: TCM_FIRST 0x1300 ! Tab control messages
CONSTANT: PGM_FIRST 0x1400 ! Pager control messages
CONSTANT: ECM_FIRST 0x1500 ! Edit control messages
CONSTANT: BCM_FIRST 0x1600 ! Button control messages
CONSTANT: CBM_FIRST 0x1700 ! Combobox control messages
CONSTANT: CCM_FIRST 0x2000 ! Common control shared messages
: CCM_LAST ( -- n ) CCM_FIRST 0x0200  + ; inline
: CCM_SETBKCOLOR ( -- n ) CCM_FIRST  1  + ; inline
: CCM_SETCOLORSCHEME ( -- n ) CCM_FIRST  2  + ; inline
: CCM_GETCOLORSCHEME ( -- n ) CCM_FIRST  3  + ; inline
: CCM_GETDROPTARGET ( -- n ) CCM_FIRST  4  + ; inline
: CCM_SETUNICODEFORMAT ( -- n ) CCM_FIRST  5  + ; inline
: CCM_GETUNICODEFORMAT ( -- n ) CCM_FIRST  6  + ; inline
: CCM_SETVERSION ( -- n ) CCM_FIRST  7  + ; inline
: CCM_GETVERSION ( -- n ) CCM_FIRST  8  + ; inline
: CCM_SETNOTIFYWINDOW ( -- n ) CCM_FIRST  9  + ; inline
: CCM_SETWINDOWTHEME ( -- n ) CCM_FIRST  0xb  + ; inline
: CCM_DPISCALE ( -- n ) CCM_FIRST  0xc  + ; inline
: HDM_GETITEMCOUNT ( -- n ) HDM_FIRST  0  + ; inline
: HDM_INSERTITEMA ( -- n ) HDM_FIRST  1  + ; inline
: HDM_INSERTITEMW ( -- n ) HDM_FIRST  10  + ; inline
: HDM_DELETEITEM ( -- n ) HDM_FIRST  2  + ; inline
: HDM_GETITEMA ( -- n ) HDM_FIRST  3  + ; inline
: HDM_GETITEMW ( -- n ) HDM_FIRST  11  + ; inline
: HDM_SETITEMA ( -- n ) HDM_FIRST  4  + ; inline
: HDM_SETITEMW ( -- n ) HDM_FIRST  12  + ; inline
: HDM_LAYOUT ( -- n ) HDM_FIRST  5  + ; inline
: HDM_HITTEST ( -- n ) HDM_FIRST  6  + ; inline
: HDM_GETITEMRECT ( -- n ) HDM_FIRST  7  + ; inline
: HDM_SETIMAGELIST ( -- n ) HDM_FIRST  8  + ; inline
: HDM_GETIMAGELIST ( -- n ) HDM_FIRST  9  + ; inline
: HDM_ORDERTOINDEX ( -- n ) HDM_FIRST  15  + ; inline
: HDM_CREATEDRAGIMAGE ( -- n ) HDM_FIRST  16  + ; inline
: HDM_GETORDERARRAY ( -- n ) HDM_FIRST  17  + ; inline
: HDM_SETORDERARRAY ( -- n ) HDM_FIRST  18  + ; inline
: HDM_SETHOTDIVIDER ( -- n ) HDM_FIRST  19  + ; inline
: HDM_SETBITMAPMARGIN ( -- n ) HDM_FIRST  20  + ; inline
: HDM_GETBITMAPMARGIN ( -- n ) HDM_FIRST  21  + ; inline
CONSTANT: HDM_SETUNICODEFORMAT CCM_SETUNICODEFORMAT
CONSTANT: HDM_GETUNICODEFORMAT CCM_GETUNICODEFORMAT   
: HDM_SETFILTERCHANGETIMEOUT ( -- n ) HDM_FIRST 22  + ; inline
: HDM_EDITFILTER ( -- n ) HDM_FIRST 23  + ; inline
: HDM_CLEARFILTER ( -- n ) HDM_FIRST 24  + ; inline
: TB_ENABLEBUTTON ( -- n ) WM_USER 1  + ; inline
: TB_CHECKBUTTON ( -- n ) WM_USER 2  + ; inline
: TB_PRESSBUTTON ( -- n ) WM_USER 3  + ; inline
: TB_HIDEBUTTON ( -- n ) WM_USER  4  + ; inline
: TB_INDETERMINATE ( -- n ) WM_USER  5  + ; inline
: TB_MARKBUTTON ( -- n ) WM_USER  6  + ; inline
: TB_ISBUTTONENABLED ( -- n ) WM_USER  9  + ; inline
: TB_ISBUTTONCHECKED ( -- n ) WM_USER  10  + ; inline
: TB_ISBUTTONPRESSED ( -- n ) WM_USER  11  + ; inline
: TB_ISBUTTONHIDDEN ( -- n ) WM_USER  12  + ; inline
: TB_ISBUTTONINDETERMINATE ( -- n ) WM_USER  13  + ; inline
: TB_ISBUTTONHIGHLIGHTED ( -- n ) WM_USER  14  + ; inline
: TB_SETSTATE ( -- n ) WM_USER  17  + ; inline
: TB_GETSTATE ( -- n ) WM_USER  18  + ; inline
: TB_ADDBITMAP ( -- n ) WM_USER  19  + ; inline
: TB_ADDBUTTONSA ( -- n ) WM_USER  20  + ; inline
: TB_INSERTBUTTONA ( -- n ) WM_USER  21  + ; inline
: TB_ADDBUTTONS ( -- n ) WM_USER  20  + ; inline
: TB_INSERTBUTTON ( -- n ) WM_USER  21  + ; inline
: TB_DELETEBUTTON ( -- n ) WM_USER  22  + ; inline
: TB_GETBUTTON ( -- n ) WM_USER  23  + ; inline
: TB_BUTTONCOUNT ( -- n ) WM_USER  24  + ; inline
: TB_COMMANDTOINDEX ( -- n ) WM_USER  25  + ; inline
: TB_SAVERESTOREA ( -- n ) WM_USER  26  + ; inline
: TB_SAVERESTOREW ( -- n ) WM_USER  76  + ; inline
: TB_CUSTOMIZE ( -- n ) WM_USER  27  + ; inline
: TB_ADDSTRINGA ( -- n ) WM_USER  28  + ; inline
: TB_ADDSTRINGW ( -- n ) WM_USER  77  + ; inline
: TB_GETITEMRECT ( -- n ) WM_USER  29  + ; inline
: TB_BUTTONSTRUCTSIZE ( -- n ) WM_USER  30  + ; inline
: TB_SETBUTTONSIZE ( -- n ) WM_USER  31  + ; inline
: TB_SETBITMAPSIZE ( -- n ) WM_USER  32  + ; inline
: TB_AUTOSIZE ( -- n ) WM_USER  33  + ; inline
: TB_GETTOOLTIPS ( -- n ) WM_USER  35  + ; inline
: TB_SETTOOLTIPS ( -- n ) WM_USER  36  + ; inline
: TB_SETPARENT ( -- n ) WM_USER  37  + ; inline
: TB_SETROWS ( -- n ) WM_USER  39  + ; inline
: TB_GETROWS ( -- n ) WM_USER  40  + ; inline
: TB_SETCMDID ( -- n ) WM_USER  42  + ; inline
: TB_CHANGEBITMAP ( -- n ) WM_USER  43  + ; inline
: TB_GETBITMAP ( -- n ) WM_USER  44  + ; inline
: TB_GETBUTTONTEXTA ( -- n ) WM_USER  45  + ; inline
: TB_GETBUTTONTEXTW ( -- n ) WM_USER  75  + ; inline
: TB_REPLACEBITMAP ( -- n ) WM_USER  46  + ; inline
: TB_SETINDENT ( -- n ) WM_USER  47  + ; inline
: TB_SETIMAGELIST ( -- n ) WM_USER  48  + ; inline
: TB_GETIMAGELIST ( -- n ) WM_USER  49  + ; inline
: TB_LOADIMAGES ( -- n ) WM_USER  50  + ; inline
: TB_GETRECT ( -- n ) WM_USER  51  + ; inline
: TB_SETHOTIMAGELIST ( -- n ) WM_USER  52  + ; inline
: TB_GETHOTIMAGELIST ( -- n ) WM_USER  53  + ; inline
: TB_SETDISABLEDIMAGELIST ( -- n ) WM_USER  54  + ; inline
: TB_GETDISABLEDIMAGELIST ( -- n ) WM_USER  55  + ; inline
: TB_SETSTYLE ( -- n ) WM_USER  56  + ; inline
: TB_GETSTYLE ( -- n ) WM_USER  57  + ; inline
: TB_GETBUTTONSIZE ( -- n ) WM_USER  58  + ; inline
: TB_SETBUTTONWIDTH ( -- n ) WM_USER  59  + ; inline
: TB_SETMAXTEXTROWS ( -- n ) WM_USER  60  + ; inline
: TB_GETTEXTROWS ( -- n ) WM_USER  61  + ; inline
: TB_GETOBJECT ( -- n ) WM_USER  62  + ; inline
: TB_GETHOTITEM ( -- n ) WM_USER  71  + ; inline
: TB_SETHOTITEM ( -- n ) WM_USER  72  + ; inline
: TB_SETANCHORHIGHLIGHT ( -- n ) WM_USER  73  + ; inline
: TB_GETANCHORHIGHLIGHT ( -- n ) WM_USER  74  + ; inline
: TB_MAPACCELERATORA ( -- n ) WM_USER  78  + ; inline
: TB_GETINSERTMARK ( -- n ) WM_USER  79  + ; inline
: TB_SETINSERTMARK ( -- n ) WM_USER  80  + ; inline
: TB_INSERTMARKHITTEST ( -- n ) WM_USER  81  + ; inline
: TB_MOVEBUTTON ( -- n ) WM_USER  82  + ; inline
: TB_GETMAXSIZE ( -- n ) WM_USER  83  + ; inline
: TB_SETEXTENDEDSTYLE ( -- n ) WM_USER  84  + ; inline
: TB_GETEXTENDEDSTYLE ( -- n ) WM_USER  85  + ; inline
: TB_GETPADDING ( -- n ) WM_USER  86  + ; inline
: TB_SETPADDING ( -- n ) WM_USER  87  + ; inline
: TB_SETINSERTMARKCOLOR ( -- n ) WM_USER  88  + ; inline
: TB_GETINSERTMARKCOLOR ( -- n ) WM_USER  89  + ; inline
ALIAS: TB_SETCOLORSCHEME CCM_SETCOLORSCHEME
ALIAS: TB_GETCOLORSCHEME CCM_GETCOLORSCHEME
ALIAS: TB_SETUNICODEFORMAT CCM_SETUNICODEFORMAT
ALIAS: TB_GETUNICODEFORMAT CCM_GETUNICODEFORMAT
: TB_MAPACCELERATORW ( -- n ) WM_USER  90  + ; inline
: TB_GETBITMAPFLAGS ( -- n ) WM_USER  41  + ; inline
: TB_GETBUTTONINFOW ( -- n ) WM_USER  63  + ; inline
: TB_SETBUTTONINFOW ( -- n ) WM_USER  64  + ; inline
: TB_GETBUTTONINFOA ( -- n ) WM_USER  65  + ; inline
: TB_SETBUTTONINFOA ( -- n ) WM_USER  66  + ; inline
: TB_INSERTBUTTONW ( -- n ) WM_USER  67  + ; inline
: TB_ADDBUTTONSW ( -- n ) WM_USER  68  + ; inline
: TB_HITTEST ( -- n ) WM_USER  69  + ; inline
: TB_SETDRAWTEXTFLAGS ( -- n ) WM_USER  70  + ; inline
: TB_GETSTRINGW ( -- n ) WM_USER  91  + ; inline
: TB_GETSTRINGA ( -- n ) WM_USER  92  + ; inline
: TB_GETMETRICS ( -- n ) WM_USER  101  + ; inline
: TB_SETMETRICS ( -- n ) WM_USER  102  + ; inline
ALIAS: TB_SETWINDOWTHEME CCM_SETWINDOWTHEME
: RB_INSERTBANDA ( -- n ) WM_USER  1  + ; inline
: RB_DELETEBAND ( -- n ) WM_USER  2  + ; inline
: RB_GETBARINFO ( -- n ) WM_USER  3  + ; inline
: RB_SETBARINFO ( -- n ) WM_USER  4  + ; inline
: RB_GETBANDINFO ( -- n ) WM_USER  5  + ; inline
: RB_SETBANDINFOA ( -- n ) WM_USER  6  + ; inline
: RB_SETPARENT ( -- n ) WM_USER  7  + ; inline
: RB_HITTEST ( -- n ) WM_USER  8  + ; inline
: RB_GETRECT ( -- n ) WM_USER  9  + ; inline
: RB_INSERTBANDW ( -- n ) WM_USER  10  + ; inline
: RB_SETBANDINFOW ( -- n ) WM_USER  11  + ; inline
: RB_GETBANDCOUNT ( -- n ) WM_USER  12  + ; inline
: RB_GETROWCOUNT ( -- n ) WM_USER  13  + ; inline
: RB_GETROWHEIGHT ( -- n ) WM_USER  14  + ; inline
: RB_IDTOINDEX ( -- n ) WM_USER  16  + ; inline
: RB_GETTOOLTIPS ( -- n ) WM_USER  17  + ; inline
: RB_SETTOOLTIPS ( -- n ) WM_USER  18  + ; inline
: RB_SETBKCOLOR ( -- n ) WM_USER  19  + ; inline
: RB_GETBKCOLOR ( -- n ) WM_USER  20  + ; inline
: RB_SETTEXTCOLOR ( -- n ) WM_USER  21  + ; inline
: RB_GETTEXTCOLOR ( -- n ) WM_USER  22  + ; inline
: RB_SIZETORECT ( -- n ) WM_USER  23  + ; inline
CONSTANT: RB_SETCOLORSCHEME CCM_SETCOLORSCHEME
CONSTANT: RB_GETCOLORSCHEME CCM_GETCOLORSCHEME
: RB_BEGINDRAG ( -- n ) WM_USER  24  + ; inline
: RB_ENDDRAG ( -- n ) WM_USER  25  + ; inline
: RB_DRAGMOVE ( -- n ) WM_USER  26  + ; inline
: RB_GETBARHEIGHT ( -- n ) WM_USER  27  + ; inline
: RB_GETBANDINFOW ( -- n ) WM_USER  28  + ; inline
: RB_GETBANDINFOA ( -- n ) WM_USER  29  + ; inline
: RB_MINIMIZEBAND ( -- n ) WM_USER  30  + ; inline
: RB_MAXIMIZEBAND ( -- n ) WM_USER  31  + ; inline
ALIAS: RB_GETDROPTARGET CCM_GETDROPTARGET
: RB_GETBANDBORDERS ( -- n ) WM_USER  34  + ; inline
: RB_SHOWBAND ( -- n ) WM_USER  35  + ; inline
: RB_SETPALETTE ( -- n ) WM_USER  37  + ; inline
: RB_GETPALETTE ( -- n ) WM_USER  38  + ; inline
: RB_MOVEBAND ( -- n ) WM_USER  39  + ; inline
CONSTANT: RB_SETUNICODEFORMAT CCM_SETUNICODEFORMAT
CONSTANT: RB_GETUNICODEFORMAT CCM_GETUNICODEFORMAT
: RB_GETBANDMARGINS ( -- n ) WM_USER  40  + ; inline
ALIAS: RB_SETWINDOWTHEME CCM_SETWINDOWTHEME
: RB_PUSHCHEVRON ( -- n ) WM_USER  43  + ; inline
: TTM_ACTIVATE ( -- n ) WM_USER  1  + ; inline
: TTM_SETDELAYTIME ( -- n ) WM_USER  3  + ; inline
: TTM_ADDTOOLA ( -- n ) WM_USER  4  + ; inline
: TTM_ADDTOOLW ( -- n ) WM_USER  50  + ; inline
: TTM_DELTOOLA ( -- n ) WM_USER  5  + ; inline
: TTM_DELTOOLW ( -- n ) WM_USER  51  + ; inline
: TTM_NEWTOOLRECTA ( -- n ) WM_USER  6  + ; inline
: TTM_NEWTOOLRECTW ( -- n ) WM_USER  52  + ; inline
: TTM_RELAYEVENT ( -- n ) WM_USER  7  + ; inline
: TTM_GETTOOLINFOA ( -- n ) WM_USER  8  + ; inline
: TTM_GETTOOLINFOW ( -- n ) WM_USER  53  + ; inline
: TTM_SETTOOLINFOA ( -- n ) WM_USER  9  + ; inline
: TTM_SETTOOLINFOW ( -- n ) WM_USER  54  + ; inline
: TTM_HITTESTA ( -- n ) WM_USER 10  + ; inline
: TTM_HITTESTW ( -- n ) WM_USER 55  + ; inline
: TTM_GETTEXTA ( -- n ) WM_USER 11  + ; inline
: TTM_GETTEXTW ( -- n ) WM_USER 56  + ; inline
: TTM_UPDATETIPTEXTA ( -- n ) WM_USER 12  + ; inline
: TTM_UPDATETIPTEXTW ( -- n ) WM_USER 57  + ; inline
: TTM_GETTOOLCOUNT ( -- n ) WM_USER 13  + ; inline
: TTM_ENUMTOOLSA ( -- n ) WM_USER 14  + ; inline
: TTM_ENUMTOOLSW ( -- n ) WM_USER 58  + ; inline
: TTM_GETCURRENTTOOLA ( -- n ) WM_USER  15  + ; inline
: TTM_GETCURRENTTOOLW ( -- n ) WM_USER  59  + ; inline
: TTM_WINDOWFROMPOINT ( -- n ) WM_USER  16  + ; inline
: TTM_TRACKACTIVATE ( -- n ) WM_USER  17  + ; inline
: TTM_TRACKPOSITION ( -- n ) WM_USER  18  + ; inline
: TTM_SETTIPBKCOLOR ( -- n ) WM_USER  19  + ; inline
: TTM_SETTIPTEXTCOLOR ( -- n ) WM_USER  20  + ; inline
: TTM_GETDELAYTIME ( -- n ) WM_USER  21  + ; inline
: TTM_GETTIPBKCOLOR ( -- n ) WM_USER  22  + ; inline
: TTM_GETTIPTEXTCOLOR ( -- n ) WM_USER  23  + ; inline
: TTM_SETMAXTIPWIDTH ( -- n ) WM_USER  24  + ; inline
: TTM_GETMAXTIPWIDTH ( -- n ) WM_USER  25  + ; inline
: TTM_SETMARGIN ( -- n ) WM_USER  26  + ; inline
: TTM_GETMARGIN ( -- n ) WM_USER  27  + ; inline
: TTM_POP ( -- n ) WM_USER  28  + ; inline
: TTM_UPDATE ( -- n ) WM_USER  29  + ; inline
: TTM_GETBUBBLESIZE ( -- n ) WM_USER  30  + ; inline
: TTM_ADJUSTRECT ( -- n ) WM_USER  31  + ; inline
: TTM_SETTITLEA ( -- n ) WM_USER  32  + ; inline
: TTM_SETTITLEW ( -- n ) WM_USER  33  + ; inline
: TTM_POPUP ( -- n ) WM_USER  34  + ; inline
: TTM_GETTITLE ( -- n ) WM_USER  35  + ; inline
ALIAS: TTM_SETWINDOWTHEME CCM_SETWINDOWTHEME
: SB_SETTEXTA ( -- n ) WM_USER 1 + ; inline
: SB_SETTEXTW ( -- n ) WM_USER 11  + ; inline
: SB_GETTEXTA ( -- n ) WM_USER 2  + ; inline
: SB_GETTEXTW ( -- n ) WM_USER 13  + ; inline
: SB_GETTEXTLENGTHA ( -- n ) WM_USER 3  + ; inline
: SB_GETTEXTLENGTHW ( -- n ) WM_USER 12  + ; inline
: SB_SETPARTS ( -- n ) WM_USER 4  + ; inline
: SB_GETPARTS ( -- n ) WM_USER 6  + ; inline
: SB_GETBORDERS ( -- n ) WM_USER 7  + ; inline
: SB_SETMINHEIGHT ( -- n ) WM_USER 8  + ; inline
: SB_SIMPLE ( -- n ) WM_USER 9  + ; inline
: SB_GETRECT ( -- n ) WM_USER 10  + ; inline
: SB_ISSIMPLE ( -- n ) WM_USER 14  + ; inline
: SB_SETICON ( -- n ) WM_USER 15  + ; inline
: SB_SETTIPTEXTA ( -- n ) WM_USER 16  + ; inline
: SB_SETTIPTEXTW ( -- n ) WM_USER 17  + ; inline
: SB_GETTIPTEXTA ( -- n ) WM_USER 18  + ; inline
: SB_GETTIPTEXTW ( -- n ) WM_USER 19  + ; inline
: SB_GETICON ( -- n ) WM_USER 20  + ; inline
CONSTANT: SB_SETUNICODEFORMAT CCM_SETUNICODEFORMAT
CONSTANT: SB_GETUNICODEFORMAT CCM_GETUNICODEFORMAT
ALIAS: SB_SETBKCOLOR CCM_SETBKCOLOR
CONSTANT: SB_SIMPLEID 0x00ff
ALIAS: TBM_GETPOS WM_USER
: TBM_GETRANGEMIN ( -- n ) WM_USER 1  + ; inline
: TBM_GETRANGEMAX ( -- n ) WM_USER 2  + ; inline
: TBM_GETTIC ( -- n ) WM_USER 3  + ; inline
: TBM_SETTIC ( -- n ) WM_USER 4  + ; inline
: TBM_SETPOS ( -- n ) WM_USER 5  + ; inline
: TBM_SETRANGE ( -- n ) WM_USER 6  + ; inline
: TBM_SETRANGEMIN ( -- n ) WM_USER 7  + ; inline
: TBM_SETRANGEMAX ( -- n ) WM_USER 8  + ; inline
: TBM_CLEARTICS ( -- n ) WM_USER 9  + ; inline
: TBM_SETSEL ( -- n ) WM_USER 10  + ; inline
: TBM_SETSELSTART ( -- n ) WM_USER 11  + ; inline
: TBM_SETSELEND ( -- n ) WM_USER 12  + ; inline
: TBM_GETPTICS ( -- n ) WM_USER 14  + ; inline
: TBM_GETTICPOS ( -- n ) WM_USER 15  + ; inline
: TBM_GETNUMTICS ( -- n ) WM_USER 16  + ; inline
: TBM_GETSELSTART ( -- n ) WM_USER 17  + ; inline
: TBM_GETSELEND ( -- n ) WM_USER 18  + ; inline
: TBM_CLEARSEL ( -- n ) WM_USER 19  + ; inline
: TBM_SETTICFREQ ( -- n ) WM_USER 20  + ; inline
: TBM_SETPAGESIZE ( -- n ) WM_USER 21  + ; inline
: TBM_GETPAGESIZE ( -- n ) WM_USER 22  + ; inline
: TBM_SETLINESIZE ( -- n ) WM_USER 23  + ; inline
: TBM_GETLINESIZE ( -- n ) WM_USER 24  + ; inline
: TBM_GETTHUMBRECT ( -- n ) WM_USER 25  + ; inline
: TBM_GETCHANNELRECT ( -- n ) WM_USER 26  + ; inline
: TBM_SETTHUMBLENGTH ( -- n ) WM_USER 27  + ; inline
: TBM_GETTHUMBLENGTH ( -- n ) WM_USER 28  + ; inline
: TBM_SETTOOLTIPS ( -- n ) WM_USER 29  + ; inline
: TBM_GETTOOLTIPS ( -- n ) WM_USER 30  + ; inline
: TBM_SETTIPSIDE ( -- n ) WM_USER 31  + ; inline
: TBM_SETBUDDY ( -- n ) WM_USER 32  + ; inline
: TBM_GETBUDDY ( -- n ) WM_USER 33  + ; inline
ALIAS: TBM_SETUNICODEFORMAT CCM_SETUNICODEFORMAT
ALIAS: TBM_GETUNICODEFORMAT CCM_GETUNICODEFORMAT
: DL_BEGINDRAG ( -- n ) WM_USER 133  + ; inline
: DL_DRAGGING ( -- n ) WM_USER 134  + ; inline
: DL_DROPPED ( -- n ) WM_USER 135  + ; inline
: DL_CANCELDRAG ( -- n ) WM_USER 136  + ; inline
: UDM_SETRANGE ( -- n ) WM_USER 101  + ; inline
: UDM_GETRANGE ( -- n ) WM_USER 102  + ; inline
: UDM_SETPOS ( -- n ) WM_USER 103  + ; inline
: UDM_GETPOS ( -- n ) WM_USER 104  + ; inline
: UDM_SETBUDDY ( -- n ) WM_USER 105  + ; inline
: UDM_GETBUDDY ( -- n ) WM_USER 106  + ; inline
: UDM_SETACCEL ( -- n ) WM_USER 107  + ; inline
: UDM_GETACCEL ( -- n ) WM_USER 108  + ; inline
: UDM_SETBASE ( -- n ) WM_USER 109  + ; inline
: UDM_GETBASE ( -- n ) WM_USER 110  + ; inline
: UDM_SETRANGE32 ( -- n ) WM_USER 111  + ; inline
: UDM_GETRANGE32 ( -- n ) WM_USER 112  + ; inline
ALIAS: UDM_SETUNICODEFORMAT CCM_SETUNICODEFORMAT
ALIAS: UDM_GETUNICODEFORMAT CCM_GETUNICODEFORMAT
: UDM_SETPOS32 ( -- n ) WM_USER 113  + ; inline
: UDM_GETPOS32 ( -- n ) WM_USER 114  + ; inline
: PBM_SETRANGE ( -- n ) WM_USER 1  + ; inline
: PBM_SETPOS ( -- n ) WM_USER 2  + ; inline
: PBM_DELTAPOS ( -- n ) WM_USER 3  + ; inline
: PBM_SETSTEP ( -- n ) WM_USER 4  + ; inline
: PBM_STEPIT ( -- n ) WM_USER 5  + ; inline
: PBM_SETRANGE32 ( -- n ) WM_USER 6  + ; inline
: PBM_GETRANGE ( -- n ) WM_USER 7  + ; inline
: PBM_GETPOS ( -- n ) WM_USER 8  + ; inline
: PBM_SETBARCOLOR ( -- n ) WM_USER 9  + ; inline
ALIAS: PBM_SETBKCOLOR CCM_SETBKCOLOR
: HKM_SETHOTKEY ( -- n ) WM_USER 1  + ; inline
: HKM_GETHOTKEY ( -- n ) WM_USER 2  + ; inline
: HKM_SETRULES ( -- n ) WM_USER 3  + ; inline
ALIAS: LVM_SETUNICODEFORMAT CCM_SETUNICODEFORMAT
ALIAS: LVM_GETUNICODEFORMAT CCM_GETUNICODEFORMAT
: LVM_GETBKCOLOR ( -- n ) LVM_FIRST  0  + ; inline
: LVM_SETBKCOLOR ( -- n ) LVM_FIRST  1  + ; inline
: LVM_GETIMAGELIST ( -- n ) LVM_FIRST  2  + ; inline
: LVM_SETIMAGELIST ( -- n ) LVM_FIRST  3  + ; inline
: LVM_GETITEMCOUNT ( -- n ) LVM_FIRST  4  + ; inline
: LVM_GETITEMA ( -- n ) LVM_FIRST  5  + ; inline
: LVM_GETITEMW ( -- n ) LVM_FIRST  75  + ; inline
: LVM_SETITEMA ( -- n ) LVM_FIRST  6  + ; inline
: LVM_SETITEMW ( -- n ) LVM_FIRST  76  + ; inline
: LVM_INSERTITEMA ( -- n ) LVM_FIRST  7  + ; inline
: LVM_INSERTITEMW ( -- n ) LVM_FIRST  77  + ; inline
: LVM_DELETEITEM ( -- n ) LVM_FIRST  8  + ; inline
: LVM_DELETEALLITEMS ( -- n ) LVM_FIRST  9  + ; inline
: LVM_GETCALLBACKMASK ( -- n ) LVM_FIRST  10  + ; inline
: LVM_SETCALLBACKMASK ( -- n ) LVM_FIRST  11  + ; inline
: LVM_FINDITEMA ( -- n ) LVM_FIRST  13  + ; inline
: LVM_FINDITEMW ( -- n ) LVM_FIRST  83  + ; inline
: LVM_GETITEMRECT ( -- n ) LVM_FIRST  14  + ; inline
: LVM_SETITEMPOSITION ( -- n ) LVM_FIRST  15  + ; inline
: LVM_GETITEMPOSITION ( -- n ) LVM_FIRST  16  + ; inline
: LVM_GETSTRINGWIDTHA ( -- n ) LVM_FIRST  17  + ; inline
: LVM_GETSTRINGWIDTHW ( -- n ) LVM_FIRST  87  + ; inline
: LVM_HITTEST ( -- n ) LVM_FIRST  18  + ; inline
: LVM_ENSUREVISIBLE ( -- n ) LVM_FIRST  19  + ; inline
: LVM_SCROLL ( -- n ) LVM_FIRST  20  + ; inline
: LVM_REDRAWITEMS ( -- n ) LVM_FIRST  21  + ; inline
: LVM_ARRANGE ( -- n ) LVM_FIRST  22  + ; inline
: LVM_EDITLABELA ( -- n ) LVM_FIRST  23  + ; inline
: LVM_EDITLABELW ( -- n ) LVM_FIRST  118  + ; inline
: LVM_GETEDITCONTROL ( -- n ) LVM_FIRST  24  + ; inline
: LVM_GETCOLUMNA ( -- n ) LVM_FIRST  25  + ; inline
: LVM_GETCOLUMNW ( -- n ) LVM_FIRST  95  + ; inline
: LVM_SETCOLUMNA ( -- n ) LVM_FIRST  26  + ; inline
: LVM_SETCOLUMNW ( -- n ) LVM_FIRST  96  + ; inline
: LVM_INSERTCOLUMNA ( -- n ) LVM_FIRST  27  + ; inline
: LVM_INSERTCOLUMNW ( -- n ) LVM_FIRST  97  + ; inline
: LVM_DELETECOLUMN ( -- n ) LVM_FIRST  28  + ; inline
: LVM_GETCOLUMNWIDTH ( -- n ) LVM_FIRST  29  + ; inline
: LVM_SETCOLUMNWIDTH ( -- n ) LVM_FIRST  30  + ; inline
: LVM_CREATEDRAGIMAGE ( -- n ) LVM_FIRST  33  + ; inline
: LVM_GETVIEWRECT ( -- n ) LVM_FIRST  34  + ; inline
: LVM_GETTEXTCOLOR ( -- n ) LVM_FIRST  35  + ; inline
: LVM_SETTEXTCOLOR ( -- n ) LVM_FIRST  36  + ; inline
: LVM_GETTEXTBKCOLOR ( -- n ) LVM_FIRST  37  + ; inline
: LVM_SETTEXTBKCOLOR ( -- n ) LVM_FIRST  38  + ; inline
: LVM_GETTOPINDEX ( -- n ) LVM_FIRST  39  + ; inline
: LVM_GETCOUNTPERPAGE ( -- n ) LVM_FIRST  40  + ; inline
: LVM_GETORIGIN ( -- n ) LVM_FIRST  41  + ; inline
: LVM_UPDATE ( -- n ) LVM_FIRST  42  + ; inline
: LVM_SETITEMSTATE ( -- n ) LVM_FIRST  43  + ; inline
: LVM_GETITEMSTATE ( -- n ) LVM_FIRST  44  + ; inline
: LVM_GETITEMTEXTA ( -- n ) LVM_FIRST  45  + ; inline
: LVM_GETITEMTEXTW ( -- n ) LVM_FIRST  115  + ; inline
: LVM_SETITEMTEXTA ( -- n ) LVM_FIRST  46  + ; inline
: LVM_SETITEMTEXTW ( -- n ) LVM_FIRST  116  + ; inline
: LVM_SETITEMCOUNT ( -- n ) LVM_FIRST  47  + ; inline
: LVM_SORTITEMS ( -- n ) LVM_FIRST  48  + ; inline
: LVM_SETITEMPOSITION32 ( -- n ) LVM_FIRST  49  + ; inline
: LVM_GETSELECTEDCOUNT ( -- n ) LVM_FIRST  50  + ; inline
: LVM_GETITEMSPACING ( -- n ) LVM_FIRST  51  + ; inline
: LVM_GETISEARCHSTRINGA ( -- n ) LVM_FIRST  52  + ; inline
: LVM_GETISEARCHSTRINGW ( -- n ) LVM_FIRST  117  + ; inline
: LVM_SETICONSPACING ( -- n ) LVM_FIRST  53  + ; inline
: LVM_SETEXTENDEDLISTVIEWSTYLE ( -- n ) LVM_FIRST  54  + ; inline
: LVM_GETEXTENDEDLISTVIEWSTYLE ( -- n ) LVM_FIRST  55  + ; inline
: LVM_GETSUBITEMRECT ( -- n ) LVM_FIRST  56  + ; inline
: LVM_SUBITEMHITTEST ( -- n ) LVM_FIRST  57  + ; inline
: LVM_SETCOLUMNORDERARRAY ( -- n ) LVM_FIRST  58  + ; inline
: LVM_GETCOLUMNORDERARRAY ( -- n ) LVM_FIRST  59  + ; inline
: LVM_SETHOTITEM ( -- n ) LVM_FIRST  60  + ; inline
: LVM_GETHOTITEM ( -- n ) LVM_FIRST  61  + ; inline
: LVM_SETHOTCURSOR ( -- n ) LVM_FIRST  62  + ; inline
: LVM_GETHOTCURSOR ( -- n ) LVM_FIRST  63  + ; inline
: LVM_APPROXIMATEVIEWRECT ( -- n ) LVM_FIRST  64  + ; inline
: LVM_SETWORKAREAS ( -- n ) LVM_FIRST  65  + ; inline
: LVM_GETWORKAREAS ( -- n ) LVM_FIRST  70  + ; inline
: LVM_GETNUMBEROFWORKAREAS ( -- n ) LVM_FIRST  73  + ; inline
: LVM_GETSELECTIONMARK ( -- n ) LVM_FIRST  66  + ; inline
: LVM_SETSELECTIONMARK ( -- n ) LVM_FIRST  67  + ; inline
: LVM_SETHOVERTIME ( -- n ) LVM_FIRST  71  + ; inline
: LVM_GETHOVERTIME ( -- n ) LVM_FIRST  72  + ; inline
: LVM_SETTOOLTIPS ( -- n ) LVM_FIRST  74  + ; inline
: LVM_GETTOOLTIPS ( -- n ) LVM_FIRST  78  + ; inline
: LVM_SORTITEMSEX ( -- n ) LVM_FIRST  81  + ; inline
: LVM_SETBKIMAGEA ( -- n ) LVM_FIRST  68  + ; inline
: LVM_SETBKIMAGEW ( -- n ) LVM_FIRST  138  + ; inline
: LVM_GETBKIMAGEA ( -- n ) LVM_FIRST  69  + ; inline
: LVM_GETBKIMAGEW ( -- n ) LVM_FIRST  139  + ; inline
: LVM_SETSELECTEDCOLUMN ( -- n ) LVM_FIRST  140  + ; inline
: LVM_SETTILEWIDTH ( -- n ) LVM_FIRST  141  + ; inline
: LVM_SETVIEW ( -- n ) LVM_FIRST  142  + ; inline
: LVM_GETVIEW ( -- n ) LVM_FIRST  143  + ; inline
: LVM_INSERTGROUP ( -- n ) LVM_FIRST  145  + ; inline
: LVM_SETGROUPINFO ( -- n ) LVM_FIRST  147  + ; inline
: LVM_GETGROUPINFO ( -- n ) LVM_FIRST  149  + ; inline
: LVM_REMOVEGROUP ( -- n ) LVM_FIRST  150  + ; inline
: LVM_MOVEGROUP ( -- n ) LVM_FIRST  151  + ; inline
: LVM_MOVEITEMTOGROUP ( -- n ) LVM_FIRST  154  + ; inline
: LVM_SETGROUPMETRICS ( -- n ) LVM_FIRST  155  + ; inline
: LVM_GETGROUPMETRICS ( -- n ) LVM_FIRST  156  + ; inline
: LVM_ENABLEGROUPVIEW ( -- n ) LVM_FIRST  157  + ; inline
: LVM_SORTGROUPS ( -- n ) LVM_FIRST  158  + ; inline
: LVM_INSERTGROUPSORTED ( -- n ) LVM_FIRST  159  + ; inline
: LVM_REMOVEALLGROUPS ( -- n ) LVM_FIRST  160  + ; inline
: LVM_HASGROUP ( -- n ) LVM_FIRST  161  + ; inline
: LVM_SETTILEVIEWINFO ( -- n ) LVM_FIRST  162  + ; inline
: LVM_GETTILEVIEWINFO ( -- n ) LVM_FIRST  163  + ; inline
: LVM_SETTILEINFO ( -- n ) LVM_FIRST  164  + ; inline
: LVM_GETTILEINFO ( -- n ) LVM_FIRST  165  + ; inline
: LVM_SETINSERTMARK ( -- n ) LVM_FIRST  166  + ; inline
: LVM_GETINSERTMARK ( -- n ) LVM_FIRST  167  + ; inline
: LVM_INSERTMARKHITTEST ( -- n ) LVM_FIRST  168  + ; inline
: LVM_GETINSERTMARKRECT ( -- n ) LVM_FIRST  169  + ; inline
: LVM_SETINSERTMARKCOLOR ( -- n ) LVM_FIRST  170  + ; inline
: LVM_GETINSERTMARKCOLOR ( -- n ) LVM_FIRST  171  + ; inline
: LVM_SETINFOTIP ( -- n ) LVM_FIRST  173  + ; inline
: LVM_GETSELECTEDCOLUMN ( -- n ) LVM_FIRST  174  + ; inline
: LVM_ISGROUPVIEWENABLED ( -- n ) LVM_FIRST  175  + ; inline
: LVM_GETOUTLINECOLOR ( -- n ) LVM_FIRST  176  + ; inline
: LVM_SETOUTLINECOLOR ( -- n ) LVM_FIRST  177  + ; inline
: LVM_CANCELEDITLABEL ( -- n ) LVM_FIRST  179  + ; inline
: LVM_MAPINDEXTOID ( -- n ) LVM_FIRST  180  + ; inline
: LVM_MAPIDTOINDEX ( -- n ) LVM_FIRST  181  + ; inline
: TVM_INSERTITEMA ( -- n ) TV_FIRST  0  + ; inline
: TVM_INSERTITEMW ( -- n ) TV_FIRST  50  + ; inline
: TVM_DELETEITEM ( -- n ) TV_FIRST  1  + ; inline
: TVM_EXPAND ( -- n ) TV_FIRST  2  + ; inline
: TVM_GETITEMRECT ( -- n ) TV_FIRST  4  + ; inline
: TVM_GETCOUNT ( -- n ) TV_FIRST  5  + ; inline
: TVM_GETINDENT ( -- n ) TV_FIRST  6  + ; inline
: TVM_SETINDENT ( -- n ) TV_FIRST  7  + ; inline
: TVM_GETIMAGELIST ( -- n ) TV_FIRST  8  + ; inline
: TVM_SETIMAGELIST ( -- n ) TV_FIRST  9  + ; inline
: TVM_GETNEXTITEM ( -- n ) TV_FIRST  10  + ; inline
: TVM_SELECTITEM ( -- n ) TV_FIRST  11  + ; inline
: TVM_GETITEMA ( -- n ) TV_FIRST  12  + ; inline
: TVM_GETITEMW ( -- n ) TV_FIRST  62  + ; inline
: TVM_SETITEMA ( -- n ) TV_FIRST  13  + ; inline
: TVM_SETITEMW ( -- n ) TV_FIRST  63  + ; inline
: TVM_EDITLABELA ( -- n ) TV_FIRST  14  + ; inline
: TVM_EDITLABELW ( -- n ) TV_FIRST  65  + ; inline
: TVM_GETEDITCONTROL ( -- n ) TV_FIRST  15  + ; inline
: TVM_GETVISIBLECOUNT ( -- n ) TV_FIRST  16  + ; inline
: TVM_HITTEST ( -- n ) TV_FIRST  17  + ; inline
: TVM_CREATEDRAGIMAGE ( -- n ) TV_FIRST  18  + ; inline
: TVM_SORTCHILDREN ( -- n ) TV_FIRST  19  + ; inline
: TVM_ENSUREVISIBLE ( -- n ) TV_FIRST  20  + ; inline
: TVM_SORTCHILDRENCB ( -- n ) TV_FIRST  21  + ; inline
: TVM_ENDEDITLABELNOW ( -- n ) TV_FIRST  22  + ; inline
: TVM_GETISEARCHSTRINGA ( -- n ) TV_FIRST  23  + ; inline
: TVM_GETISEARCHSTRINGW ( -- n ) TV_FIRST  64  + ; inline
: TVM_SETTOOLTIPS ( -- n ) TV_FIRST  24  + ; inline
: TVM_GETTOOLTIPS ( -- n ) TV_FIRST  25  + ; inline
: TVM_SETINSERTMARK ( -- n ) TV_FIRST  26  + ; inline
ALIAS: TVM_SETUNICODEFORMAT CCM_SETUNICODEFORMAT
ALIAS: TVM_GETUNICODEFORMAT CCM_GETUNICODEFORMAT
: TVM_SETITEMHEIGHT ( -- n ) TV_FIRST  27  + ; inline
: TVM_GETITEMHEIGHT ( -- n ) TV_FIRST  28  + ; inline
: TVM_SETBKCOLOR ( -- n ) TV_FIRST  29  + ; inline
: TVM_SETTEXTCOLOR ( -- n ) TV_FIRST  30  + ; inline
: TVM_GETBKCOLOR ( -- n ) TV_FIRST  31  + ; inline
: TVM_GETTEXTCOLOR ( -- n ) TV_FIRST  32  + ; inline
: TVM_SETSCROLLTIME ( -- n ) TV_FIRST  33  + ; inline
: TVM_GETSCROLLTIME ( -- n ) TV_FIRST  34  + ; inline
: TVM_SETINSERTMARKCOLOR ( -- n ) TV_FIRST  37  + ; inline
: TVM_GETINSERTMARKCOLOR ( -- n ) TV_FIRST  38  + ; inline
: TVM_GETITEMSTATE ( -- n ) TV_FIRST  39  + ; inline
: TVM_SETLINECOLOR ( -- n ) TV_FIRST  40  + ; inline
: TVM_GETLINECOLOR ( -- n ) TV_FIRST  41  + ; inline
: TVM_MAPACCIDTOHTREEITEM ( -- n ) TV_FIRST  42  + ; inline
: TVM_MAPHTREEITEMTOACCID ( -- n ) TV_FIRST  43  + ; inline
: CBEM_INSERTITEMA ( -- n ) WM_USER  1  + ; inline
: CBEM_SETIMAGELIST ( -- n ) WM_USER  2  + ; inline
: CBEM_GETIMAGELIST ( -- n ) WM_USER  3  + ; inline
: CBEM_GETITEMA ( -- n ) WM_USER  4  + ; inline
: CBEM_SETITEMA ( -- n ) WM_USER  5  + ; inline
ALIAS: CBEM_DELETEITEM CB_DELETESTRING
: CBEM_GETCOMBOCONTROL ( -- n ) WM_USER  6  + ; inline
: CBEM_GETEDITCONTROL ( -- n ) WM_USER  7  + ; inline
: CBEM_SETEXTENDEDSTYLE ( -- n ) WM_USER  14  + ; inline
: CBEM_GETEXTENDEDSTYLE ( -- n ) WM_USER  9  + ; inline
ALIAS: CBEM_SETUNICODEFORMAT CCM_SETUNICODEFORMAT
ALIAS: CBEM_GETUNICODEFORMAT CCM_GETUNICODEFORMAT
: CBEM_SETEXSTYLE ( -- n ) WM_USER  8  + ; inline
: CBEM_GETEXSTYLE ( -- n ) WM_USER  9  + ; inline
: CBEM_HASEDITCHANGED ( -- n ) WM_USER  10  + ; inline
: CBEM_INSERTITEMW ( -- n ) WM_USER  11  + ; inline
: CBEM_SETITEMW ( -- n ) WM_USER  12  + ; inline
: CBEM_GETITEMW ( -- n ) WM_USER  13  + ; inline
: TCM_GETIMAGELIST ( -- n ) TCM_FIRST  2  + ; inline
: TCM_SETIMAGELIST ( -- n ) TCM_FIRST  3  + ; inline
: TCM_GETITEMCOUNT ( -- n ) TCM_FIRST  4  + ; inline
: TCM_GETITEMA ( -- n ) TCM_FIRST  5  + ; inline
: TCM_GETITEMW ( -- n ) TCM_FIRST  60  + ; inline
: TCM_SETITEMA ( -- n ) TCM_FIRST  6  + ; inline
: TCM_SETITEMW ( -- n ) TCM_FIRST  61  + ; inline
: TCM_INSERTITEMA ( -- n ) TCM_FIRST  7  + ; inline
: TCM_INSERTITEMW ( -- n ) TCM_FIRST  62  + ; inline
: TCM_DELETEITEM ( -- n ) TCM_FIRST  8  + ; inline
: TCM_DELETEALLITEMS ( -- n ) TCM_FIRST  9  + ; inline
: TCM_GETITEMRECT ( -- n ) TCM_FIRST  10  + ; inline
: TCM_GETCURSEL ( -- n ) TCM_FIRST  11  + ; inline
: TCM_SETCURSEL ( -- n ) TCM_FIRST  12  + ; inline
: TCM_HITTEST ( -- n ) TCM_FIRST  13  + ; inline
: TCM_SETITEMEXTRA ( -- n ) TCM_FIRST  14  + ; inline
: TCM_ADJUSTRECT ( -- n ) TCM_FIRST  40  + ; inline
: TCM_SETITEMSIZE ( -- n ) TCM_FIRST  41  + ; inline
: TCM_REMOVEIMAGE ( -- n ) TCM_FIRST  42  + ; inline
: TCM_SETPADDING ( -- n ) TCM_FIRST  43  + ; inline
: TCM_GETROWCOUNT ( -- n ) TCM_FIRST  44  + ; inline
: TCM_GETTOOLTIPS ( -- n ) TCM_FIRST  45  + ; inline
: TCM_SETTOOLTIPS ( -- n ) TCM_FIRST  46  + ; inline
: TCM_GETCURFOCUS ( -- n ) TCM_FIRST  47  + ; inline
: TCM_SETCURFOCUS ( -- n ) TCM_FIRST  48  + ; inline
: TCM_SETMINTABWIDTH ( -- n ) TCM_FIRST  49  + ; inline
: TCM_DESELECTALL ( -- n ) TCM_FIRST  50  + ; inline
: TCM_HIGHLIGHTITEM ( -- n ) TCM_FIRST  51  + ; inline
: TCM_SETEXTENDEDSTYLE ( -- n ) TCM_FIRST  52  + ; inline
: TCM_GETEXTENDEDSTYLE ( -- n ) TCM_FIRST  53  + ; inline
ALIAS: TCM_SETUNICODEFORMAT CCM_SETUNICODEFORMAT
ALIAS: TCM_GETUNICODEFORMAT CCM_GETUNICODEFORMAT
: ACM_OPENA ( -- n ) WM_USER 100  + ; inline
: ACM_OPENW ( -- n ) WM_USER 103  + ; inline
: ACM_PLAY ( -- n ) WM_USER 101  + ; inline
: ACM_STOP ( -- n ) WM_USER 102  + ; inline
CONSTANT: MCM_FIRST 0x1000
: MCM_GETCURSEL ( -- n ) MCM_FIRST  1  + ; inline
: MCM_SETCURSEL ( -- n ) MCM_FIRST  2  + ; inline
: MCM_GETMAXSELCOUNT ( -- n ) MCM_FIRST  3  + ; inline
: MCM_SETMAXSELCOUNT ( -- n ) MCM_FIRST  4  + ; inline
: MCM_GETSELRANGE ( -- n ) MCM_FIRST  5  + ; inline
: MCM_SETSELRANGE ( -- n ) MCM_FIRST  6  + ; inline
: MCM_GETMONTHRANGE ( -- n ) MCM_FIRST  7  + ; inline
: MCM_SETDAYSTATE ( -- n ) MCM_FIRST  8  + ; inline
: MCM_GETMINREQRECT ( -- n ) MCM_FIRST  9  + ; inline
: MCM_SETCOLOR ( -- n ) MCM_FIRST  10  + ; inline
: MCM_GETCOLOR ( -- n ) MCM_FIRST  11  + ; inline
: MCM_SETTODAY ( -- n ) MCM_FIRST  12  + ; inline
: MCM_GETTODAY ( -- n ) MCM_FIRST  13  + ; inline
: MCM_HITTEST ( -- n ) MCM_FIRST  14  + ; inline
: MCM_SETFIRSTDAYOFWEEK ( -- n ) MCM_FIRST  15  + ; inline
: MCM_GETFIRSTDAYOFWEEK ( -- n ) MCM_FIRST  16  + ; inline
: MCM_GETRANGE ( -- n ) MCM_FIRST  17  + ; inline
: MCM_SETRANGE ( -- n ) MCM_FIRST  18  + ; inline
: MCM_GETMONTHDELTA ( -- n ) MCM_FIRST  19  + ; inline
: MCM_SETMONTHDELTA ( -- n ) MCM_FIRST  20  + ; inline
: MCM_GETMAXTODAYWIDTH ( -- n ) MCM_FIRST  21  + ; inline
ALIAS: MCM_SETUNICODEFORMAT CCM_SETUNICODEFORMAT
ALIAS: MCM_GETUNICODEFORMAT CCM_GETUNICODEFORMAT
CONSTANT: DTM_FIRST 0x1000
: DTM_GETSYSTEMTIME ( -- n ) DTM_FIRST  1  + ; inline
: DTM_SETSYSTEMTIME ( -- n ) DTM_FIRST  2  + ; inline
: DTM_GETRANGE ( -- n ) DTM_FIRST  3  + ; inline
: DTM_SETRANGE ( -- n ) DTM_FIRST  4  + ; inline
: DTM_SETFORMATA ( -- n ) DTM_FIRST  5  + ; inline
: DTM_SETFORMATW ( -- n ) DTM_FIRST  50  + ; inline
: DTM_SETMCCOLOR ( -- n ) DTM_FIRST  6  + ; inline
: DTM_GETMCCOLOR ( -- n ) DTM_FIRST  7  + ; inline
: DTM_GETMONTHCAL ( -- n ) DTM_FIRST  8  + ; inline
: DTM_SETMCFONT ( -- n ) DTM_FIRST  9  + ; inline
: DTM_GETMCFONT ( -- n ) DTM_FIRST  10  + ; inline
: PGM_SETCHILD ( -- n ) PGM_FIRST  1  + ; inline
: PGM_RECALCSIZE ( -- n ) PGM_FIRST  2  + ; inline
: PGM_FORWARDMOUSE ( -- n ) PGM_FIRST  3  + ; inline
: PGM_SETBKCOLOR ( -- n ) PGM_FIRST  4  + ; inline
: PGM_GETBKCOLOR ( -- n ) PGM_FIRST  5  + ; inline
: PGM_SETBORDER ( -- n ) PGM_FIRST  6  + ; inline
: PGM_GETBORDER ( -- n ) PGM_FIRST  7  + ; inline
: PGM_SETPOS ( -- n ) PGM_FIRST  8  + ; inline
: PGM_GETPOS ( -- n ) PGM_FIRST  9  + ; inline
: PGM_SETBUTTONSIZE ( -- n ) PGM_FIRST  10  + ; inline
: PGM_GETBUTTONSIZE ( -- n ) PGM_FIRST  11  + ; inline
: PGM_GETBUTTONSTATE ( -- n ) PGM_FIRST  12  + ; inline
CONSTANT: PGM_GETDROPTARGET CCM_GETDROPTARGET
: BCM_GETIDEALSIZE ( -- n ) BCM_FIRST  1  + ; inline
: BCM_SETIMAGELIST ( -- n ) BCM_FIRST  2  + ; inline
: BCM_GETIMAGELIST ( -- n ) BCM_FIRST  3  + ; inline
: BCM_SETTEXTMARGIN ( -- n ) BCM_FIRST 4  + ; inline
: BCM_GETTEXTMARGIN ( -- n ) BCM_FIRST 5  + ; inline
: EM_SETCUEBANNER ( -- n ) ECM_FIRST  1 +  ; inline
: EM_GETCUEBANNER ( -- n ) ECM_FIRST  2 +  ; inline
: EM_SHOWBALLOONTIP ( -- n ) ECM_FIRST  3  + ; inline
: EM_HIDEBALLOONTIP ( -- n ) ECM_FIRST  4  + ; inline
: CB_SETMINVISIBLE ( -- n ) CBM_FIRST  1  + ; inline
: CB_GETMINVISIBLE ( -- n ) CBM_FIRST  2  + ; inline
: LM_HITTEST ( -- n ) WM_USER  0x0300  + ; inline
: LM_GETIDEALHEIGHT ( -- n ) WM_USER  0x0301  + ; inline
: LM_SETITEM ( -- n ) WM_USER  0x0302  + ; inline
: LM_GETITEM ( -- n ) WM_USER  0x0303  + ; inline



CONSTANT: WA_INACTIVE 0
CONSTANT: WA_ACTIVE 1
CONSTANT: WA_CLICKACTIVE 2

CONSTANT: SC_SIZE         0xf000
CONSTANT: SC_MOVE         0xf010
CONSTANT: SC_MINIMIZE     0xf020
CONSTANT: SC_MAXIMIZE     0xf030
CONSTANT: SC_NEXTWINDOW   0xf040
CONSTANT: SC_PREVWINDOW   0xf050
CONSTANT: SC_CLOSE        0xf060
CONSTANT: SC_VSCROLL      0xf070
CONSTANT: SC_HSCROLL      0xf080
CONSTANT: SC_MOUSEMENU    0xf090
CONSTANT: SC_KEYMENU      0xf100
CONSTANT: SC_ARRANGE      0xf110
CONSTANT: SC_RESTORE      0xf120
CONSTANT: SC_TASKLIST     0xf130
CONSTANT: SC_SCREENSAVE   0xf140
CONSTANT: SC_HOTKEY       0xf150

CONSTANT: APPCOMMAND_BROWSER_BACKWARD       1
CONSTANT: APPCOMMAND_BROWSER_FORWARD        2
CONSTANT: APPCOMMAND_BROWSER_REFRESH        3
CONSTANT: APPCOMMAND_BROWSER_STOP           4
CONSTANT: APPCOMMAND_BROWSER_SEARCH         5
CONSTANT: APPCOMMAND_BROWSER_FAVORITES      6
CONSTANT: APPCOMMAND_BROWSER_HOME           7
CONSTANT: APPCOMMAND_VOLUME_MUTE            8
CONSTANT: APPCOMMAND_VOLUME_DOWN            9
CONSTANT: APPCOMMAND_VOLUME_UP              10
CONSTANT: APPCOMMAND_MEDIA_NEXTTRACK        11
CONSTANT: APPCOMMAND_MEDIA_PREVIOUSTRACK    12
CONSTANT: APPCOMMAND_MEDIA_STOP             13
CONSTANT: APPCOMMAND_MEDIA_PLAY_PAUSE       14
CONSTANT: APPCOMMAND_LAUNCH_MAIL            15
CONSTANT: APPCOMMAND_LAUNCH_MEDIA_SELECT    16
CONSTANT: APPCOMMAND_LAUNCH_APP1            17
CONSTANT: APPCOMMAND_LAUNCH_APP2            18
CONSTANT: APPCOMMAND_BASS_DOWN              19
CONSTANT: APPCOMMAND_BASS_BOOST             20
CONSTANT: APPCOMMAND_BASS_UP                21
CONSTANT: APPCOMMAND_TREBLE_DOWN            22
CONSTANT: APPCOMMAND_TREBLE_UP              23
CONSTANT: APPCOMMAND_MICROPHONE_VOLUME_MUTE 24
CONSTANT: APPCOMMAND_MICROPHONE_VOLUME_DOWN 25
CONSTANT: APPCOMMAND_MICROPHONE_VOLUME_UP   26
CONSTANT: APPCOMMAND_HELP                   27
CONSTANT: APPCOMMAND_FIND                   28
CONSTANT: APPCOMMAND_NEW                    29
CONSTANT: APPCOMMAND_OPEN                   30
CONSTANT: APPCOMMAND_CLOSE                  31
CONSTANT: APPCOMMAND_SAVE                   32
CONSTANT: APPCOMMAND_PRINT                  33
CONSTANT: APPCOMMAND_UNDO                   34
CONSTANT: APPCOMMAND_REDO                   35
CONSTANT: APPCOMMAND_COPY                   36
CONSTANT: APPCOMMAND_CUT                    37
CONSTANT: APPCOMMAND_PASTE                  38
CONSTANT: APPCOMMAND_REPLY_TO_MAIL          39
CONSTANT: APPCOMMAND_FORWARD_MAIL           40
CONSTANT: APPCOMMAND_SEND_MAIL              41
CONSTANT: APPCOMMAND_SPELL_CHECK            42
CONSTANT: APPCOMMAND_DICTATE_OR_COMMAND_CONTROL_TOGGLE    43
CONSTANT: APPCOMMAND_MIC_ON_OFF_TOGGLE      44
CONSTANT: APPCOMMAND_CORRECTION_LIST        45
CONSTANT: APPCOMMAND_MEDIA_PLAY             46
CONSTANT: APPCOMMAND_MEDIA_PAUSE            47
CONSTANT: APPCOMMAND_MEDIA_RECORD           48
CONSTANT: APPCOMMAND_MEDIA_FAST_FORWARD     49
CONSTANT: APPCOMMAND_MEDIA_REWIND           50
CONSTANT: APPCOMMAND_MEDIA_CHANNEL_UP       51
CONSTANT: APPCOMMAND_MEDIA_CHANNEL_DOWN     52
CONSTANT: APPCOMMAND_DELETE                 53
CONSTANT: APPCOMMAND_DWM_FLIP3D             54

CONSTANT: FAPPCOMMAND_MOUSE 0x8000
CONSTANT: FAPPCOMMAND_KEY   0x0000
CONSTANT: FAPPCOMMAND_OEM   0x1000
CONSTANT: FAPPCOMMAND_MASK  0xF000
