/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.sctiming;

import java.util.HashMap;
import java.util.Map;

public class Table2D {
    private double[] rowVals;
    private double[] colVals;
    private String rowName;
    private String colName;
    private Map<String, double[][]> valuesMap;

    public Table2D(double[] rowVals, String rowName, double[] colVals, String colName) {
        this.rowVals = rowVals;
        this.colVals = colVals;
        this.rowName = rowName.toLowerCase();
        this.colName = colName.toLowerCase();
        this.valuesMap = new HashMap<String, double[][]>();
    }

    public String getRowName() {
        return this.rowName;
    }

    public String getColName() {
        return this.colName;
    }

    public int getNumRows() {
        return this.rowVals.length;
    }

    public int getNumCols() {
        return this.colVals.length;
    }

    public double[] getColIndexVals() {
        return this.colVals;
    }

    public double[] getRowIndexVals() {
        return this.rowVals;
    }

    public void setValue(double rowVal, double colVal, String dataKey, double value) {
        int i2;
        int i1;
        double[][] values = this.valuesMap.get(dataKey = dataKey.toLowerCase());
        if (values == null) {
            values = new double[this.rowVals.length][this.colVals.length];
            this.valuesMap.put(dataKey, values);
        }
        for (i1 = 0; i1 < this.rowVals.length && this.rowVals[i1] != rowVal; ++i1) {
        }
        if (i1 == this.rowVals.length) {
            System.out.println("Cannot find value " + rowVal + " in row values");
            return;
        }
        for (i2 = 0; i2 < this.colVals.length && this.colVals[i2] != colVal; ++i2) {
        }
        if (i2 == this.colVals.length) {
            System.out.println("Cannot find value " + colVal + " in column values");
            return;
        }
        values[i1][i2] = value;
    }

    public double getValue(double rowVal, double colVal, String dataKey) {
        int i2;
        int i1;
        double[][] values = this.valuesMap.get(dataKey = dataKey.toLowerCase());
        if (values == null) {
            System.out.println("Data key " + dataKey + " not found");
            return Double.MIN_VALUE;
        }
        for (i1 = 0; i1 < this.rowVals.length && this.rowVals[i1] != rowVal; ++i1) {
        }
        if (i1 == this.rowVals.length) {
            System.out.println("Cannot find value " + rowVal + " in row values");
            return Double.MIN_VALUE;
        }
        for (i2 = 0; i2 < this.colVals.length && this.colVals[i2] != colVal; ++i2) {
        }
        if (i2 == this.colVals.length) {
            System.out.println("Cannot find value " + colVal + " in column values");
            return Double.MIN_VALUE;
        }
        return values[i1][i2];
    }

    public void setData(String dataKey, double[][] data) {
        dataKey = dataKey.toLowerCase();
        if (data.length != this.rowVals.length) {
            return;
        }
        for (int i = 0; i < data.length; ++i) {
            if (data[i].length == this.colVals.length) continue;
            return;
        }
        this.valuesMap.put(dataKey, data);
    }

    public double[] getColumnValues(String key, int colIndex) {
        double[][] values = this.valuesMap.get(key = key.toLowerCase());
        if (values == null) {
            return null;
        }
        double[] col = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            col[i] = values[i][colIndex];
        }
        return col;
    }

    public double[] getRowValues(String key, int rowIndex) {
        double[][] values = this.valuesMap.get(key = key.toLowerCase());
        if (values == null) {
            return null;
        }
        return values[rowIndex];
    }

    public static double getAverage(double[] vals) {
        double total = 0.0;
        for (int i = 0; i < vals.length; ++i) {
            total += vals[i];
        }
        return total / (double)vals.length;
    }

    public static double getStandardDeviation(double[] vals) {
        double avg = Table2D.getAverage(vals);
        double total = 0.0;
        for (int i = 0; i < vals.length; ++i) {
            double diff2 = avg - vals[i];
            total += diff2 * diff2;
        }
        return Math.sqrt(total / (double)vals.length);
    }

    public static double getAverage(double[][] vals) {
        double total = 0.0;
        int count2 = 0;
        for (int i = 0; i < vals.length; ++i) {
            double[] row = vals[i];
            for (int j = 0; j < row.length; ++j) {
                total += row[j];
                ++count2;
            }
        }
        return total / (double)count2;
    }

    public static double getStandardDeviation(double[][] vals) {
        double avg = Table2D.getAverage(vals);
        double total = 0.0;
        int count2 = 0;
        for (int i = 0; i < vals.length; ++i) {
            double[] row = vals[i];
            for (int j = 0; j < row.length; ++j) {
                double diff2 = avg - row[j];
                total += diff2 * diff2;
                ++count2;
            }
        }
        return Math.sqrt(total / (double)count2);
    }

    public double getAvgColumnValue(String key, int colIndex) {
        double[][] values = this.valuesMap.get(key = key.toLowerCase());
        if (values == null) {
            return 0.0;
        }
        double total = 0.0;
        for (int i = 0; i < values.length; ++i) {
            double[] row = values[i];
            total += row[colIndex];
        }
        return total / (double)values.length;
    }

    public double[] getAvgColumnValues(String key) {
        key = key.toLowerCase();
        double[] avgvals = new double[this.colVals.length];
        for (int i = 0; i < this.colVals.length; ++i) {
            avgvals[i] = this.getAvgColumnValue(key, i);
        }
        return avgvals;
    }

    public double getAvgRowValue(String key, int rowIndex) {
        double[][] values = this.valuesMap.get(key = key.toLowerCase());
        if (values == null) {
            return 0.0;
        }
        double[] row = values[rowIndex];
        return Table2D.getAverage(row);
    }

    public double[] getAvgRowValues(String key) {
        key = key.toLowerCase();
        double[] avgvals = new double[this.rowVals.length];
        for (int i = 0; i < this.rowVals.length; ++i) {
            avgvals[i] = this.getAvgRowValue(key, i);
        }
        return avgvals;
    }

    public double[][] getValues(String key) {
        key = key.toLowerCase();
        return this.valuesMap.get(key);
    }

    public void print() {
        for (String s2 : this.valuesMap.keySet()) {
            this.print(s2);
        }
    }

    public void print(String key) {
        int i;
        key = key.toLowerCase();
        System.out.println("---------------------------------------------------");
        System.out.println(key + ":");
        System.out.println("---------------------------------------------------");
        double[][] values = this.valuesMap.get(key);
        if (values == null) {
            return;
        }
        System.out.println("\t" + this.colName);
        System.out.println(this.rowName);
        System.out.print("\t");
        for (i = 0; i < this.colVals.length; ++i) {
            System.out.print(this.colVals[i] + "\t");
        }
        System.out.println();
        for (i = 0; i < this.rowVals.length; ++i) {
            System.out.print(this.rowVals[i] + "\t");
            double[] vals = values[i];
            for (int i2 = 0; i2 < this.colVals.length; ++i2) {
                System.out.print(vals[i2] + "\t");
            }
            System.out.println();
        }
        System.out.println();
    }
}

