/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag.router;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.flag.router.Channel;
import com.sun.electric.tool.generator.flag.router.Segment;
import java.util.TreeSet;

public class Track {
    private final double center;
    private final int trackNdx;
    private final Channel channel;
    private TreeSet<Segment> segments = new TreeSet();

    public Track(double coord, Channel channel, int trackNdx) {
        this.center = coord;
        this.trackNdx = trackNdx;
        this.channel = channel;
    }

    public boolean isAvailable(double min2, double max2) {
        for (Segment s2 : this.segments) {
            if (s2.min > max2) {
                return true;
            }
            if (s2.max < min2) continue;
            return false;
        }
        return true;
    }

    private void sanityCheck() {
        Segment prev = null;
        for (Segment s2 : this.segments) {
            if (prev != null) {
                Job.error(prev.min >= s2.min, "illegally ordered segments");
                Job.error(prev.max > s2.min, "overlapping segments");
            }
            prev = s2;
        }
    }

    public Segment allocate(double min2, double max2) {
        Job.error(!this.isAvailable(min2, max2), "overlapping blockages");
        Segment seg = new Segment(min2, max2, this, this.trackNdx);
        this.segments.add(seg);
        this.sanityCheck();
        return seg;
    }

    public Segment allocateBiggest(double min2, double src, double max2) {
        Segment prev = null;
        Segment next2 = null;
        for (Segment s2 : this.segments) {
            if (s2.max <= src) {
                prev = s2;
            }
            if (s2.min <= src && src <= s2.max) {
                return null;
            }
            if (!(src <= s2.min)) continue;
            next2 = s2;
            break;
        }
        if (next2 != null) {
            max2 = Math.min(max2, next2.min);
        }
        if (prev != null) {
            min2 = Math.max(min2, prev.max);
        }
        return new Segment(min2, max2, this, this.trackNdx);
    }

    public boolean isHorizontal() {
        return this.channel.isHorizontal();
    }

    public double getCenter() {
        return this.center;
    }

    public int getIndex() {
        return this.trackNdx;
    }

    public void resort(Segment s2) {
        this.segments.remove(s2);
        this.segments.add(s2);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Track center: " + this.center + "\n");
        if (this.segments.size() != 0) {
            sb.append("      ");
            for (Segment s2 : this.segments) {
                sb.append(s2.toString() + "  ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

