/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.ilm.AllocateAction;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.MigrateAction;
import org.elasticsearch.xpack.core.ilm.OperationMode;
import org.elasticsearch.xpack.core.ilm.Phase;
import org.elasticsearch.xpack.core.ilm.PhaseCacheManagement;
import org.elasticsearch.xpack.core.ilm.PhaseExecutionInfo;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.ilm.IndexLifecycleTransition;

public final class MetadataMigrateToDataTiersRoutingService {
    public static final String DEFAULT_NODE_ATTRIBUTE_NAME = "data";
    private static final Logger logger = LogManager.getLogger(MetadataMigrateToDataTiersRoutingService.class);

    private MetadataMigrateToDataTiersRoutingService() {
    }

    public static Tuple<ClusterState, MigratedEntities> migrateToDataTiersRouting(ClusterState currentState, @Nullable String nodeAttrName, @Nullable String indexTemplateToDelete, NamedXContentRegistry xContentRegistry, Client client, XPackLicenseState licenseState) {
        IndexLifecycleMetadata currentMetadata = (IndexLifecycleMetadata)currentState.metadata().custom("index_lifecycle");
        if (currentMetadata != null && currentMetadata.getOperationMode() != OperationMode.STOPPED) {
            throw new IllegalStateException("stop ILM before migrating to data tiers, current state is [" + currentMetadata.getOperationMode() + "]");
        }
        Metadata.Builder mb = Metadata.builder((Metadata)currentState.metadata());
        mb.persistentSettings(Settings.builder().put(mb.persistentSettings()).put("cluster.routing.allocation.enforce_default_tier_preference", true).build());
        Settings.Builder transientSettingsBuilder = Settings.builder().put(mb.transientSettings());
        transientSettingsBuilder.remove("cluster.routing.allocation.enforce_default_tier_preference");
        mb.transientSettings(transientSettingsBuilder.build());
        String removedIndexTemplateName = null;
        if (Strings.hasText((String)indexTemplateToDelete)) {
            if (currentState.metadata().getTemplates().containsKey((Object)indexTemplateToDelete)) {
                mb.removeTemplate(indexTemplateToDelete);
                logger.debug("removing legacy template [{}]", (Object)indexTemplateToDelete);
                removedIndexTemplateName = indexTemplateToDelete;
            } else {
                logger.debug("legacy template [{}] does not exist", (Object)indexTemplateToDelete);
            }
        }
        String attribute = nodeAttrName;
        if (Strings.isNullOrEmpty((String)nodeAttrName)) {
            attribute = DEFAULT_NODE_ATTRIBUTE_NAME;
        }
        List<String> migratedPolicies = MetadataMigrateToDataTiersRoutingService.migrateIlmPolicies(mb, currentState, attribute, xContentRegistry, client, licenseState);
        ClusterState intermediateState = ClusterState.builder((ClusterState)currentState).metadata(mb).build();
        mb = Metadata.builder((Metadata)intermediateState.metadata());
        List<String> migratedIndices = MetadataMigrateToDataTiersRoutingService.migrateIndices(mb, intermediateState, attribute);
        return Tuple.tuple((Object)ClusterState.builder((ClusterState)currentState).metadata(mb).build(), (Object)new MigratedEntities(removedIndexTemplateName, migratedIndices, migratedPolicies));
    }

    static List<String> migrateIlmPolicies(Metadata.Builder mb, ClusterState currentState, String nodeAttrName, NamedXContentRegistry xContentRegistry, Client client, XPackLicenseState licenseState) {
        IndexLifecycleMetadata currentLifecycleMetadata = (IndexLifecycleMetadata)currentState.metadata().custom("index_lifecycle");
        if (currentLifecycleMetadata == null) {
            return Collections.emptyList();
        }
        ArrayList<String> migratedPolicies = new ArrayList<String>();
        Map currentPolicies = currentLifecycleMetadata.getPolicyMetadatas();
        TreeMap<String, LifecyclePolicyMetadata> newPolicies = new TreeMap<String, LifecyclePolicyMetadata>(currentPolicies);
        for (Map.Entry policyMetadataEntry : currentPolicies.entrySet()) {
            LifecyclePolicy newLifecyclePolicy = MetadataMigrateToDataTiersRoutingService.migrateSingleILMPolicy(nodeAttrName, ((LifecyclePolicyMetadata)policyMetadataEntry.getValue()).getPolicy());
            if (newLifecyclePolicy == null) continue;
            long nextVersion = ((LifecyclePolicyMetadata)policyMetadataEntry.getValue()).getVersion() + 1L;
            LifecyclePolicyMetadata newPolicyMetadata = new LifecyclePolicyMetadata(newLifecyclePolicy, ((LifecyclePolicyMetadata)policyMetadataEntry.getValue()).getHeaders(), nextVersion, Instant.now().toEpochMilli());
            LifecyclePolicyMetadata oldPolicyMetadata = newPolicies.put((String)policyMetadataEntry.getKey(), newPolicyMetadata);
            assert (oldPolicyMetadata != null) : "we must only update policies, not create new ones, but " + (String)policyMetadataEntry.getKey() + " didn't exist";
            MetadataMigrateToDataTiersRoutingService.refreshCachedPhases(mb, currentState, oldPolicyMetadata, newPolicyMetadata, xContentRegistry, client, licenseState);
            migratedPolicies.add((String)policyMetadataEntry.getKey());
        }
        if (migratedPolicies.size() > 0) {
            IndexLifecycleMetadata newMetadata = new IndexLifecycleMetadata(newPolicies, currentLifecycleMetadata.getOperationMode());
            mb.putCustom("index_lifecycle", (Metadata.Custom)newMetadata);
        }
        return migratedPolicies;
    }

    static void refreshCachedPhases(Metadata.Builder mb, ClusterState currentState, LifecyclePolicyMetadata oldPolicyMetadata, LifecyclePolicyMetadata newPolicyMetadata, NamedXContentRegistry xContentRegistry, Client client, XPackLicenseState licenseState) {
        PhaseCacheManagement.updateIndicesForPolicy((Metadata.Builder)mb, (ClusterState)currentState, (NamedXContentRegistry)xContentRegistry, (Client)client, (LifecyclePolicy)oldPolicyMetadata.getPolicy(), (LifecyclePolicyMetadata)newPolicyMetadata, (XPackLicenseState)licenseState);
        LifecyclePolicy newLifecyclePolicy = newPolicyMetadata.getPolicy();
        List<String> migratedPhasesWithoutAllocateAction = MetadataMigrateToDataTiersRoutingService.getMigratedPhasesWithoutAllocateAction(oldPolicyMetadata.getPolicy(), newLifecyclePolicy);
        if (migratedPhasesWithoutAllocateAction.size() > 0) {
            logger.debug("the updated policy [{}] does not contain the allocate action in phases [{}] anymore", (Object)newLifecyclePolicy.getName(), migratedPhasesWithoutAllocateAction);
            MetadataMigrateToDataTiersRoutingService.refreshCachedPhaseForPhasesWithoutAllocateAction(mb, currentState, oldPolicyMetadata.getPolicy(), newPolicyMetadata, migratedPhasesWithoutAllocateAction, client, licenseState);
        }
    }

    private static void refreshCachedPhaseForPhasesWithoutAllocateAction(Metadata.Builder mb, ClusterState currentState, LifecyclePolicy oldPolicy, LifecyclePolicyMetadata newPolicyMetadata, List<String> phasesWithoutAllocateAction, Client client, XPackLicenseState licenseState) {
        String policyName = oldPolicy.getName();
        List managedIndices = currentState.metadata().indices().values().stream().filter(meta -> policyName.equals(LifecycleSettings.LIFECYCLE_NAME_SETTING.get(meta.getSettings()))).collect(Collectors.toList());
        for (IndexMetadata indexMetadata : managedIndices) {
            Step.StepKey currentStepKey;
            LifecycleExecutionState currentExState = LifecycleExecutionState.fromIndexMetadata((IndexMetadata)indexMetadata);
            if (currentExState == null || (currentStepKey = LifecycleExecutionState.getCurrentStepKey((LifecycleExecutionState)currentExState)) == null || !phasesWithoutAllocateAction.contains(currentStepKey.getPhase())) continue;
            if (currentStepKey.getAction().equals("allocate")) {
                LifecycleExecutionState newLifecycleState = IndexLifecycleTransition.moveStateToNextActionAndUpdateCachedPhase(indexMetadata, currentExState, System::currentTimeMillis, oldPolicy, newPolicyMetadata, client, licenseState);
                if (currentExState.equals((Object)newLifecycleState)) continue;
                mb.put(IndexMetadata.builder((IndexMetadata)indexMetadata).putCustom("ilm", newLifecycleState.asMap()));
                continue;
            }
            LifecycleExecutionState.Builder updatedState = LifecycleExecutionState.builder((LifecycleExecutionState)currentExState);
            PhaseExecutionInfo phaseExecutionInfo = new PhaseExecutionInfo(newPolicyMetadata.getPolicy().getName(), (Phase)newPolicyMetadata.getPolicy().getPhases().get(currentStepKey.getPhase()), newPolicyMetadata.getVersion(), newPolicyMetadata.getModifiedDate());
            String newPhaseDefinition = Strings.toString((ToXContent)phaseExecutionInfo, (boolean)false, (boolean)false);
            updatedState.setPhaseDefinition(newPhaseDefinition);
            logger.debug("updating the cached phase definition for index [{}], current step [{}] in policy [{}] to [{}]", (Object)indexMetadata.getIndex().getName(), (Object)currentStepKey, (Object)policyName, (Object)newPhaseDefinition);
            mb.put(IndexMetadata.builder((IndexMetadata)indexMetadata).putCustom("ilm", updatedState.build().asMap()));
        }
    }

    private static List<String> getMigratedPhasesWithoutAllocateAction(LifecyclePolicy oldPolicy, LifecyclePolicy newLifecyclePolicy) {
        ArrayList<String> oldPhasesWithAllocateAction = new ArrayList<String>(oldPolicy.getPhases().size());
        for (Map.Entry phaseEntry : oldPolicy.getPhases().entrySet()) {
            if (!((Phase)phaseEntry.getValue()).getActions().containsKey("allocate")) continue;
            oldPhasesWithAllocateAction.add((String)phaseEntry.getKey());
        }
        ArrayList<String> migratedPhasesWithoutAllocateAction = new ArrayList<String>(oldPhasesWithAllocateAction.size());
        for (String phaseWithAllocateAction : oldPhasesWithAllocateAction) {
            Phase phase = (Phase)newLifecyclePolicy.getPhases().get(phaseWithAllocateAction);
            assert (phase != null) : "the migration service should not remove an entire phase altogether";
            if (phase.getActions().containsKey("allocate")) continue;
            migratedPhasesWithoutAllocateAction.add(phaseWithAllocateAction);
        }
        return migratedPhasesWithoutAllocateAction;
    }

    @Nullable
    private static LifecyclePolicy migrateSingleILMPolicy(String nodeAttrName, LifecyclePolicy lifecyclePolicy) {
        LifecyclePolicy newLifecyclePolicy = null;
        for (Map.Entry phaseEntry : lifecyclePolicy.getPhases().entrySet()) {
            MigrateAction migrateAction;
            Phase phase = (Phase)phaseEntry.getValue();
            AllocateAction allocateAction = (AllocateAction)phase.getActions().get("allocate");
            if (!MetadataMigrateToDataTiersRoutingService.allocateActionDefinesRoutingRules(nodeAttrName, allocateAction)) continue;
            HashMap<String, AllocateAction> actionMap = new HashMap<String, AllocateAction>(phase.getActions());
            if (allocateAction.getNumberOfReplicas() != null) {
                AllocateAction updatedAllocateAction = new AllocateAction(allocateAction.getNumberOfReplicas(), allocateAction.getTotalShardsPerNode(), null, null, null);
                actionMap.put(allocateAction.getWriteableName(), updatedAllocateAction);
                logger.debug("ILM policy [{}], phase [{}]: updated the allocate action to [{}]", (Object)lifecyclePolicy.getName(), (Object)phase.getName(), (Object)allocateAction);
            } else {
                actionMap.remove(allocateAction.getWriteableName());
                logger.debug("ILM policy [{}], phase [{}]: removed the allocate action", (Object)lifecyclePolicy.getName(), (Object)phase.getName());
            }
            if (actionMap.containsKey("migrate") && !(migrateAction = (MigrateAction)actionMap.get("migrate")).isEnabled()) {
                actionMap.remove("migrate");
                logger.debug("ILM policy [{}], phase [{}]: removed the deactivated migrate action", (Object)lifecyclePolicy.getName(), (Object)phase.getName());
            }
            Phase updatedPhase = new Phase(phase.getName(), phase.getMinimumAge(), actionMap);
            HashMap<String, Phase> updatedPhases = new HashMap<String, Phase>(newLifecyclePolicy == null ? lifecyclePolicy.getPhases() : newLifecyclePolicy.getPhases());
            updatedPhases.put((String)phaseEntry.getKey(), updatedPhase);
            newLifecyclePolicy = new LifecyclePolicy(lifecyclePolicy.getName(), updatedPhases);
        }
        return newLifecyclePolicy;
    }

    static boolean allocateActionDefinesRoutingRules(String nodeAttrName, @Nullable AllocateAction allocateAction) {
        return allocateAction != null && (allocateAction.getRequire().get(nodeAttrName) != null || allocateAction.getInclude().get(nodeAttrName) != null || allocateAction.getExclude().get(nodeAttrName) != null);
    }

    static List<String> migrateIndices(Metadata.Builder mb, ClusterState currentState, String nodeAttrName) {
        ArrayList<String> migratedIndices = new ArrayList<String>();
        String nodeAttrIndexRequireRoutingSetting = IndexMetadata.INDEX_ROUTING_REQUIRE_GROUP_SETTING.getKey() + nodeAttrName;
        String nodeAttrIndexIncludeRoutingSetting = IndexMetadata.INDEX_ROUTING_INCLUDE_GROUP_SETTING.getKey() + nodeAttrName;
        String nodeAttrIndexExcludeRoutingSetting = IndexMetadata.INDEX_ROUTING_EXCLUDE_GROUP_SETTING.getKey() + nodeAttrName;
        for (ObjectObjectCursor index : currentState.metadata().indices()) {
            IndexMetadata indexMetadata = (IndexMetadata)index.value;
            Settings currentSettings = indexMetadata.getSettings();
            boolean removeNodeAttrIndexRoutingSettings = true;
            Settings newSettings = MetadataMigrateToDataTiersRoutingService.maybeMigrateRoutingSettingToTierPreference(nodeAttrIndexRequireRoutingSetting, indexMetadata);
            if (newSettings.equals((Object)currentSettings)) {
                newSettings = MetadataMigrateToDataTiersRoutingService.maybeMigrateRoutingSettingToTierPreference(nodeAttrIndexIncludeRoutingSetting, indexMetadata);
            }
            if (newSettings.equals((Object)currentSettings)) {
                removeNodeAttrIndexRoutingSettings = false;
                newSettings = MetadataMigrateToDataTiersRoutingService.migrateToDefaultTierPreference(currentState, indexMetadata);
            }
            if (newSettings.equals((Object)currentSettings)) continue;
            Settings.Builder finalSettings = Settings.builder().put(newSettings);
            if (removeNodeAttrIndexRoutingSettings) {
                finalSettings.remove(nodeAttrIndexExcludeRoutingSetting);
                finalSettings.remove(nodeAttrIndexRequireRoutingSetting);
                finalSettings.remove(nodeAttrIndexIncludeRoutingSetting);
            }
            mb.put(IndexMetadata.builder((IndexMetadata)indexMetadata).settings(finalSettings).settingsVersion(indexMetadata.getSettingsVersion() + 1L));
            migratedIndices.add(indexMetadata.getIndex().getName());
        }
        return migratedIndices;
    }

    private static Settings maybeMigrateRoutingSettingToTierPreference(String attributeBasedRoutingSettingName, IndexMetadata indexMetadata) {
        Settings currentIndexSettings = indexMetadata.getSettings();
        if (!currentIndexSettings.keySet().contains(attributeBasedRoutingSettingName)) {
            return currentIndexSettings;
        }
        Settings.Builder newSettingsBuilder = Settings.builder().put(currentIndexSettings);
        String indexName = indexMetadata.getIndex().getName();
        if (currentIndexSettings.keySet().contains("index.routing.allocation.include._tier_preference")) {
            newSettingsBuilder.remove(attributeBasedRoutingSettingName);
            logger.debug("index [{}]: removed setting [{}]", (Object)indexName, (Object)attributeBasedRoutingSettingName);
        } else {
            String attributeValue = currentIndexSettings.get(attributeBasedRoutingSettingName);
            String convertedTierPreference = MetadataMigrateToDataTiersRoutingService.convertAttributeValueToTierPreference(attributeValue);
            if (convertedTierPreference != null) {
                newSettingsBuilder.put("index.routing.allocation.include._tier_preference", convertedTierPreference);
                newSettingsBuilder.remove(attributeBasedRoutingSettingName);
                logger.debug("index [{}]: removed setting [{}]", (Object)indexName, (Object)attributeBasedRoutingSettingName);
                logger.debug("index [{}]: configured setting [{}] to [{}]", (Object)indexName, (Object)"index.routing.allocation.include._tier_preference", (Object)convertedTierPreference);
            } else {
                logger.warn("index [{}]: could not convert attribute based setting [{}] value of [{}] to a tier preference configuration. the only known values are: {}", (Object)indexName, (Object)attributeBasedRoutingSettingName, (Object)attributeValue, (Object)"hot,warm,cold, and frozen");
                return currentIndexSettings;
            }
        }
        return newSettingsBuilder.build();
    }

    private static Settings migrateToDefaultTierPreference(ClusterState currentState, IndexMetadata indexMetadata) {
        Settings currentIndexSettings = indexMetadata.getSettings();
        List tierPreference = DataTier.parseTierList((String)currentIndexSettings.get("index.routing.allocation.include._tier_preference"));
        if (!tierPreference.isEmpty()) {
            return currentIndexSettings;
        }
        Settings.Builder newSettingsBuilder = Settings.builder().put(currentIndexSettings);
        String indexName = indexMetadata.getIndex().getName();
        boolean isDataStream = !currentState.metadata().findDataStreams(new String[]{indexName}).isEmpty();
        String convertedTierPreference = isDataStream ? "data_hot" : "data_content";
        newSettingsBuilder.put("index.routing.allocation.include._tier_preference", convertedTierPreference);
        logger.debug("index [{}]: configured setting [{}] to [{}]", (Object)indexName, (Object)"index.routing.allocation.include._tier_preference", (Object)convertedTierPreference);
        return newSettingsBuilder.build();
    }

    @Nullable
    static String convertAttributeValueToTierPreference(String nodeAttributeValue) {
        String targetTier = "data_" + nodeAttributeValue;
        if (!DataTier.validTierName((String)targetTier) || targetTier.equals("data_content")) {
            return null;
        }
        return DataTier.getPreferredTiersConfiguration((String)targetTier);
    }

    public static final class MigratedEntities {
        @Nullable
        public final String removedIndexTemplateName;
        public final List<String> migratedIndices;
        public final List<String> migratedPolicies;

        public MigratedEntities(@Nullable String removedIndexTemplateName, List<String> migratedIndices, List<String> migratedPolicies) {
            this.removedIndexTemplateName = removedIndexTemplateName;
            this.migratedIndices = Collections.unmodifiableList(migratedIndices);
            this.migratedPolicies = Collections.unmodifiableList(migratedPolicies);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MigratedEntities that = (MigratedEntities)o;
            return Objects.equals(this.removedIndexTemplateName, that.removedIndexTemplateName) && Objects.equals(this.migratedIndices, that.migratedIndices) && Objects.equals(this.migratedPolicies, that.migratedPolicies);
        }

        public int hashCode() {
            return Objects.hash(this.removedIndexTemplateName, this.migratedIndices, this.migratedPolicies);
        }
    }
}

