/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action;

import java.security.cert.X509Certificate;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.DelegatePkiAuthenticationRequest;
import org.elasticsearch.xpack.core.security.action.DelegatePkiAuthenticationResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.pki.X509AuthenticationToken;

public final class TransportDelegatePkiAuthenticationAction
extends HandledTransportAction<DelegatePkiAuthenticationRequest, DelegatePkiAuthenticationResponse> {
    private static final Logger logger = LogManager.getLogger(TransportDelegatePkiAuthenticationAction.class);
    private final ThreadPool threadPool;
    private final AuthenticationService authenticationService;
    private final TokenService tokenService;
    private final SecurityContext securityContext;

    @Inject
    public TransportDelegatePkiAuthenticationAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, AuthenticationService authenticationService, TokenService tokenService, SecurityContext securityContext) {
        super("cluster:admin/xpack/security/delegate_pki", transportService, actionFilters, DelegatePkiAuthenticationRequest::new);
        this.threadPool = threadPool;
        this.authenticationService = authenticationService;
        this.tokenService = tokenService;
        this.securityContext = securityContext;
    }

    protected void doExecute(Task task, DelegatePkiAuthenticationRequest request, ActionListener<DelegatePkiAuthenticationResponse> listener) {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        Authentication delegateeAuthentication = this.securityContext.getAuthentication();
        if (delegateeAuthentication == null) {
            listener.onFailure((Exception)new IllegalStateException("Delegatee authentication cannot be null"));
            return;
        }
        X509AuthenticationToken x509DelegatedToken = X509AuthenticationToken.delegated(request.getCertificateChain().toArray(new X509Certificate[0]), delegateeAuthentication);
        logger.trace("Attempting to authenticate delegated x509Token [{}]", (Object)x509DelegatedToken);
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            this.authenticationService.authenticate("cluster:admin/xpack/security/delegate_pki", (TransportRequest)request, x509DelegatedToken, (ActionListener<Authentication>)ActionListener.wrap(authentication -> {
                assert (authentication != null) : "authentication should never be null at this point";
                this.tokenService.createOAuth2Tokens((Authentication)authentication, delegateeAuthentication, Collections.emptyMap(), false, (ActionListener<TokenService.CreateTokenResult>)ActionListener.wrap(tokenResult -> {
                    TimeValue expiresIn = this.tokenService.getExpirationDelay();
                    listener.onResponse((Object)new DelegatePkiAuthenticationResponse(tokenResult.getAccessToken(), expiresIn, authentication));
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }, e -> {
                logger.debug(() -> new ParameterizedMessage("Delegated x509Token [{}] could not be authenticated", (Object)x509DelegatedToken), (Throwable)e);
                listener.onFailure(e);
            }));
        }
    }
}

