/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.predicate.regex;

import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.xpack.ql.expression.predicate.regex.StringPattern;

abstract class AbstractStringPattern
implements StringPattern {
    private Automaton automaton;

    AbstractStringPattern() {
    }

    abstract Automaton createAutomaton();

    private Automaton automaton() {
        if (this.automaton == null) {
            this.automaton = this.createAutomaton();
        }
        return this.automaton;
    }

    @Override
    public boolean matchesAll() {
        return Operations.isTotal(this.automaton());
    }

    @Override
    public String exactMatch() {
        IntsRef singleton = Operations.getSingleton(this.automaton());
        return singleton != null ? UnicodeUtil.newString(singleton.ints, singleton.offset, singleton.length) : null;
    }
}

