/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.transport.actions.get;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.watcher.support.xcontent.XContentSource;
import org.elasticsearch.xpack.core.watcher.watch.WatchStatus;

public class GetWatchResponse
extends ActionResponse
implements ToXContentObject {
    private String id;
    private WatchStatus status;
    private boolean found;
    private XContentSource source;
    private long version;
    private long seqNo;
    private long primaryTerm;

    public GetWatchResponse(StreamInput in) throws IOException {
        super(in);
        this.id = in.readString();
        this.found = in.readBoolean();
        if (this.found) {
            this.status = new WatchStatus(in);
            this.source = XContentSource.readFrom(in);
            this.version = in.readZLong();
            this.seqNo = in.readZLong();
            this.primaryTerm = in.readVLong();
        } else {
            this.status = null;
            this.source = null;
            this.version = -1L;
            this.seqNo = -2L;
            this.primaryTerm = 0L;
        }
    }

    public GetWatchResponse(String id) {
        this.id = id;
        this.status = null;
        this.found = false;
        this.source = null;
        this.version = -1L;
        this.seqNo = -2L;
        this.primaryTerm = 0L;
    }

    public GetWatchResponse(String id, long version, long seqNo, long primaryTerm, WatchStatus status, XContentSource source) {
        this.id = id;
        this.status = status;
        this.found = true;
        this.source = source;
        this.version = version;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
    }

    public String getId() {
        return this.id;
    }

    public WatchStatus getStatus() {
        return this.status;
    }

    public boolean isFound() {
        return this.found;
    }

    public XContentSource getSource() {
        return this.source;
    }

    public long getVersion() {
        return this.version;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeBoolean(this.found);
        if (this.found) {
            this.status.writeTo(out);
            XContentSource.writeTo(this.source, out);
            out.writeZLong(this.version);
            out.writeZLong(this.seqNo);
            out.writeVLong(this.primaryTerm);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("found", this.found);
        builder.field("_id", this.id);
        if (this.found) {
            builder.field("_version", this.version);
            builder.field("_seq_no", this.seqNo);
            builder.field("_primary_term", this.primaryTerm);
            builder.field("status", this.status, params);
            builder.field("watch", this.source, params);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetWatchResponse that = (GetWatchResponse)o;
        return this.version == that.version && this.seqNo == that.seqNo && this.primaryTerm == that.primaryTerm && Objects.equals(this.id, that.id) && Objects.equals(this.status, that.status) && Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.status, this.version, this.seqNo, this.primaryTerm);
    }

    public String toString() {
        return Strings.toString(this);
    }
}

