/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.history;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.watcher.actions.Action;
import org.elasticsearch.xpack.core.watcher.actions.ActionWrapperResult;
import org.elasticsearch.xpack.core.watcher.condition.ExecutableCondition;
import org.elasticsearch.xpack.core.watcher.execution.ExecutionState;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionResult;
import org.elasticsearch.xpack.core.watcher.execution.Wid;
import org.elasticsearch.xpack.core.watcher.input.ExecutableInput;
import org.elasticsearch.xpack.core.watcher.input.Input;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.core.watcher.trigger.TriggerEvent;
import org.elasticsearch.xpack.core.watcher.watch.Watch;
import org.elasticsearch.xpack.core.watcher.watch.WatchField;

public abstract class WatchRecord
implements ToXContentObject {
    public static final ParseField WATCH_ID = new ParseField("watch_id", new String[0]);
    public static final ParseField STATE = new ParseField("state", new String[0]);
    public static final ParseField TRIGGER_EVENT = new ParseField("trigger_event", new String[0]);
    public static final ParseField NODE = new ParseField("node", new String[0]);
    private static final ParseField MESSAGES = new ParseField("messages", new String[0]);
    private static final ParseField STATUS = new ParseField("status", new String[0]);
    private static final ParseField VARS = new ParseField("vars", new String[0]);
    private static final ParseField METADATA = new ParseField("metadata", new String[0]);
    private static final ParseField EXECUTION_RESULT = new ParseField("result", new String[0]);
    private static final ParseField EXCEPTION = new ParseField("exception", new String[0]);
    private static final ParseField USER = new ParseField("user", new String[0]);
    protected final Wid id;
    protected final Watch watch;
    private final String nodeId;
    protected final TriggerEvent triggerEvent;
    protected final ExecutionState state;
    private final String user;
    protected final Map<String, Object> vars;
    @Nullable
    protected final ExecutableInput<? extends Input, ? extends Input.Result> input;
    @Nullable
    protected final ExecutableCondition condition;
    @Nullable
    protected final Map<String, Object> metadata;
    @Nullable
    protected final WatchExecutionResult executionResult;

    private WatchRecord(Wid id, TriggerEvent triggerEvent, ExecutionState state, Map<String, Object> vars, ExecutableInput<? extends Input, ? extends Input.Result> input, ExecutableCondition condition, Map<String, Object> metadata, Watch watch, WatchExecutionResult executionResult, String nodeId, String user) {
        this.id = id;
        this.triggerEvent = triggerEvent;
        this.state = state;
        this.vars = vars;
        this.input = input;
        this.condition = condition;
        this.metadata = metadata;
        this.executionResult = executionResult;
        this.watch = watch;
        this.nodeId = nodeId;
        this.user = user;
    }

    private WatchRecord(Wid id, TriggerEvent triggerEvent, ExecutionState state, String nodeId) {
        this(id, triggerEvent, state, Collections.emptyMap(), null, null, null, null, null, nodeId, null);
    }

    private WatchRecord(WatchRecord record, ExecutionState state) {
        this(record.id, record.triggerEvent, state, record.vars, record.input, record.condition, record.metadata, record.watch, record.executionResult, record.nodeId, record.user);
    }

    private WatchRecord(WatchExecutionContext context, ExecutionState state) {
        this(context.id(), context.triggerEvent(), state, context.vars(), context.watch() != null ? context.watch().input() : null, context.watch() != null ? context.watch().condition() : null, context.watch() != null ? context.watch().metadata() : null, context.watch(), null, context.getNodeId(), context.getUser());
    }

    private WatchRecord(WatchExecutionContext context, WatchExecutionResult executionResult) {
        this(context.id(), context.triggerEvent(), WatchRecord.getState(executionResult), context.vars(), context.watch().input(), context.watch().condition(), context.watch().metadata(), context.watch(), executionResult, context.getNodeId(), context.getUser());
    }

    public static ExecutionState getState(WatchExecutionResult executionResult) {
        if (executionResult == null || executionResult.conditionResult() == null) {
            return ExecutionState.FAILED;
        }
        if (executionResult.conditionResult().met()) {
            Collection<ActionWrapperResult> values = executionResult.actionsResults().values();
            if (values.stream().anyMatch(r -> r.action().status() == Action.Result.Status.ACKNOWLEDGED)) {
                return ExecutionState.ACKNOWLEDGED;
            }
            if (values.stream().anyMatch(r -> r.action().status() == Action.Result.Status.THROTTLED)) {
                return ExecutionState.THROTTLED;
            }
            return ExecutionState.EXECUTED;
        }
        return ExecutionState.EXECUTION_NOT_NEEDED;
    }

    public Wid id() {
        return this.id;
    }

    public TriggerEvent triggerEvent() {
        return this.triggerEvent;
    }

    public String watchId() {
        return this.id.watchId();
    }

    public ExecutableInput<? extends Input, ? extends Input.Result> input() {
        return this.input;
    }

    public ExecutionState state() {
        return this.state;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public WatchExecutionResult result() {
        return this.executionResult;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(WATCH_ID.getPreferredName(), this.id.watchId());
        builder.field(NODE.getPreferredName(), this.nodeId);
        builder.field(STATE.getPreferredName(), this.state.id());
        if (this.user != null) {
            builder.field(USER.getPreferredName(), this.user);
        }
        if (this.watch != null && this.watch.status() != null) {
            builder.field(STATUS.getPreferredName(), this.watch.status(), params);
        }
        builder.field(TRIGGER_EVENT.getPreferredName());
        this.triggerEvent.recordXContent(builder, params);
        if (!this.vars.isEmpty() && WatcherParams.debug(params)) {
            builder.field(VARS.getPreferredName(), this.vars);
        }
        if (this.input != null) {
            builder.startObject(WatchField.INPUT.getPreferredName()).field(this.input.type(), this.input, params).endObject();
        }
        if (this.condition != null) {
            builder.startObject(WatchField.CONDITION.getPreferredName()).field(this.condition.type(), this.condition, params).endObject();
        }
        if (this.metadata != null) {
            builder.field(METADATA.getPreferredName(), this.metadata);
        }
        if (this.executionResult != null) {
            builder.field(EXECUTION_RESULT.getPreferredName(), this.executionResult, params);
        }
        this.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    abstract void innerToXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchRecord entry = (WatchRecord)o;
        return Objects.equals(this.id, entry.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id.toString();
    }

    public static class ExceptionWatchRecord
    extends WatchRecord {
        private static final Map<String, String> STACK_TRACE_ENABLED_PARAMS = MapBuilder.newMapBuilder().put("rest.exception.stacktrace.skip", "false").immutableMap();
        @Nullable
        private final Exception exception;

        public ExceptionWatchRecord(WatchExecutionContext context, WatchExecutionResult executionResult, Exception exception) {
            super(context, executionResult);
            this.exception = exception;
        }

        public ExceptionWatchRecord(WatchRecord record, Exception exception) {
            super(record, ExecutionState.FAILED);
            this.exception = exception;
        }

        public ExceptionWatchRecord(WatchExecutionContext context, Exception exception) {
            super(context, ExecutionState.FAILED);
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }

        @Override
        void innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.exception != null) {
                if (this.exception instanceof ElasticsearchException) {
                    ElasticsearchException elasticsearchException = (ElasticsearchException)this.exception;
                    builder.startObject(EXCEPTION.getPreferredName());
                    ToXContent.DelegatingMapParams delegatingParams = new ToXContent.DelegatingMapParams(STACK_TRACE_ENABLED_PARAMS, params);
                    elasticsearchException.toXContent(builder, delegatingParams);
                    builder.endObject();
                } else {
                    builder.startObject(EXCEPTION.getPreferredName()).field("type", ElasticsearchException.getExceptionName(this.exception)).field("reason", this.exception.getMessage()).endObject();
                }
            }
        }
    }

    public static class MessageWatchRecord
    extends WatchRecord {
        @Nullable
        private final String[] messages;

        public MessageWatchRecord(Wid id, TriggerEvent triggerEvent, ExecutionState state, String message, String nodeId) {
            super(id, triggerEvent, state, nodeId);
            this.messages = new String[]{message};
        }

        public MessageWatchRecord(WatchExecutionContext context, WatchExecutionResult executionResult, String message) {
            super(context, executionResult);
            this.messages = new String[]{message};
        }

        public MessageWatchRecord(WatchExecutionContext context, WatchExecutionResult executionResult) {
            super(context, executionResult);
            this.messages = Strings.EMPTY_ARRAY;
        }

        public MessageWatchRecord(WatchRecord record, ExecutionState state, String message) {
            super(record, state);
            if (record instanceof MessageWatchRecord) {
                MessageWatchRecord messageWatchRecord = (MessageWatchRecord)record;
                if (messageWatchRecord.messages.length == 0) {
                    this.messages = new String[]{message};
                } else {
                    String[] newMessages = new String[messageWatchRecord.messages.length + 1];
                    System.arraycopy(messageWatchRecord.messages, 0, newMessages, 0, messageWatchRecord.messages.length);
                    newMessages[messageWatchRecord.messages.length] = message;
                    this.messages = newMessages;
                }
            } else {
                this.messages = new String[]{message};
            }
        }

        public String[] messages() {
            return this.messages;
        }

        @Override
        void innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.messages != null) {
                builder.array(MESSAGES.getPreferredName(), this.messages);
            }
        }
    }
}

