/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpointingInfo;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;

public class TransformStoredDoc
implements Writeable,
ToXContentObject {
    public static final String NAME = "data_frame_transform_state_and_stats";
    public static final ParseField STATE_FIELD = new ParseField("state", new String[0]);
    private final String id;
    private final TransformState transformState;
    private final TransformIndexerStats transformStats;
    public static final ConstructingObjectParser<TransformStoredDoc, Void> PARSER = new ConstructingObjectParser("data_frame_transform_state_and_stats", true, a -> new TransformStoredDoc((String)a[0], (TransformState)a[1], (TransformIndexerStats)a[2]));

    public static TransformStoredDoc fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public static String documentId(String transformId) {
        return "data_frame_transform_state_and_stats-" + transformId;
    }

    public TransformStoredDoc(String id, TransformState state, TransformIndexerStats stats) {
        this.id = Objects.requireNonNull(id);
        this.transformState = Objects.requireNonNull(state);
        this.transformStats = Objects.requireNonNull(stats);
    }

    public TransformStoredDoc(StreamInput in) throws IOException {
        this.id = in.readString();
        this.transformState = new TransformState(in);
        this.transformStats = new TransformIndexerStats(in);
        if (in.getVersion().before(Version.V_7_4_0)) {
            new TransformCheckpointingInfo(in);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TransformField.ID.getPreferredName(), this.id);
        builder.field(STATE_FIELD.getPreferredName(), this.transformState, params);
        builder.field(TransformField.STATS_FIELD.getPreferredName(), this.transformStats, params);
        builder.field(TransformField.INDEX_DOC_TYPE.getPreferredName(), NAME);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        this.transformState.writeTo(out);
        this.transformStats.writeTo(out);
        if (out.getVersion().before(Version.V_7_4_0)) {
            TransformCheckpointingInfo.EMPTY.writeTo(out);
        }
    }

    public int hashCode() {
        return Objects.hash(this.id, this.transformState, this.transformStats);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformStoredDoc that = (TransformStoredDoc)other;
        return Objects.equals(this.id, that.id) && Objects.equals(this.transformState, that.transformState) && Objects.equals(this.transformStats, that.transformStats);
    }

    public String getId() {
        return this.id;
    }

    public TransformIndexerStats getTransformStats() {
        return this.transformStats;
    }

    public TransformState getTransformState() {
        return this.transformState;
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TransformField.ID);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), TransformState.PARSER::apply, STATE_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> TransformIndexerStats.fromXContent(p), TransformField.STATS_FIELD);
    }
}

