/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpoint;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpointStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerPosition;
import org.elasticsearch.xpack.core.transform.transforms.TransformProgress;

public class TransformCheckpointingInfo
implements Writeable,
ToXContentObject {
    public static final TransformCheckpointingInfo EMPTY = new TransformCheckpointingInfo(TransformCheckpointStats.EMPTY, TransformCheckpointStats.EMPTY, 0L, null, null);
    public static final ParseField LAST_CHECKPOINT = new ParseField("last", new String[0]);
    public static final ParseField NEXT_CHECKPOINT = new ParseField("next", new String[0]);
    public static final ParseField OPERATIONS_BEHIND = new ParseField("operations_behind", new String[0]);
    public static final ParseField CHANGES_LAST_DETECTED_AT = new ParseField("changes_last_detected_at", new String[0]);
    public static final ParseField LAST_SEARCH_TIME = new ParseField("last_search_time", new String[0]);
    private final TransformCheckpointStats last;
    private final TransformCheckpointStats next;
    private final long operationsBehind;
    private final Instant changesLastDetectedAt;
    private final Instant lastSearchTime;
    private static final ConstructingObjectParser<TransformCheckpointingInfo, Void> LENIENT_PARSER = new ConstructingObjectParser("data_frame_transform_checkpointing_info", true, a -> {
        long behind = a[2] == null ? 0L : (Long)a[2];
        Instant changesLastDetectedAt = (Instant)a[3];
        Instant lastSearchTime = (Instant)a[4];
        return new TransformCheckpointingInfo(a[0] == null ? TransformCheckpointStats.EMPTY : (TransformCheckpointStats)a[0], a[1] == null ? TransformCheckpointStats.EMPTY : (TransformCheckpointStats)a[1], behind, changesLastDetectedAt, lastSearchTime);
    });

    public TransformCheckpointingInfo(TransformCheckpointStats last, TransformCheckpointStats next, long operationsBehind, Instant changesLastDetectedAt, Instant lastSearchTime) {
        this.last = Objects.requireNonNull(last);
        this.next = Objects.requireNonNull(next);
        this.operationsBehind = operationsBehind;
        this.changesLastDetectedAt = changesLastDetectedAt;
        this.lastSearchTime = lastSearchTime;
    }

    public TransformCheckpointingInfo(StreamInput in) throws IOException {
        this.last = new TransformCheckpointStats(in);
        this.next = new TransformCheckpointStats(in);
        this.operationsBehind = in.readLong();
        this.changesLastDetectedAt = in.getVersion().onOrAfter(Version.V_7_4_0) ? in.readOptionalInstant() : null;
        this.lastSearchTime = in.getVersion().onOrAfter(Version.V_7_12_0) ? in.readOptionalInstant() : null;
    }

    public TransformCheckpointStats getLast() {
        return this.last;
    }

    public TransformCheckpointStats getNext() {
        return this.next;
    }

    public long getOperationsBehind() {
        return this.operationsBehind;
    }

    public Instant getChangesLastDetectedAt() {
        return this.changesLastDetectedAt;
    }

    public Instant getLastSearchTime() {
        return this.lastSearchTime;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(LAST_CHECKPOINT.getPreferredName(), this.last);
        if (this.next.getCheckpoint() > 0L) {
            builder.field(NEXT_CHECKPOINT.getPreferredName(), this.next);
        }
        if (this.operationsBehind > 0L) {
            builder.field(OPERATIONS_BEHIND.getPreferredName(), this.operationsBehind);
        }
        if (this.changesLastDetectedAt != null) {
            builder.timeField(CHANGES_LAST_DETECTED_AT.getPreferredName(), CHANGES_LAST_DETECTED_AT.getPreferredName() + "_string", this.changesLastDetectedAt.toEpochMilli());
        }
        if (this.lastSearchTime != null) {
            builder.timeField(LAST_SEARCH_TIME.getPreferredName(), LAST_SEARCH_TIME.getPreferredName() + "_string", this.lastSearchTime.toEpochMilli());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.last.writeTo(out);
        this.next.writeTo(out);
        out.writeLong(this.operationsBehind);
        if (out.getVersion().onOrAfter(Version.V_7_4_0)) {
            out.writeOptionalInstant(this.changesLastDetectedAt);
        }
        if (out.getVersion().onOrAfter(Version.V_7_12_0)) {
            out.writeOptionalInstant(this.lastSearchTime);
        }
    }

    public static TransformCheckpointingInfo fromXContent(XContentParser p) {
        return LENIENT_PARSER.apply(p, null);
    }

    public int hashCode() {
        return Objects.hash(this.last, this.next, this.operationsBehind, this.changesLastDetectedAt, this.lastSearchTime);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformCheckpointingInfo that = (TransformCheckpointingInfo)other;
        return Objects.equals(this.last, that.last) && Objects.equals(this.next, that.next) && this.operationsBehind == that.operationsBehind && Objects.equals(this.changesLastDetectedAt, that.changesLastDetectedAt) && Objects.equals(this.lastSearchTime, that.lastSearchTime);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        LENIENT_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), TransformCheckpointStats.LENIENT_PARSER::apply, LAST_CHECKPOINT);
        LENIENT_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), TransformCheckpointStats.LENIENT_PARSER::apply, NEXT_CHECKPOINT);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), OPERATIONS_BEHIND);
        LENIENT_PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeUtils.parseTimeFieldToInstant(p, CHANGES_LAST_DETECTED_AT.getPreferredName()), CHANGES_LAST_DETECTED_AT, ObjectParser.ValueType.VALUE);
        LENIENT_PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeUtils.parseTimeFieldToInstant(p, LAST_SEARCH_TIME.getPreferredName()), LAST_SEARCH_TIME, ObjectParser.ValueType.VALUE);
    }

    public static class TransformCheckpointingInfoBuilder {
        private TransformIndexerPosition nextCheckpointPosition;
        private TransformProgress nextCheckpointProgress;
        private TransformCheckpoint lastCheckpoint;
        private TransformCheckpoint nextCheckpoint;
        private TransformCheckpoint sourceCheckpoint;
        private Instant changesLastDetectedAt;
        private Instant lastSearchTime;
        private long operationsBehind;

        public TransformCheckpointingInfo build() {
            if (this.lastCheckpoint == null) {
                this.lastCheckpoint = TransformCheckpoint.EMPTY;
            }
            if (this.nextCheckpoint == null) {
                this.nextCheckpoint = TransformCheckpoint.EMPTY;
            }
            if (this.sourceCheckpoint == null) {
                this.sourceCheckpoint = TransformCheckpoint.EMPTY;
            }
            long lastCheckpointNumber = this.lastCheckpoint.getCheckpoint() > 0L ? this.lastCheckpoint.getCheckpoint() : 0L;
            long nextCheckpointNumber = this.nextCheckpoint.getCheckpoint() > 0L ? this.nextCheckpoint.getCheckpoint() : 0L;
            return new TransformCheckpointingInfo(new TransformCheckpointStats(lastCheckpointNumber, null, null, this.lastCheckpoint.getTimestamp(), this.lastCheckpoint.getTimeUpperBound()), new TransformCheckpointStats(nextCheckpointNumber, this.nextCheckpointPosition, this.nextCheckpointProgress, this.nextCheckpoint.getTimestamp(), this.nextCheckpoint.getTimeUpperBound()), this.operationsBehind, this.changesLastDetectedAt, this.lastSearchTime);
        }

        public TransformCheckpointingInfoBuilder setLastCheckpoint(TransformCheckpoint lastCheckpoint) {
            this.lastCheckpoint = lastCheckpoint;
            return this;
        }

        public TransformCheckpoint getLastCheckpoint() {
            return this.lastCheckpoint;
        }

        public TransformCheckpointingInfoBuilder setNextCheckpoint(TransformCheckpoint nextCheckpoint) {
            this.nextCheckpoint = nextCheckpoint;
            return this;
        }

        public TransformCheckpoint getNextCheckpoint() {
            return this.nextCheckpoint;
        }

        public TransformCheckpointingInfoBuilder setSourceCheckpoint(TransformCheckpoint sourceCheckpoint) {
            this.sourceCheckpoint = sourceCheckpoint;
            return this;
        }

        public TransformCheckpoint getSourceCheckpoint() {
            return this.sourceCheckpoint;
        }

        public TransformCheckpointingInfoBuilder setNextCheckpointProgress(TransformProgress nextCheckpointProgress) {
            this.nextCheckpointProgress = nextCheckpointProgress;
            return this;
        }

        public TransformCheckpointingInfoBuilder setNextCheckpointPosition(TransformIndexerPosition nextCheckpointPosition) {
            this.nextCheckpointPosition = nextCheckpointPosition;
            return this;
        }

        public TransformCheckpointingInfoBuilder setChangesLastDetectedAt(Instant changesLastDetectedAt) {
            this.changesLastDetectedAt = changesLastDetectedAt;
            return this;
        }

        public TransformCheckpointingInfoBuilder setLastSearchTime(Instant lastSearchTime) {
            this.lastSearchTime = lastSearchTime;
            return this;
        }

        public TransformCheckpointingInfoBuilder setOperationsBehind(long operationsBehind) {
            this.operationsBehind = operationsBehind;
            return this;
        }
    }
}

