/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.privilege;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.security.action.privilege.ApplicationPrivilegesRequest;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.support.MetadataUtils;

public final class PutPrivilegesRequest
extends ActionRequest
implements ApplicationPrivilegesRequest,
WriteRequest<PutPrivilegesRequest> {
    private List<ApplicationPrivilegeDescriptor> privileges;
    private WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.IMMEDIATE;

    public PutPrivilegesRequest(StreamInput in) throws IOException {
        super(in);
        this.privileges = Collections.unmodifiableList(in.readList(ApplicationPrivilegeDescriptor::new));
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom(in);
    }

    public PutPrivilegesRequest() {
        this.privileges = Collections.emptyList();
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.privileges.isEmpty()) {
            validationException = ValidateActions.addValidationError("At least one application privilege must be provided", validationException);
        } else {
            for (ApplicationPrivilegeDescriptor privilege : this.privileges) {
                try {
                    ApplicationPrivilege.validateApplicationName(privilege.getApplication());
                }
                catch (IllegalArgumentException e) {
                    validationException = ValidateActions.addValidationError(e.getMessage(), validationException);
                }
                try {
                    ApplicationPrivilege.validatePrivilegeName(privilege.getName());
                }
                catch (IllegalArgumentException e) {
                    validationException = ValidateActions.addValidationError(e.getMessage(), validationException);
                }
                if (privilege.getActions().isEmpty()) {
                    validationException = ValidateActions.addValidationError("Application privileges must have at least one action", validationException);
                }
                for (String action : privilege.getActions()) {
                    if (action.indexOf(47) == -1 && action.indexOf(42) == -1 && action.indexOf(58) == -1) {
                        validationException = ValidateActions.addValidationError("action [" + action + "] must contain one of [ '/' , '*' , ':' ]", validationException);
                    }
                    try {
                        ApplicationPrivilege.validatePrivilegeOrActionName(action);
                    }
                    catch (IllegalArgumentException e) {
                        validationException = ValidateActions.addValidationError(e.getMessage(), validationException);
                    }
                }
                if (!MetadataUtils.containsReservedMetadata(privilege.getMetadata())) continue;
                validationException = ValidateActions.addValidationError("metadata keys may not start with [_] (in privilege " + privilege.getApplication() + ' ' + privilege.getName() + ")", validationException);
            }
        }
        return validationException;
    }

    @Override
    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    @Override
    public PutPrivilegesRequest setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return this;
    }

    public List<ApplicationPrivilegeDescriptor> getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(Collection<ApplicationPrivilegeDescriptor> privileges) {
        this.privileges = Collections.unmodifiableList(new ArrayList<ApplicationPrivilegeDescriptor>(privileges));
    }

    @Override
    public Collection<String> getApplicationNames() {
        return Collections.unmodifiableSet(this.privileges.stream().map(ApplicationPrivilegeDescriptor::getApplication).collect(Collectors.toSet()));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{[" + this.privileges.stream().map(Strings::toString).collect(Collectors.joining(",")) + "];" + this.refreshPolicy + "}";
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeList(this.privileges);
        this.refreshPolicy.writeTo(out);
    }
}

