/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.action.ApiKey;

public final class QueryApiKeyResponse
extends ActionResponse
implements ToXContentObject,
Writeable {
    private final long total;
    private final Item[] items;

    public QueryApiKeyResponse(StreamInput in) throws IOException {
        super(in);
        this.total = in.readLong();
        this.items = in.readArray(Item::new, Item[]::new);
    }

    public QueryApiKeyResponse(long total, Collection<Item> items) {
        this.total = total;
        Objects.requireNonNull(items, "items must be provided");
        this.items = items.toArray(new Item[0]);
    }

    public static QueryApiKeyResponse emptyResponse() {
        return new QueryApiKeyResponse(0L, Collections.emptyList());
    }

    public long getTotal() {
        return this.total;
    }

    public Item[] getItems() {
        return this.items;
    }

    public int getCount() {
        return this.items.length;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("total", this.total).field("count", this.items.length).array("api_keys", this.items);
        return builder.endObject();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.total);
        out.writeArray(this.items);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryApiKeyResponse that = (QueryApiKeyResponse)o;
        return this.total == that.total && Arrays.equals(this.items, that.items);
    }

    public int hashCode() {
        int result = Objects.hash(this.total);
        result = 31 * result + Arrays.hashCode(this.items);
        return result;
    }

    public String toString() {
        return "QueryApiKeyResponse{total=" + this.total + ", items=" + Arrays.toString(this.items) + '}';
    }

    public static class Item
    implements ToXContentObject,
    Writeable {
        private final ApiKey apiKey;
        @Nullable
        private final Object[] sortValues;

        public Item(ApiKey apiKey, @Nullable Object[] sortValues) {
            this.apiKey = apiKey;
            this.sortValues = sortValues;
        }

        public Item(StreamInput in) throws IOException {
            this.apiKey = new ApiKey(in);
            this.sortValues = in.readOptionalArray(Lucene::readSortValue, Object[]::new);
        }

        public ApiKey getApiKey() {
            return this.apiKey;
        }

        public Object[] getSortValues() {
            return this.sortValues;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.apiKey.writeTo(out);
            out.writeOptionalArray(Lucene::writeSortValue, this.sortValues);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.apiKey.innerToXContent(builder, params);
            if (this.sortValues != null && this.sortValues.length > 0) {
                builder.array("_sort", this.sortValues);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            return Objects.equals(this.apiKey, item.apiKey) && Arrays.equals(this.sortValues, item.sortValues);
        }

        public int hashCode() {
            int result = Objects.hash(this.apiKey);
            result = 31 * result + Arrays.hashCode(this.sortValues);
            return result;
        }

        public String toString() {
            return "Item{apiKey=" + this.apiKey + ", sortValues=" + Arrays.toString(this.sortValues) + '}';
        }
    }
}

