/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;

public final class MapHelper {
    private MapHelper() {
    }

    @Nullable
    public static Object dig(String path, Map<String, Object> map) {
        Object obj = map.get(path);
        if (obj != null) {
            return obj;
        }
        String[] fields = Strings.delimitedListToStringArray(path, ".");
        Stack<PotentialPath> pathStack = new Stack<PotentialPath>();
        pathStack.push(new PotentialPath(map, 0));
        return MapHelper.explore(fields, pathStack);
    }

    public static Map<String, Object> dotCollapse(Map<String, Object> map, Collection<String> pathsToCollapse) {
        HashMap<String, Object> collapsed = new HashMap<String, Object>(pathsToCollapse.size() * 4 / 3 + 1);
        for (String path : pathsToCollapse) {
            Object dug = MapHelper.dig(path, map);
            if (dug == null) continue;
            collapsed.put(path, dug);
        }
        return collapsed;
    }

    private static Object explore(String[] path, Stack<PotentialPath> pathStack) {
        while (!pathStack.empty()) {
            Object val;
            PotentialPath potentialPath = pathStack.pop();
            int startPos = potentialPath.pathPosition;
            Map map = potentialPath.map;
            String candidateKey = null;
            for (int endPos = potentialPath.pathPosition + 1; endPos <= path.length; ++endPos) {
                candidateKey = MapHelper.mergePath(path, startPos, endPos);
                Object next = map.get(candidateKey);
                if (endPos == path.length && next != null) {
                    return next;
                }
                if (!(next instanceof Map)) continue;
                pathStack.push(new PotentialPath((Map)next, endPos));
            }
            if (candidateKey == null || (val = map.get(candidateKey)) == null) continue;
            return val;
        }
        return null;
    }

    private static String mergePath(String[] path, int start, int end) {
        if (start + 1 == end) {
            return path[start];
        }
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < end - 1; ++i) {
            sb.append(path[i]);
            sb.append(".");
        }
        sb.append(path[end - 1]);
        return sb.toString();
    }

    private static class PotentialPath {
        private final Map<String, Object> map;
        private final int pathPosition;

        private PotentialPath(Map<String, Object> map, int pathPosition) {
            this.map = map;
            this.pathPosition = pathPosition;
        }
    }
}

