/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.results;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.Result;

public class ModelPlot
implements ToXContentObject,
Writeable {
    public static final String RESULT_TYPE_VALUE = "model_plot";
    public static final ParseField RESULTS_FIELD = new ParseField("model_plot", new String[0]);
    public static final ParseField PARTITION_FIELD_NAME = new ParseField("partition_field_name", new String[0]);
    public static final ParseField PARTITION_FIELD_VALUE = new ParseField("partition_field_value", new String[0]);
    public static final ParseField OVER_FIELD_NAME = new ParseField("over_field_name", new String[0]);
    public static final ParseField OVER_FIELD_VALUE = new ParseField("over_field_value", new String[0]);
    public static final ParseField BY_FIELD_NAME = new ParseField("by_field_name", new String[0]);
    public static final ParseField BY_FIELD_VALUE = new ParseField("by_field_value", new String[0]);
    public static final ParseField MODEL_FEATURE = new ParseField("model_feature", new String[0]);
    public static final ParseField MODEL_LOWER = new ParseField("model_lower", new String[0]);
    public static final ParseField MODEL_UPPER = new ParseField("model_upper", new String[0]);
    public static final ParseField MODEL_MEDIAN = new ParseField("model_median", new String[0]);
    public static final ParseField ACTUAL = new ParseField("actual", new String[0]);
    public static final ParseField BUCKET_SPAN = new ParseField("bucket_span", new String[0]);
    public static final ParseField DETECTOR_INDEX = new ParseField("detector_index", new String[0]);
    public static final ConstructingObjectParser<ModelPlot, Void> STRICT_PARSER = ModelPlot.createParser(false);
    public static final ConstructingObjectParser<ModelPlot, Void> LENIENT_PARSER = ModelPlot.createParser(true);
    private final String jobId;
    private final Date timestamp;
    private final long bucketSpan;
    private int detectorIndex;
    private String partitionFieldName;
    private String partitionFieldValue;
    private String overFieldName;
    private String overFieldValue;
    private String byFieldName;
    private String byFieldValue;
    private String modelFeature;
    private double modelLower;
    private double modelUpper;
    private double modelMedian;
    private Double actual;

    private static ConstructingObjectParser<ModelPlot, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser<ModelPlot, Void> parser = new ConstructingObjectParser<ModelPlot, Void>(RESULT_TYPE_VALUE, ignoreUnknownFields, a -> new ModelPlot((String)a[0], (Date)a[1], (Long)a[2], (Integer)a[3]));
        parser.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        parser.declareField(ConstructingObjectParser.constructorArg(), p -> TimeUtils.parseTimeField(p, Result.TIMESTAMP.getPreferredName()), Result.TIMESTAMP, ObjectParser.ValueType.VALUE);
        parser.declareLong(ConstructingObjectParser.constructorArg(), BUCKET_SPAN);
        parser.declareInt(ConstructingObjectParser.constructorArg(), DETECTOR_INDEX);
        parser.declareString((modelPlot, s) -> {}, Result.RESULT_TYPE);
        parser.declareString(ModelPlot::setPartitionFieldName, PARTITION_FIELD_NAME);
        parser.declareString(ModelPlot::setPartitionFieldValue, PARTITION_FIELD_VALUE);
        parser.declareString(ModelPlot::setOverFieldName, OVER_FIELD_NAME);
        parser.declareString(ModelPlot::setOverFieldValue, OVER_FIELD_VALUE);
        parser.declareString(ModelPlot::setByFieldName, BY_FIELD_NAME);
        parser.declareString(ModelPlot::setByFieldValue, BY_FIELD_VALUE);
        parser.declareString(ModelPlot::setModelFeature, MODEL_FEATURE);
        parser.declareDouble(ModelPlot::setModelLower, MODEL_LOWER);
        parser.declareDouble(ModelPlot::setModelUpper, MODEL_UPPER);
        parser.declareDouble(ModelPlot::setModelMedian, MODEL_MEDIAN);
        parser.declareDouble(ModelPlot::setActual, ACTUAL);
        return parser;
    }

    public ModelPlot(String jobId, Date timestamp, long bucketSpan, int detectorIndex) {
        this.jobId = jobId;
        this.timestamp = timestamp;
        this.bucketSpan = bucketSpan;
        this.detectorIndex = detectorIndex;
    }

    public ModelPlot(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.timestamp = new Date(in.readLong());
        this.partitionFieldName = in.readOptionalString();
        this.partitionFieldValue = in.readOptionalString();
        this.overFieldName = in.readOptionalString();
        this.overFieldValue = in.readOptionalString();
        this.byFieldName = in.readOptionalString();
        this.byFieldValue = in.readOptionalString();
        this.modelFeature = in.readOptionalString();
        this.modelLower = in.readDouble();
        this.modelUpper = in.readDouble();
        this.modelMedian = in.readDouble();
        this.actual = in.getVersion().before(Version.V_6_0_0_rc1) ? Double.valueOf(in.readDouble()) : in.readOptionalDouble();
        this.bucketSpan = in.readLong();
        this.detectorIndex = in.getVersion().onOrAfter(Version.V_6_1_0) ? in.readInt() : -1;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeLong(this.timestamp.getTime());
        out.writeOptionalString(this.partitionFieldName);
        out.writeOptionalString(this.partitionFieldValue);
        out.writeOptionalString(this.overFieldName);
        out.writeOptionalString(this.overFieldValue);
        out.writeOptionalString(this.byFieldName);
        out.writeOptionalString(this.byFieldValue);
        out.writeOptionalString(this.modelFeature);
        out.writeDouble(this.modelLower);
        out.writeDouble(this.modelUpper);
        out.writeDouble(this.modelMedian);
        if (out.getVersion().before(Version.V_6_0_0_rc1)) {
            if (this.actual == null) {
                out.writeDouble(0.0);
            } else {
                out.writeDouble(this.actual);
            }
        } else {
            out.writeOptionalDouble(this.actual);
        }
        out.writeLong(this.bucketSpan);
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeInt(this.detectorIndex);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(Result.RESULT_TYPE.getPreferredName(), RESULT_TYPE_VALUE);
        builder.field(BUCKET_SPAN.getPreferredName(), this.bucketSpan);
        builder.field(DETECTOR_INDEX.getPreferredName(), this.detectorIndex);
        if (this.timestamp != null) {
            builder.timeField(Result.TIMESTAMP.getPreferredName(), Result.TIMESTAMP.getPreferredName() + "_string", this.timestamp.getTime());
        }
        if (this.partitionFieldName != null) {
            builder.field(PARTITION_FIELD_NAME.getPreferredName(), this.partitionFieldName);
        }
        if (this.partitionFieldValue != null) {
            builder.field(PARTITION_FIELD_VALUE.getPreferredName(), this.partitionFieldValue);
        }
        if (this.overFieldName != null) {
            builder.field(OVER_FIELD_NAME.getPreferredName(), this.overFieldName);
        }
        if (this.overFieldValue != null) {
            builder.field(OVER_FIELD_VALUE.getPreferredName(), this.overFieldValue);
        }
        if (this.byFieldName != null) {
            builder.field(BY_FIELD_NAME.getPreferredName(), this.byFieldName);
        }
        if (this.byFieldValue != null) {
            builder.field(BY_FIELD_VALUE.getPreferredName(), this.byFieldValue);
        }
        if (this.modelFeature != null) {
            builder.field(MODEL_FEATURE.getPreferredName(), this.modelFeature);
        }
        builder.field(MODEL_LOWER.getPreferredName(), this.modelLower);
        builder.field(MODEL_UPPER.getPreferredName(), this.modelUpper);
        builder.field(MODEL_MEDIAN.getPreferredName(), this.modelMedian);
        if (this.actual != null) {
            builder.field(ACTUAL.getPreferredName(), this.actual);
        }
        builder.endObject();
        return builder;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getId() {
        return this.jobId + "_model_plot_" + this.timestamp.getTime() + "_" + this.bucketSpan + "_" + this.detectorIndex + "_" + MachineLearningField.valuesToId(this.byFieldValue, this.overFieldValue, this.partitionFieldValue);
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public long getBucketSpan() {
        return this.bucketSpan;
    }

    public int getDetectorIndex() {
        return this.detectorIndex;
    }

    public String getPartitionFieldName() {
        return this.partitionFieldName;
    }

    public void setPartitionFieldName(String partitionFieldName) {
        this.partitionFieldName = partitionFieldName;
    }

    public String getPartitionFieldValue() {
        return this.partitionFieldValue;
    }

    public void setPartitionFieldValue(String partitionFieldValue) {
        this.partitionFieldValue = partitionFieldValue;
    }

    public String getOverFieldName() {
        return this.overFieldName;
    }

    public void setOverFieldName(String overFieldName) {
        this.overFieldName = overFieldName;
    }

    public String getOverFieldValue() {
        return this.overFieldValue;
    }

    public void setOverFieldValue(String overFieldValue) {
        this.overFieldValue = overFieldValue;
    }

    public String getByFieldName() {
        return this.byFieldName;
    }

    public void setByFieldName(String byFieldName) {
        this.byFieldName = byFieldName;
    }

    public String getByFieldValue() {
        return this.byFieldValue;
    }

    public void setByFieldValue(String byFieldValue) {
        this.byFieldValue = byFieldValue;
    }

    public String getModelFeature() {
        return this.modelFeature;
    }

    public void setModelFeature(String modelFeature) {
        this.modelFeature = modelFeature;
    }

    public double getModelLower() {
        return this.modelLower;
    }

    public void setModelLower(double modelLower) {
        this.modelLower = modelLower;
    }

    public double getModelUpper() {
        return this.modelUpper;
    }

    public void setModelUpper(double modelUpper) {
        this.modelUpper = modelUpper;
    }

    public double getModelMedian() {
        return this.modelMedian;
    }

    public void setModelMedian(double modelMedian) {
        this.modelMedian = modelMedian;
    }

    public Double getActual() {
        return this.actual;
    }

    public void setActual(Double actual) {
        this.actual = actual;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModelPlot)) {
            return false;
        }
        ModelPlot that = (ModelPlot)other;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.partitionFieldValue, that.partitionFieldValue) && Objects.equals(this.partitionFieldName, that.partitionFieldName) && Objects.equals(this.overFieldValue, that.overFieldValue) && Objects.equals(this.overFieldName, that.overFieldName) && Objects.equals(this.byFieldValue, that.byFieldValue) && Objects.equals(this.byFieldName, that.byFieldName) && Objects.equals(this.modelFeature, that.modelFeature) && this.modelLower == that.modelLower && this.modelUpper == that.modelUpper && this.modelMedian == that.modelMedian && Objects.equals(this.actual, that.actual) && this.bucketSpan == that.bucketSpan && this.detectorIndex == that.detectorIndex;
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.timestamp, this.partitionFieldName, this.partitionFieldValue, this.overFieldName, this.overFieldValue, this.byFieldName, this.byFieldValue, this.modelFeature, this.modelLower, this.modelUpper, this.modelMedian, this.actual, this.bucketSpan, this.detectorIndex);
    }
}

