/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ModelPlotConfig
implements ToXContentObject,
Writeable {
    public static final ParseField TYPE_FIELD = new ParseField("model_plot_config", new String[0]);
    public static final ParseField ENABLED_FIELD = new ParseField("enabled", new String[0]);
    public static final ParseField TERMS_FIELD = new ParseField("terms", new String[0]);
    public static final ParseField ANNOTATIONS_ENABLED_FIELD = new ParseField("annotations_enabled", new String[0]);
    public static final ConstructingObjectParser<ModelPlotConfig, Void> LENIENT_PARSER = ModelPlotConfig.createParser(true);
    public static final ConstructingObjectParser<ModelPlotConfig, Void> STRICT_PARSER = ModelPlotConfig.createParser(false);
    private final boolean enabled;
    private final String terms;
    private final boolean annotationsEnabled;

    private static ConstructingObjectParser<ModelPlotConfig, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser<ModelPlotConfig, Void> parser = new ConstructingObjectParser<ModelPlotConfig, Void>(TYPE_FIELD.getPreferredName(), ignoreUnknownFields, a -> new ModelPlotConfig((Boolean)a[0], (String)a[1], (Boolean)a[2]));
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), ENABLED_FIELD);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), TERMS_FIELD);
        parser.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ANNOTATIONS_ENABLED_FIELD);
        return parser;
    }

    public ModelPlotConfig() {
        this(true, null, null);
    }

    public ModelPlotConfig(boolean enabled, String terms, Boolean annotationsEnabled) {
        this.enabled = enabled;
        this.terms = terms;
        this.annotationsEnabled = annotationsEnabled != null ? annotationsEnabled : enabled;
    }

    public ModelPlotConfig(StreamInput in) throws IOException {
        this.enabled = in.readBoolean();
        this.terms = in.readOptionalString();
        this.annotationsEnabled = in.getVersion().onOrAfter(Version.V_7_9_0) ? in.readBoolean() : this.enabled;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.enabled);
        out.writeOptionalString(this.terms);
        if (out.getVersion().onOrAfter(Version.V_7_9_0)) {
            out.writeBoolean(this.annotationsEnabled);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ENABLED_FIELD.getPreferredName(), this.enabled);
        if (this.terms != null) {
            builder.field(TERMS_FIELD.getPreferredName(), this.terms);
        }
        builder.field(ANNOTATIONS_ENABLED_FIELD.getPreferredName(), this.annotationsEnabled);
        builder.endObject();
        return builder;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getTerms() {
        return this.terms;
    }

    public boolean annotationsEnabled() {
        return this.annotationsEnabled;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModelPlotConfig)) {
            return false;
        }
        ModelPlotConfig that = (ModelPlotConfig)other;
        return this.enabled == that.enabled && Objects.equals(this.terms, that.terms) && this.annotationsEnabled == that.annotationsEnabled;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.terms, this.annotationsEnabled);
    }
}

