/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.preprocessing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.LenientlyParsedPreProcessor;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.PreProcessor;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.StrictlyParsedPreProcessor;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class OneHotEncoding
implements LenientlyParsedPreProcessor,
StrictlyParsedPreProcessor {
    public static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(OneHotEncoding.class);
    public static final ParseField NAME = new ParseField("one_hot_encoding", new String[0]);
    public static final ParseField FIELD = new ParseField("field", new String[0]);
    public static final ParseField HOT_MAP = new ParseField("hot_map", new String[0]);
    public static final ParseField CUSTOM = new ParseField("custom", new String[0]);
    private static final ConstructingObjectParser<OneHotEncoding, PreProcessor.PreProcessorParseContext> STRICT_PARSER = OneHotEncoding.createParser(false);
    private static final ConstructingObjectParser<OneHotEncoding, PreProcessor.PreProcessorParseContext> LENIENT_PARSER = OneHotEncoding.createParser(true);
    private final String field;
    private final Map<String, String> hotMap;
    private final boolean custom;

    private static ConstructingObjectParser<OneHotEncoding, PreProcessor.PreProcessorParseContext> createParser(boolean lenient) {
        ConstructingObjectParser<OneHotEncoding, PreProcessor.PreProcessorParseContext> parser = new ConstructingObjectParser<OneHotEncoding, PreProcessor.PreProcessorParseContext>(NAME.getPreferredName(), lenient, (a, c) -> new OneHotEncoding((String)a[0], (Map)a[1], a[2] == null ? c.isCustomByDefault() : ((Boolean)a[2]).booleanValue()));
        parser.declareString(ConstructingObjectParser.constructorArg(), FIELD);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.mapStrings(), HOT_MAP);
        parser.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), CUSTOM);
        return parser;
    }

    public static OneHotEncoding fromXContentStrict(XContentParser parser, PreProcessor.PreProcessorParseContext context) {
        return STRICT_PARSER.apply(parser, context == null ? PreProcessor.PreProcessorParseContext.DEFAULT : context);
    }

    public static OneHotEncoding fromXContentLenient(XContentParser parser, PreProcessor.PreProcessorParseContext context) {
        return LENIENT_PARSER.apply(parser, context == null ? PreProcessor.PreProcessorParseContext.DEFAULT : context);
    }

    public OneHotEncoding(String field, Map<String, String> hotMap, Boolean custom) {
        this.field = ExceptionsHelper.requireNonNull(field, FIELD);
        this.hotMap = Collections.unmodifiableMap(new TreeMap<String, String>(ExceptionsHelper.requireNonNull(hotMap, HOT_MAP)));
        this.custom = custom != null && custom != false;
    }

    public OneHotEncoding(StreamInput in) throws IOException {
        this.field = in.readString();
        this.hotMap = Collections.unmodifiableMap(new TreeMap<String, String>(in.readMap(StreamInput::readString, StreamInput::readString)));
        this.custom = in.getVersion().onOrAfter(Version.V_7_10_0) ? in.readBoolean() : false;
    }

    public String getField() {
        return this.field;
    }

    public Map<String, String> getHotMap() {
        return this.hotMap;
    }

    @Override
    public Map<String, String> reverseLookup() {
        return this.hotMap.values().stream().collect(Collectors.toMap(Function.identity(), value -> this.field));
    }

    @Override
    public boolean isCustom() {
        return this.custom;
    }

    @Override
    public String getOutputFieldType(String outputField) {
        return NumberFieldMapper.NumberType.INTEGER.typeName();
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public List<String> inputFields() {
        return Collections.singletonList(this.field);
    }

    @Override
    public List<String> outputFields() {
        return new ArrayList<String>(this.hotMap.values());
    }

    @Override
    public void process(Map<String, Object> fields) {
        Object value = fields.get(this.field);
        if (value == null) {
            return;
        }
        String stringValue = value.toString();
        this.hotMap.forEach((val, col) -> {
            int encoding = stringValue.equals(val) ? 1 : 0;
            fields.put((String)col, encoding);
        });
    }

    @Override
    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeMap(this.hotMap, StreamOutput::writeString, StreamOutput::writeString);
        if (out.getVersion().onOrAfter(Version.V_7_10_0)) {
            out.writeBoolean(this.custom);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD.getPreferredName(), this.field);
        builder.field(HOT_MAP.getPreferredName(), this.hotMap);
        builder.field(CUSTOM.getPreferredName(), this.custom);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OneHotEncoding that = (OneHotEncoding)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.hotMap, that.hotMap) && Objects.equals(this.custom, that.custom);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.hotMap, this.custom);
    }

    @Override
    public long ramBytesUsed() {
        long size = SHALLOW_SIZE;
        size += RamUsageEstimator.sizeOf(this.field);
        return size += RamUsageEstimator.sizeOfMap(this.hotMap, 0L);
    }

    public String toString() {
        return Strings.toString(this);
    }
}

