/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm.client;

import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.xpack.core.ilm.ExplainLifecycleRequest;
import org.elasticsearch.xpack.core.ilm.ExplainLifecycleResponse;
import org.elasticsearch.xpack.core.ilm.StartILMRequest;
import org.elasticsearch.xpack.core.ilm.StopILMRequest;
import org.elasticsearch.xpack.core.ilm.action.DeleteLifecycleAction;
import org.elasticsearch.xpack.core.ilm.action.ExplainLifecycleAction;
import org.elasticsearch.xpack.core.ilm.action.GetLifecycleAction;
import org.elasticsearch.xpack.core.ilm.action.GetStatusAction;
import org.elasticsearch.xpack.core.ilm.action.PutLifecycleAction;
import org.elasticsearch.xpack.core.ilm.action.RemoveIndexLifecyclePolicyAction;
import org.elasticsearch.xpack.core.ilm.action.RetryAction;
import org.elasticsearch.xpack.core.ilm.action.StartILMAction;
import org.elasticsearch.xpack.core.ilm.action.StopILMAction;

public class ILMClient {
    private ElasticsearchClient client;

    public ILMClient(ElasticsearchClient client) {
        this.client = client;
    }

    public void putLifecyclePolicy(PutLifecycleAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        this.client.execute(PutLifecycleAction.INSTANCE, request, listener);
    }

    public ActionFuture<AcknowledgedResponse> putLifecyclePolicy(PutLifecycleAction.Request request) {
        return this.client.execute(PutLifecycleAction.INSTANCE, request);
    }

    public void getLifecyclePolicy(GetLifecycleAction.Request request, ActionListener<GetLifecycleAction.Response> listener) {
        this.client.execute(GetLifecycleAction.INSTANCE, request, listener);
    }

    public ActionFuture<GetLifecycleAction.Response> getLifecyclePolicy(GetLifecycleAction.Request request) {
        return this.client.execute(GetLifecycleAction.INSTANCE, request);
    }

    public void deleteLifecyclePolicy(DeleteLifecycleAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        this.client.execute(DeleteLifecycleAction.INSTANCE, request, listener);
    }

    public ActionFuture<AcknowledgedResponse> deleteLifecyclePolicy(DeleteLifecycleAction.Request request) {
        return this.client.execute(DeleteLifecycleAction.INSTANCE, request);
    }

    public void explainLifecycle(ExplainLifecycleRequest request, ActionListener<ExplainLifecycleResponse> listener) {
        this.client.execute(ExplainLifecycleAction.INSTANCE, request, listener);
    }

    public ActionFuture<ExplainLifecycleResponse> explainLifecycle(ExplainLifecycleRequest request) {
        return this.client.execute(ExplainLifecycleAction.INSTANCE, request);
    }

    public void getStatus(GetStatusAction.Request request, ActionListener<GetStatusAction.Response> listener) {
        this.client.execute(GetStatusAction.INSTANCE, request, listener);
    }

    public ActionFuture<GetStatusAction.Response> getStatus(GetStatusAction.Request request) {
        return this.client.execute(GetStatusAction.INSTANCE, request);
    }

    public void removeIndexLifecyclePolicy(RemoveIndexLifecyclePolicyAction.Request request, ActionListener<RemoveIndexLifecyclePolicyAction.Response> listener) {
        this.client.execute(RemoveIndexLifecyclePolicyAction.INSTANCE, request, listener);
    }

    public ActionFuture<RemoveIndexLifecyclePolicyAction.Response> removeIndexLifecyclePolicy(RemoveIndexLifecyclePolicyAction.Request request) {
        return this.client.execute(RemoveIndexLifecyclePolicyAction.INSTANCE, request);
    }

    public void retryPolicy(RetryAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        this.client.execute(RetryAction.INSTANCE, request, listener);
    }

    public ActionFuture<AcknowledgedResponse> retryPolicy(RetryAction.Request request) {
        return this.client.execute(RetryAction.INSTANCE, request);
    }

    public void startILM(StartILMRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.client.execute(StartILMAction.INSTANCE, request, listener);
    }

    public ActionFuture<AcknowledgedResponse> startILM(StartILMRequest request) {
        return this.client.execute(StartILMAction.INSTANCE, request);
    }

    public void stopILM(StopILMRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.client.execute(StopILMAction.INSTANCE, request, listener);
    }

    public ActionFuture<AcknowledgedResponse> stopILM(StopILMRequest request) {
        return this.client.execute(StopILMAction.INSTANCE, request);
    }
}

