/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.NodesShutdownMetadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.Index;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.step.info.SingleMessageFieldInfo;

public class CheckShrinkReadyStep
extends ClusterStateWaitStep {
    public static final String NAME = "check-shrink-allocation";
    private static final Logger logger = LogManager.getLogger(CheckShrinkReadyStep.class);
    private boolean completable = true;

    CheckShrinkReadyStep(Step.StepKey key, Step.StepKey nextStepKey) {
        super(key, nextStepKey);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public boolean isCompletable() {
        return this.completable;
    }

    @Override
    public ClusterStateWaitStep.Result isConditionMet(Index index, ClusterState clusterState) {
        IndexMetadata idxMeta = clusterState.metadata().index(index);
        if (idxMeta == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().getAction(), (Object)index.getName());
            return new ClusterStateWaitStep.Result(false, null);
        }
        int expectedShardCount = idxMeta.getNumberOfShards();
        String idShardsShouldBeOn = idxMeta.getSettings().get("index.routing.allocation.require._id");
        if (idShardsShouldBeOn == null) {
            throw new IllegalStateException("Cannot check shrink allocation as there are no allocation rules by _id");
        }
        boolean nodeBeingRemoved = NodesShutdownMetadata.getShutdowns(clusterState).map(NodesShutdownMetadata::getAllNodeMetadataMap).map(shutdownMetadataMap -> (SingleNodeShutdownMetadata)shutdownMetadataMap.get(idShardsShouldBeOn)).map(singleNodeShutdown -> singleNodeShutdown.getType() == SingleNodeShutdownMetadata.Type.REMOVE || singleNodeShutdown.getType() == SingleNodeShutdownMetadata.Type.REPLACE).orElse(false);
        IndexRoutingTable routingTable = clusterState.getRoutingTable().index(index);
        int foundShards = 0;
        for (ShardRouting shard : routingTable.shardsWithState(ShardRoutingState.STARTED)) {
            String currentNodeId = shard.currentNodeId();
            if (!idShardsShouldBeOn.equals(currentNodeId) || shard.relocating()) continue;
            ++foundShards;
        }
        logger.trace("{} checking for shrink readiness on [{}], found {} shards and need {}", (Object)index, (Object)idShardsShouldBeOn, (Object)foundShards, (Object)expectedShardCount);
        if (foundShards == expectedShardCount) {
            logger.trace("{} successfully found {} allocated shards for shrink readiness on node [{}] ({})", (Object)index, (Object)expectedShardCount, (Object)idShardsShouldBeOn, (Object)this.getKey().getAction());
            return new ClusterStateWaitStep.Result(true, null);
        }
        if (nodeBeingRemoved) {
            this.completable = false;
            return new ClusterStateWaitStep.Result(false, new SingleMessageFieldInfo("node with id [" + idShardsShouldBeOn + "] is currently marked as shutting down for removal"));
        }
        logger.trace("{} failed to find {} allocated shards (found {}) on node [{}] for shrink readiness ({})", (Object)index, (Object)expectedShardCount, (Object)foundShards, (Object)idShardsShouldBeOn, (Object)this.getKey().getAction());
        return new ClusterStateWaitStep.Result(false, new Info(idShardsShouldBeOn, expectedShardCount, expectedShardCount - foundShards));
    }

    @Override
    public int hashCode() {
        return 612;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return super.equals(obj);
    }

    public static final class Info
    implements ToXContentObject {
        private final String nodeId;
        private final long actualReplicas;
        private final long numberShardsLeftToAllocate;
        private final String message;
        static final ParseField NODE_ID = new ParseField("node_id", new String[0]);
        static final ParseField EXPECTED_SHARDS = new ParseField("expected_shards", new String[0]);
        static final ParseField SHARDS_TO_ALLOCATE = new ParseField("shards_left_to_allocate", new String[0]);
        static final ParseField MESSAGE = new ParseField("message", new String[0]);
        static final ConstructingObjectParser<Info, Void> PARSER = new ConstructingObjectParser("check_shrink_ready_step_info", a -> new Info((String)a[0], (Long)a[1], (Long)a[2]));

        public Info(String nodeId, long expectedShards, long numberShardsLeftToAllocate) {
            this.nodeId = nodeId;
            this.actualReplicas = expectedShards;
            this.numberShardsLeftToAllocate = numberShardsLeftToAllocate;
            this.message = numberShardsLeftToAllocate < 0L ? "Waiting for all shards to become active" : String.format(Locale.ROOT, "Waiting for node [%s] to contain [%d] shards, found [%d], remaining [%d]", nodeId, expectedShards, expectedShards - numberShardsLeftToAllocate, numberShardsLeftToAllocate);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(MESSAGE.getPreferredName(), this.message);
            builder.field(NODE_ID.getPreferredName(), this.nodeId);
            builder.field(SHARDS_TO_ALLOCATE.getPreferredName(), this.numberShardsLeftToAllocate);
            builder.field(EXPECTED_SHARDS.getPreferredName(), this.actualReplicas);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.actualReplicas, this.numberShardsLeftToAllocate);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Info other = (Info)obj;
            return Objects.equals(this.actualReplicas, other.actualReplicas) && Objects.equals(this.numberShardsLeftToAllocate, other.numberShardsLeftToAllocate) && Objects.equals(this.nodeId, other.nodeId);
        }

        public String toString() {
            return Strings.toString(this);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), NODE_ID);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), EXPECTED_SHARDS);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SHARDS_TO_ALLOCATE);
            PARSER.declareString((i, s) -> {}, MESSAGE);
        }
    }
}

