/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio;

import java.nio.ByteBuffer;
import java.util.function.IntFunction;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.nio.Page;

public class PageAllocator
implements IntFunction<Page> {
    private static final int RECYCLE_LOWER_THRESHOLD = 8192;
    private final PageCacheRecycler recycler;

    public PageAllocator(PageCacheRecycler recycler) {
        this.recycler = recycler;
    }

    @Override
    public Page apply(int length) {
        if (length >= 8192 && length <= 16384) {
            Recycler.V<byte[]> bytePage = this.recycler.bytePage(false);
            return new Page(ByteBuffer.wrap(bytePage.v(), 0, length), bytePage);
        }
        return new Page(ByteBuffer.allocate(length), () -> {});
    }
}

