/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class CollectorResult
implements ToXContentObject,
Writeable {
    public static final String REASON_SEARCH_COUNT = "search_count";
    public static final String REASON_SEARCH_TOP_HITS = "search_top_hits";
    public static final String REASON_SEARCH_TERMINATE_AFTER_COUNT = "search_terminate_after_count";
    public static final String REASON_SEARCH_POST_FILTER = "search_post_filter";
    public static final String REASON_SEARCH_MIN_SCORE = "search_min_score";
    public static final String REASON_SEARCH_MULTI = "search_multi";
    public static final String REASON_AGGREGATION = "aggregation";
    public static final String REASON_AGGREGATION_GLOBAL = "aggregation_global";
    private static final ParseField NAME = new ParseField("name", new String[0]);
    private static final ParseField REASON = new ParseField("reason", new String[0]);
    private static final ParseField TIME = new ParseField("time", new String[0]);
    private static final ParseField TIME_NANOS = new ParseField("time_in_nanos", new String[0]);
    private static final ParseField CHILDREN = new ParseField("children", new String[0]);
    private final String collectorName;
    private final String reason;
    private final long time;
    private List<CollectorResult> children;

    public CollectorResult(String collectorName, String reason, long time, List<CollectorResult> children) {
        this.collectorName = collectorName;
        this.reason = reason;
        this.time = time;
        this.children = children;
    }

    public CollectorResult(StreamInput in) throws IOException {
        this.collectorName = in.readString();
        this.reason = in.readString();
        this.time = in.readLong();
        int size = in.readVInt();
        this.children = new ArrayList<CollectorResult>(size);
        for (int i = 0; i < size; ++i) {
            CollectorResult child = new CollectorResult(in);
            this.children.add(child);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.collectorName);
        out.writeString(this.reason);
        out.writeLong(this.time);
        out.writeVInt(this.children.size());
        for (CollectorResult child : this.children) {
            child.writeTo(out);
        }
    }

    public long getTime() {
        return this.time;
    }

    public String getReason() {
        return this.reason;
    }

    public String getName() {
        return this.collectorName;
    }

    public List<CollectorResult> getProfiledChildren() {
        return this.children;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CollectorResult other = (CollectorResult)obj;
        return this.collectorName.equals(other.collectorName) && this.reason.equals(other.reason) && this.time == other.time && this.children.equals(other.children);
    }

    public int hashCode() {
        return Objects.hash(this.collectorName, this.reason, this.time, this.children);
    }

    public String toString() {
        return Strings.toString(this);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder = builder.startObject();
        builder.field(NAME.getPreferredName(), this.getName());
        builder.field(REASON.getPreferredName(), this.getReason());
        if (builder.humanReadable()) {
            builder.field(TIME.getPreferredName(), new TimeValue(this.getTime(), TimeUnit.NANOSECONDS).toString());
        }
        builder.field(TIME_NANOS.getPreferredName(), this.getTime());
        if (!this.children.isEmpty()) {
            builder = builder.startArray(CHILDREN.getPreferredName());
            for (CollectorResult child : this.children) {
                builder = child.toXContent(builder, params);
            }
            builder = builder.endArray();
        }
        builder = builder.endObject();
        return builder;
    }

    public static CollectorResult fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
        String currentFieldName = null;
        String name = null;
        String reason = null;
        long time = -1L;
        ArrayList<CollectorResult> children = new ArrayList<CollectorResult>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (NAME.match(currentFieldName, parser.getDeprecationHandler())) {
                    name = parser.text();
                    continue;
                }
                if (REASON.match(currentFieldName, parser.getDeprecationHandler())) {
                    reason = parser.text();
                    continue;
                }
                if (TIME.match(currentFieldName, parser.getDeprecationHandler())) {
                    parser.text();
                    continue;
                }
                if (TIME_NANOS.match(currentFieldName, parser.getDeprecationHandler())) {
                    time = parser.longValue();
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (CHILDREN.match(currentFieldName, parser.getDeprecationHandler())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        children.add(CollectorResult.fromXContent(parser));
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            parser.skipChildren();
        }
        return new CollectorResult(name, reason, time, children);
    }
}

