/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.script.AbstractLongFieldScript;
import org.elasticsearch.script.CompositeFieldScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptFactory;
import org.elasticsearch.search.lookup.SearchLookup;

public abstract class GeoPointFieldScript
extends AbstractLongFieldScript {
    public static final ScriptContext<Factory> CONTEXT = GeoPointFieldScript.newContext("geo_point_field", Factory.class);
    public static final Factory PARSE_FROM_SOURCE = new Factory(){

        @Override
        public LeafFactory newFactory(String field, Map<String, Object> params, SearchLookup lookup) {
            return ctx -> new GeoPointFieldScript(field, params, lookup, ctx){

                @Override
                public void execute() {
                    this.emitFromSource();
                }
            };
        }

        @Override
        public boolean isResultDeterministic() {
            return true;
        }
    };
    public static final String[] PARAMETERS = new String[0];
    private final GeoPoint scratch = new GeoPoint();

    public static Factory leafAdapter(Function<SearchLookup, CompositeFieldScript.LeafFactory> parentFactory) {
        return (leafFieldName, params, searchLookup) -> {
            CompositeFieldScript.LeafFactory parentLeafFactory = (CompositeFieldScript.LeafFactory)parentFactory.apply(searchLookup);
            return ctx -> {
                final CompositeFieldScript compositeFieldScript = parentLeafFactory.newInstance(ctx);
                return new GeoPointFieldScript(leafFieldName, params, searchLookup, ctx){

                    @Override
                    public void setDocument(int docId) {
                        compositeFieldScript.setDocument(docId);
                    }

                    @Override
                    public void execute() {
                        this.emitFromCompositeScript(compositeFieldScript);
                    }
                };
            };
        };
    }

    public GeoPointFieldScript(String fieldName, Map<String, Object> params, SearchLookup searchLookup, LeafReaderContext ctx) {
        super(fieldName, params, searchLookup, ctx);
    }

    public void runGeoPointForDoc(int doc, Consumer<GeoPoint> consumer) {
        this.runForDoc(doc);
        GeoPoint point = new GeoPoint();
        for (int i = 0; i < this.count(); ++i) {
            int lat = (int)(this.values()[i] >>> 32);
            int lon = (int)(this.values()[i] & 0xFFFFFFFFFFFFFFFFL);
            point.reset(GeoEncodingUtils.decodeLatitude(lat), GeoEncodingUtils.decodeLongitude(lon));
            consumer.accept(point);
        }
    }

    @Override
    protected List<Object> extractFromSource(String path) {
        Object value = XContentMapValues.extractValue(path, this.sourceLookup.source());
        if (value instanceof List) {
            List list = (List)value;
            if (list.size() > 0 && list.get(0) instanceof Number) {
                return Collections.singletonList(list);
            }
            return list;
        }
        return Collections.singletonList(value);
    }

    @Override
    protected void emitFromObject(Object value) {
        if (value instanceof List) {
            List values = (List)value;
            if (values.size() > 0 && values.get(0) instanceof Number) {
                this.emitPoint(value);
            } else {
                for (Object point : values) {
                    this.emitPoint(point);
                }
            }
        } else {
            this.emitPoint(value);
        }
    }

    private void emitPoint(Object point) {
        if (point != null) {
            try {
                GeoUtils.parseGeoPoint(point, this.scratch, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.emit(this.scratch.lat(), this.scratch.lon());
        }
    }

    protected final void emit(double lat, double lon) {
        int latitudeEncoded = GeoEncodingUtils.encodeLatitude(lat);
        int longitudeEncoded = GeoEncodingUtils.encodeLongitude(lon);
        this.emit((long)latitudeEncoded << 32 | (long)longitudeEncoded & 0xFFFFFFFFL);
    }

    public static interface Factory
    extends ScriptFactory {
        public LeafFactory newFactory(String var1, Map<String, Object> var2, SearchLookup var3);
    }

    public static interface LeafFactory {
        public GeoPointFieldScript newInstance(LeafReaderContext var1);
    }

    public static class Emit {
        private final GeoPointFieldScript script;

        public Emit(GeoPointFieldScript script) {
            this.script = script;
        }

        public void emit(double lat, double lon) {
            this.script.emit(lat, lon);
        }
    }
}

