/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.protocol.xpack.license;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public enum LicenseStatus implements Writeable
{
    ACTIVE("active"),
    INVALID("invalid"),
    EXPIRED("expired");

    private final String label;

    private LicenseStatus(String label) {
        this.label = label;
    }

    public String label() {
        return this.label;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.label);
    }

    public static LicenseStatus readFrom(StreamInput in) throws IOException {
        return LicenseStatus.fromString(in.readString());
    }

    public static LicenseStatus fromString(String value) {
        switch (value) {
            case "active": {
                return ACTIVE;
            }
            case "invalid": {
                return INVALID;
            }
            case "expired": {
                return EXPIRED;
            }
        }
        throw new IllegalArgumentException("unknown license status [" + value + "]");
    }
}

