/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.util.SPIClassIterator;
import org.elasticsearch.Build;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.node.info.PluginsAndModules;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.jdk.JarHell;
import org.elasticsearch.node.ReportingService;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginInfo;
import org.elasticsearch.plugins.PluginLoaderIndirection;
import org.elasticsearch.plugins.PluginType;
import org.elasticsearch.threadpool.ExecutorBuilder;

public class PluginsService
implements ReportingService<PluginsAndModules> {
    private static final Logger logger = LogManager.getLogger(PluginsService.class);
    private final Settings settings;
    private final Path configPath;
    private final List<Tuple<PluginInfo, Plugin>> plugins;
    private final PluginsAndModules info;
    public static final Setting<List<String>> MANDATORY_SETTING = Setting.listSetting("plugin.mandatory", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);

    public List<Setting<?>> getPluginSettings() {
        return this.plugins.stream().flatMap(p -> ((Plugin)p.v2()).getSettings().stream()).collect(Collectors.toList());
    }

    public List<String> getPluginSettingsFilter() {
        return this.plugins.stream().flatMap(p -> ((Plugin)p.v2()).getSettingsFilter().stream()).collect(Collectors.toList());
    }

    public PluginsService(Settings settings, Path configPath, Path modulesDirectory, Path pluginsDirectory, Collection<Class<? extends Plugin>> classpathPlugins) {
        this.settings = settings;
        this.configPath = configPath;
        ArrayList<Tuple<Object, Plugin>> pluginsLoaded = new ArrayList<Tuple<Object, Plugin>>();
        ArrayList<PluginInfo> pluginsList = new ArrayList<PluginInfo>();
        ArrayList<String> pluginsNames = new ArrayList<String>();
        for (Class<? extends Plugin> pluginClass : classpathPlugins) {
            Plugin plugin = this.loadPlugin(pluginClass, settings, configPath);
            PluginInfo pluginInfo = new PluginInfo(pluginClass.getName(), "classpath plugin", "NA", Version.CURRENT, "1.8", pluginClass.getName(), Collections.emptyList(), false, PluginType.ISOLATED, "", false);
            if (logger.isTraceEnabled()) {
                logger.trace("plugin loaded from classpath [{}]", (Object)pluginInfo);
            }
            pluginsLoaded.add(new Tuple<Object, Plugin>(pluginInfo, plugin));
            pluginsList.add(pluginInfo);
            pluginsNames.add(pluginInfo.getName());
        }
        LinkedHashSet<Bundle> seenBundles = new LinkedHashSet<Bundle>();
        ArrayList<PluginInfo> modulesList = new ArrayList<PluginInfo>();
        if (modulesDirectory != null) {
            try {
                Set<Bundle> modules = PluginsService.getModuleBundles(modulesDirectory);
                for (Bundle bundle : modules) {
                    modulesList.add(bundle.plugin);
                }
                seenBundles.addAll(modules);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to initialize modules", ex);
            }
        }
        if (pluginsDirectory != null) {
            try {
                if (FileSystemUtils.isAccessibleDirectory(pluginsDirectory, logger)) {
                    PluginsService.checkForFailedPluginRemovals(pluginsDirectory);
                    Set<Bundle> plugins = PluginsService.getPluginBundles(pluginsDirectory);
                    for (Bundle bundle : plugins) {
                        pluginsList.add(bundle.plugin);
                        pluginsNames.add(bundle.plugin.getName());
                    }
                    seenBundles.addAll(plugins);
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to initialize plugins", ex);
            }
        }
        List<Tuple<PluginInfo, Plugin>> loaded = this.loadBundles(seenBundles);
        pluginsLoaded.addAll(loaded);
        this.info = new PluginsAndModules(pluginsList, modulesList);
        this.plugins = Collections.unmodifiableList(pluginsLoaded);
        List<String> mandatoryPlugins = MANDATORY_SETTING.get(settings);
        if (!mandatoryPlugins.isEmpty()) {
            HashSet<String> missingPlugins = new HashSet<String>();
            for (String mandatoryPlugin : mandatoryPlugins) {
                if (pluginsNames.contains(mandatoryPlugin) || missingPlugins.contains(mandatoryPlugin)) continue;
                missingPlugins.add(mandatoryPlugin);
            }
            if (!missingPlugins.isEmpty()) {
                String message = String.format(Locale.ROOT, "missing mandatory plugins [%s], found plugins [%s]", Strings.collectionToDelimitedString(missingPlugins, ", "), Strings.collectionToDelimitedString(pluginsNames, ", "));
                throw new IllegalStateException(message);
            }
        }
        PluginsService.logPluginInfo(this.info.getModuleInfos(), "module", logger);
        PluginsService.logPluginInfo(this.info.getPluginInfos(), "plugin", logger);
    }

    private static void logPluginInfo(List<PluginInfo> pluginInfos, String type, Logger logger) {
        assert (pluginInfos != null);
        if (pluginInfos.isEmpty()) {
            logger.info("no " + type + "s loaded");
        } else {
            for (String name : pluginInfos.stream().map(PluginInfo::getName).sorted().collect(Collectors.toList())) {
                logger.info("loaded " + type + " [" + name + "]");
            }
        }
    }

    public Settings updatedSettings() {
        HashMap<String, String> foundSettings = new HashMap<String, String>();
        TreeMap<String, String> features = new TreeMap<String, String>();
        Settings.Builder builder = Settings.builder();
        for (Tuple<PluginInfo, Plugin> plugin : this.plugins) {
            Settings settings = plugin.v2().additionalSettings();
            for (String setting : settings.keySet()) {
                String oldPlugin = foundSettings.put(setting, plugin.v1().getName());
                if (oldPlugin == null) continue;
                throw new IllegalArgumentException("Cannot have additional setting [" + setting + "] in plugin [" + plugin.v1().getName() + "], already added in plugin [" + oldPlugin + "]");
            }
            builder.put(settings);
            Optional<String> maybeFeature = plugin.v2().getFeature();
            if (!maybeFeature.isPresent()) continue;
            String feature = maybeFeature.get();
            if (features.containsKey(feature)) {
                String message = String.format(Locale.ROOT, "duplicate feature [%s] in plugin [%s], already added in [%s]", feature, plugin.v1().getName(), features.get(feature));
                throw new IllegalArgumentException(message);
            }
            features.put(feature, plugin.v1().getName());
        }
        for (String feature : features.keySet()) {
            builder.put("transport.features." + feature, true);
        }
        return builder.put(this.settings).build();
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Tuple<PluginInfo, Plugin> plugin : this.plugins) {
            modules.addAll(plugin.v2().createGuiceModules());
        }
        return modules;
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        ArrayList builders = new ArrayList();
        for (Tuple<PluginInfo, Plugin> plugin : this.plugins) {
            builders.addAll(plugin.v2().getExecutorBuilders(settings));
        }
        return builders;
    }

    public Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        ArrayList<Class<? extends LifecycleComponent>> services = new ArrayList<Class<? extends LifecycleComponent>>();
        for (Tuple<PluginInfo, Plugin> plugin : this.plugins) {
            services.addAll(plugin.v2().getGuiceServiceClasses());
        }
        return services;
    }

    public void onIndexModule(IndexModule indexModule) {
        for (Tuple<PluginInfo, Plugin> plugin : this.plugins) {
            plugin.v2().onIndexModule(indexModule);
        }
    }

    @Override
    public PluginsAndModules info() {
        return this.info;
    }

    public static List<Path> findPluginDirs(Path rootPath) throws IOException {
        ArrayList<Path> plugins = new ArrayList<Path>();
        HashSet<String> seen = new HashSet<String>();
        if (Files.exists(rootPath, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(rootPath);){
                for (Path plugin : stream) {
                    String filename = plugin.getFileName().toString();
                    if (FileSystemUtils.isDesktopServicesStore(plugin) || filename.startsWith(".removing-") || filename.equals(".elasticsearch-plugins.yml.cache")) continue;
                    if (!seen.add(filename)) {
                        throw new IllegalStateException("duplicate plugin: " + plugin);
                    }
                    plugins.add(plugin);
                }
            }
        }
        return plugins;
    }

    public static void verifyCompatibility(PluginInfo info) {
        if (!info.getElasticsearchVersion().equals(Version.CURRENT)) {
            throw new IllegalArgumentException("Plugin [" + info.getName() + "] was built for Elasticsearch version " + info.getElasticsearchVersion() + " but version " + Version.CURRENT + " is running");
        }
        JarHell.checkJavaVersion(info.getName(), info.getJavaVersion());
    }

    public static void checkForFailedPluginRemovals(Path pluginsDirectory) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(pluginsDirectory, ".removing-*");){
            Iterator<Path> iterator = stream.iterator();
            if (iterator.hasNext()) {
                Path removing = iterator.next();
                String fileName = removing.getFileName().toString();
                String name = fileName.substring(1 + fileName.indexOf("-"));
                String message = String.format(Locale.ROOT, "found file [%s] from a failed attempt to remove the plugin [%s]; execute [elasticsearch-plugin remove %2$s]", removing, name);
                throw new IllegalStateException(message);
            }
        }
    }

    public static Set<Bundle> getModuleBundles(Path modulesDirectory) throws IOException {
        return PluginsService.findBundles(modulesDirectory, "module");
    }

    public static Set<Bundle> getPluginBundles(Path pluginsDirectory) throws IOException {
        return PluginsService.findBundles(pluginsDirectory, "plugin");
    }

    private static Set<Bundle> findBundles(Path directory, String type) throws IOException {
        HashSet<Bundle> bundles = new HashSet<Bundle>();
        for (Path plugin : PluginsService.findPluginDirs(directory)) {
            Bundle bundle = PluginsService.readPluginBundle(plugin, type);
            if (!bundles.add(bundle)) {
                throw new IllegalStateException("duplicate " + type + ": " + bundle.plugin);
            }
            if (!type.equals("module") || !bundle.plugin.getName().startsWith("test-") || Build.CURRENT.isSnapshot()) continue;
            throw new IllegalStateException("external test module [" + plugin.getFileName() + "] found in non-snapshot build");
        }
        logger.trace(() -> "findBundles(" + type + ") returning: " + bundles.stream().map(b -> b.plugin.getName()).sorted().collect(Collectors.toList()));
        return bundles;
    }

    private static Bundle readPluginBundle(Path plugin, String type) throws IOException {
        PluginInfo info;
        try {
            info = PluginInfo.readFromProperties(plugin);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not load plugin descriptor for " + type + " directory [" + plugin.getFileName() + "]", e);
        }
        return new Bundle(info, plugin);
    }

    public static List<Bundle> sortBundles(Set<Bundle> bundles) {
        Map<String, Bundle> namedBundles = bundles.stream().collect(Collectors.toMap(b -> b.plugin.getName(), Function.identity()));
        LinkedHashSet<Bundle> sortedBundles = new LinkedHashSet<Bundle>();
        LinkedHashSet<String> dependencyStack = new LinkedHashSet<String>();
        for (Bundle bundle : bundles) {
            PluginsService.addSortedBundle(bundle, namedBundles, sortedBundles, dependencyStack);
        }
        return new ArrayList<Bundle>(sortedBundles);
    }

    private static void addSortedBundle(Bundle bundle, Map<String, Bundle> bundles, LinkedHashSet<Bundle> sortedBundles, LinkedHashSet<String> dependencyStack) {
        String name = bundle.plugin.getName();
        if (dependencyStack.contains(name)) {
            StringBuilder msg = new StringBuilder("Cycle found in plugin dependencies: ");
            dependencyStack.forEach(s -> {
                msg.append((String)s);
                msg.append(" -> ");
            });
            msg.append(name);
            throw new IllegalStateException(msg.toString());
        }
        if (sortedBundles.contains(bundle)) {
            return;
        }
        dependencyStack.add(name);
        for (String dependency : bundle.plugin.getExtendedPlugins()) {
            Bundle depBundle = bundles.get(dependency);
            if (depBundle == null) {
                throw new IllegalArgumentException("Missing plugin [" + dependency + "], dependency of [" + name + "]");
            }
            PluginsService.addSortedBundle(depBundle, bundles, sortedBundles, dependencyStack);
            assert (sortedBundles.contains(depBundle));
        }
        dependencyStack.remove(name);
        sortedBundles.add(bundle);
    }

    private List<Tuple<PluginInfo, Plugin>> loadBundles(Set<Bundle> bundles) {
        ArrayList<Tuple<PluginInfo, Plugin>> plugins = new ArrayList<Tuple<PluginInfo, Plugin>>();
        HashMap<String, Tuple<Plugin, ClassLoader>> loaded = new HashMap<String, Tuple<Plugin, ClassLoader>>();
        HashMap<String, Set<URL>> transitiveUrls = new HashMap<String, Set<URL>>();
        List<Bundle> sortedBundles = PluginsService.sortBundles(bundles);
        for (Bundle bundle : sortedBundles) {
            if (bundle.plugin.getType() == PluginType.BOOTSTRAP) continue;
            PluginsService.checkBundleJarHell(JarHell.parseClassPath(), bundle, transitiveUrls);
            Plugin plugin = this.loadBundle(bundle, loaded);
            plugins.add(new Tuple<PluginInfo, Plugin>(bundle.plugin, plugin));
        }
        PluginsService.loadExtensions(plugins);
        return Collections.unmodifiableList(plugins);
    }

    static void loadExtensions(List<Tuple<PluginInfo, Plugin>> plugins) {
        Map extendingPluginsByName = plugins.stream().flatMap(t -> ((PluginInfo)t.v1()).getExtendedPlugins().stream().map(extendedPlugin -> Tuple.tuple(extendedPlugin, (Plugin)t.v2()))).collect(Collectors.groupingBy(Tuple::v1, Collectors.mapping(Tuple::v2, Collectors.toList())));
        for (Tuple<PluginInfo, Plugin> pluginTuple : plugins) {
            if (!(pluginTuple.v2() instanceof ExtensiblePlugin)) continue;
            PluginsService.loadExtensionsForPlugin((ExtensiblePlugin)((Object)pluginTuple.v2()), extendingPluginsByName.getOrDefault(pluginTuple.v1().getName(), Collections.emptyList()));
        }
    }

    private static void loadExtensionsForPlugin(ExtensiblePlugin extensiblePlugin, final List<Plugin> extendingPlugins) {
        ExtensiblePlugin.ExtensionLoader extensionLoader = new ExtensiblePlugin.ExtensionLoader(){

            @Override
            public <T> List<T> loadExtensions(Class<T> extensionPointType) {
                ArrayList result = new ArrayList();
                for (Plugin extendingPlugin : extendingPlugins) {
                    result.addAll(PluginsService.createExtensions(extensionPointType, extendingPlugin));
                }
                return Collections.unmodifiableList(result);
            }
        };
        extensiblePlugin.loadExtensions(extensionLoader);
    }

    private static <T> List<? extends T> createExtensions(Class<T> extensionPointType, Plugin plugin) {
        SPIClassIterator<T> classIterator = SPIClassIterator.get(extensionPointType, plugin.getClass().getClassLoader());
        ArrayList<T> extensions = new ArrayList<T>();
        while (classIterator.hasNext()) {
            Object extensionClass = classIterator.next();
            extensions.add(PluginsService.createExtension(extensionClass, extensionPointType, plugin));
        }
        return extensions;
    }

    static <T> T createExtension(Class<? extends T> extensionClass, Class<T> extensionPointType, Plugin plugin) {
        Constructor<?>[] constructors = extensionClass.getConstructors();
        if (constructors.length == 0) {
            throw new IllegalStateException("no public " + PluginsService.extensionConstructorMessage(extensionClass, extensionPointType));
        }
        if (constructors.length > 1) {
            throw new IllegalStateException("no unique public " + PluginsService.extensionConstructorMessage(extensionClass, extensionPointType));
        }
        Constructor<?> constructor = constructors[0];
        if (constructor.getParameterCount() > 1) {
            throw new IllegalStateException(PluginsService.extensionSignatureMessage(extensionClass, extensionPointType, plugin));
        }
        if (constructor.getParameterCount() == 1 && constructor.getParameterTypes()[0] != plugin.getClass()) {
            throw new IllegalStateException(PluginsService.extensionSignatureMessage(extensionClass, extensionPointType, plugin) + ", not (" + constructor.getParameterTypes()[0].getName() + ")");
        }
        try {
            if (constructor.getParameterCount() == 0) {
                return (T)constructor.newInstance(new Object[0]);
            }
            return (T)constructor.newInstance(plugin);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("failed to create extension [" + extensionClass.getName() + "] of type [" + extensionPointType.getName() + "]", e);
        }
    }

    private static <T> String extensionSignatureMessage(Class<? extends T> extensionClass, Class<T> extensionPointType, Plugin plugin) {
        return "signature of " + PluginsService.extensionConstructorMessage(extensionClass, extensionPointType) + " must be either () or (" + plugin.getClass().getName() + ")";
    }

    private static <T> String extensionConstructorMessage(Class<? extends T> extensionClass, Class<T> extensionPointType) {
        return "constructor for extension [" + extensionClass.getName() + "] of type [" + extensionPointType.getName() + "]";
    }

    public static void checkBundleJarHell(Set<URL> classpath, Bundle bundle, Map<String, Set<URL>> transitiveUrls) {
        List<String> exts = bundle.plugin.getExtendedPlugins();
        try {
            Logger logger = LogManager.getLogger(JarHell.class);
            HashSet<URL> extendedPluginUrls = new HashSet<URL>();
            for (String extendedPlugin : exts) {
                Set<URL> pluginUrls = transitiveUrls.get(extendedPlugin);
                assert (pluginUrls != null) : "transitive urls should have already been set for " + extendedPlugin;
                HashSet<Object> intersection = new HashSet(extendedPluginUrls);
                intersection.retainAll(pluginUrls);
                if (!intersection.isEmpty()) {
                    throw new IllegalStateException("jar hell! extended plugins " + exts + " have duplicate codebases with each other: " + intersection);
                }
                extendedPluginUrls.addAll(pluginUrls);
                JarHell.checkJarHell(extendedPluginUrls, logger::debug);
                intersection = new HashSet<URL>(bundle.allUrls);
                intersection.retainAll(pluginUrls);
                if (!intersection.isEmpty()) {
                    throw new IllegalStateException("jar hell! duplicate codebases with extended plugin [" + extendedPlugin + "]: " + intersection);
                }
                HashSet<URL> implementation = new HashSet<URL>(bundle.allUrls);
                implementation.addAll(extendedPluginUrls);
                JarHell.checkJarHell(implementation, logger::debug);
            }
            extendedPluginUrls.addAll(bundle.getExtensionUrls());
            transitiveUrls.put(bundle.plugin.getName(), extendedPluginUrls);
            HashSet<URL> intersection = new HashSet<URL>(classpath);
            intersection.retainAll(bundle.allUrls);
            if (!intersection.isEmpty()) {
                throw new IllegalStateException("jar hell! duplicate codebases between plugin and core: " + intersection);
            }
            HashSet<URL> union = new HashSet<URL>(classpath);
            union.addAll(bundle.allUrls);
            JarHell.checkJarHell(union, logger::debug);
        }
        catch (IllegalStateException ise) {
            throw new IllegalStateException("failed to load plugin " + bundle.plugin.getName() + " due to jar hell", ise);
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to load plugin " + bundle.plugin.getName() + " while checking for jar hell", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Plugin loadBundle(Bundle bundle, Map<String, Tuple<Plugin, ClassLoader>> loaded) {
        String name = bundle.plugin.getName();
        PluginsService.verifyCompatibility(bundle.plugin);
        ArrayList<ClassLoader> extendedLoaders = new ArrayList<ClassLoader>();
        for (String extendedPluginName : bundle.plugin.getExtendedPlugins()) {
            Tuple<Plugin, ClassLoader> extendedPlugin = loaded.get(extendedPluginName);
            assert (extendedPlugin != null);
            if (!ExtensiblePlugin.class.isInstance(extendedPlugin.v1())) {
                throw new IllegalStateException("Plugin [" + name + "] cannot extend non-extensible plugin [" + extendedPluginName + "]");
            }
            extendedLoaders.add(extendedPlugin.v2());
        }
        ClassLoader parentLoader = PluginLoaderIndirection.createLoader(this.getClass().getClassLoader(), extendedLoaders);
        URLClassLoader spiLoader = null;
        if (bundle.spiUrls != null) {
            spiLoader = URLClassLoader.newInstance(bundle.spiUrls.toArray(new URL[0]), parentLoader);
        }
        URLClassLoader loader = URLClassLoader.newInstance(bundle.urls.toArray(new URL[0]), spiLoader == null ? parentLoader : spiLoader);
        if (spiLoader == null) {
            spiLoader = loader;
        }
        PluginsService.reloadLuceneSPI(loader);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            AccessController.doPrivileged(() -> {
                Thread.currentThread().setContextClassLoader(loader);
                return null;
            });
            Class<? extends Plugin> pluginClass = this.loadPluginClass(bundle.plugin.getClassname(), loader);
            if (loader != pluginClass.getClassLoader()) {
                throw new IllegalStateException("Plugin [" + name + "] must reference a class loader local Plugin class [" + bundle.plugin.getClassname() + "] (class loader [" + pluginClass.getClassLoader() + "])");
            }
            Plugin plugin = this.loadPlugin(pluginClass, this.settings, this.configPath);
            loaded.put(name, Tuple.tuple(plugin, spiLoader));
            Plugin plugin2 = plugin;
            return plugin2;
        }
        finally {
            AccessController.doPrivileged(() -> {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            });
        }
    }

    static void reloadLuceneSPI(ClassLoader loader) {
        PostingsFormat.reloadPostingsFormats(loader);
        DocValuesFormat.reloadDocValuesFormats(loader);
        Codec.reloadCodecs(loader);
    }

    private Class<? extends Plugin> loadPluginClass(String className, ClassLoader loader) {
        try {
            return Class.forName(className, false, loader).asSubclass(Plugin.class);
        }
        catch (ClassNotFoundException e) {
            throw new ElasticsearchException("Could not find plugin class [" + className + "]", (Throwable)e, new Object[0]);
        }
    }

    private Plugin loadPlugin(Class<? extends Plugin> pluginClass, Settings settings, Path configPath) {
        Constructor<?>[] constructors = pluginClass.getConstructors();
        if (constructors.length == 0) {
            throw new IllegalStateException("no public constructor for [" + pluginClass.getName() + "]");
        }
        if (constructors.length > 1) {
            throw new IllegalStateException("no unique public constructor for [" + pluginClass.getName() + "]");
        }
        Constructor<?> constructor = constructors[0];
        if (constructor.getParameterCount() > 2) {
            throw new IllegalStateException(this.signatureMessage(pluginClass));
        }
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        try {
            if (constructor.getParameterCount() == 2 && parameterTypes[0] == Settings.class && parameterTypes[1] == Path.class) {
                return (Plugin)constructor.newInstance(settings, configPath);
            }
            if (constructor.getParameterCount() == 1 && parameterTypes[0] == Settings.class) {
                return (Plugin)constructor.newInstance(settings);
            }
            if (constructor.getParameterCount() == 0) {
                return (Plugin)constructor.newInstance(new Object[0]);
            }
            throw new IllegalStateException(this.signatureMessage(pluginClass));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("failed to load plugin class [" + pluginClass.getName() + "]", e);
        }
    }

    private String signatureMessage(Class<? extends Plugin> clazz) {
        return String.format(Locale.ROOT, "no public constructor of correct signature for [%s]; must be [%s], [%s], or [%s]", clazz.getName(), "(org.elasticsearch.common.settings.Settings,java.nio.file.Path)", "(org.elasticsearch.common.settings.Settings)", "()");
    }

    public <T> List<T> filterPlugins(Class<T> type) {
        return this.plugins.stream().filter(x -> type.isAssignableFrom(((Plugin)x.v2()).getClass())).map(p -> p.v2()).collect(Collectors.toList());
    }

    public static class Bundle {
        public final PluginInfo plugin;
        public final Set<URL> urls;
        public final Set<URL> spiUrls;
        public final Set<URL> allUrls;

        public Bundle(PluginInfo plugin, Path dir) throws IOException {
            this.plugin = Objects.requireNonNull(plugin);
            Path spiDir = dir.resolve("spi");
            this.spiUrls = Files.exists(spiDir, new LinkOption[0]) ? Bundle.gatherUrls(spiDir) : null;
            this.urls = Bundle.gatherUrls(dir);
            LinkedHashSet<URL> allUrls = new LinkedHashSet<URL>(this.urls);
            if (this.spiUrls != null) {
                allUrls.addAll(this.spiUrls);
            }
            this.allUrls = allUrls;
        }

        static Set<URL> gatherUrls(Path dir) throws IOException {
            LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
            try (DirectoryStream<Path> jarStream = Files.newDirectoryStream(dir, "*.jar");){
                for (Path jar : jarStream) {
                    URL url = jar.toRealPath(new LinkOption[0]).toUri().toURL();
                    if (urls.add(url)) continue;
                    throw new IllegalStateException("duplicate codebase: " + url);
                }
            }
            return urls;
        }

        Set<URL> getExtensionUrls() {
            if (this.spiUrls != null) {
                return this.spiUrls;
            }
            return this.urls;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bundle bundle = (Bundle)o;
            return Objects.equals(this.plugin, bundle.plugin);
        }

        public int hashCode() {
            return Objects.hash(this.plugin);
        }
    }
}

