/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.protocol.xpack.common.ProtocolUtils;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class PostStartBasicResponse
extends AcknowledgedResponse
implements StatusToXContentObject {
    private static final ParseField BASIC_WAS_STARTED_FIELD = new ParseField("basic_was_started", new String[0]);
    private static final ParseField ERROR_MESSAGE_FIELD = new ParseField("error_message", new String[0]);
    private static final ParseField MESSAGE_FIELD = new ParseField("message", new String[0]);
    private final Map<String, String[]> acknowledgeMessages;
    private final String acknowledgeMessage;
    private final Status status;

    public PostStartBasicResponse(StreamInput in) throws IOException {
        super(in);
        this.status = in.readEnum(Status.class);
        this.acknowledgeMessage = in.readOptionalString();
        int size = in.readVInt();
        HashMap<String, String[]> acknowledgeMessages = new HashMap<String, String[]>(size);
        for (int i = 0; i < size; ++i) {
            String feature = in.readString();
            int nMessages = in.readVInt();
            String[] messages = new String[nMessages];
            for (int j = 0; j < nMessages; ++j) {
                messages[j] = in.readString();
            }
            acknowledgeMessages.put(feature, messages);
        }
        this.acknowledgeMessages = acknowledgeMessages;
    }

    PostStartBasicResponse(Status status) {
        this(status, Collections.emptyMap(), null);
    }

    public PostStartBasicResponse(Status status, Map<String, String[]> acknowledgeMessages, String acknowledgeMessage) {
        super(status != Status.NEED_ACKNOWLEDGEMENT);
        this.status = status;
        this.acknowledgeMessages = acknowledgeMessages;
        this.acknowledgeMessage = acknowledgeMessage;
    }

    public Status getStatus() {
        return this.status;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeEnum(this.status);
        out.writeOptionalString(this.acknowledgeMessage);
        out.writeVInt(this.acknowledgeMessages.size());
        for (Map.Entry<String, String[]> entry : this.acknowledgeMessages.entrySet()) {
            out.writeString(entry.getKey());
            out.writeVInt(entry.getValue().length);
            for (String message : entry.getValue()) {
                out.writeString(message);
            }
        }
    }

    @Override
    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.status.isBasicStarted()) {
            builder.field(BASIC_WAS_STARTED_FIELD.getPreferredName(), true);
        } else {
            builder.field(BASIC_WAS_STARTED_FIELD.getPreferredName(), false);
            builder.field(ERROR_MESSAGE_FIELD.getPreferredName(), this.status.getErrorMessage());
        }
        if (!this.acknowledgeMessages.isEmpty()) {
            builder.startObject("acknowledge");
            builder.field(MESSAGE_FIELD.getPreferredName(), this.acknowledgeMessage);
            for (Map.Entry<String, String[]> entry : this.acknowledgeMessages.entrySet()) {
                builder.startArray(entry.getKey());
                for (String message : entry.getValue()) {
                    builder.value(message);
                }
                builder.endArray();
            }
            builder.endObject();
        }
    }

    @Override
    public RestStatus status() {
        return this.status.restStatus;
    }

    public String getAcknowledgeMessage() {
        return this.acknowledgeMessage;
    }

    public Map<String, String[]> getAcknowledgeMessages() {
        return this.acknowledgeMessages;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PostStartBasicResponse that = (PostStartBasicResponse)o;
        return this.status == that.status && ProtocolUtils.equals(this.acknowledgeMessages, that.acknowledgeMessages) && Objects.equals(this.acknowledgeMessage, that.acknowledgeMessage);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.status, ProtocolUtils.hashCode(this.acknowledgeMessages), this.acknowledgeMessage});
    }

    public static enum Status {
        GENERATED_BASIC(true, null, RestStatus.OK),
        ALREADY_USING_BASIC(false, "Operation failed: Current license is basic.", RestStatus.FORBIDDEN),
        NEED_ACKNOWLEDGEMENT(false, "Operation failed: Needs acknowledgement.", RestStatus.OK);

        private final boolean isBasicStarted;
        private final String errorMessage;
        private final RestStatus restStatus;

        private Status(boolean isBasicStarted, String errorMessage, RestStatus restStatus) {
            this.isBasicStarted = isBasicStarted;
            this.errorMessage = errorMessage;
            this.restStatus = restStatus;
        }

        public boolean isBasicStarted() {
            return this.isBasicStarted;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        RestStatus getRestStatus() {
            return this.restStatus;
        }
    }
}

