/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.MergableCustomMetadata;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.license.License;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.XPackPlugin;

public class LicensesMetadata
extends AbstractNamedDiffable<Metadata.Custom>
implements XPackPlugin.XPackMetadataCustom,
MergableCustomMetadata<LicensesMetadata> {
    public static final String TYPE = "licenses";
    public static final License LICENSE_TOMBSTONE = License.builder().type(License.LicenseType.TRIAL).issuer("elasticsearch").uid("TOMBSTONE").issuedTo("").maxNodes(0).issueDate(0L).expiryDate(0L).build();
    private License license;
    @Nullable
    private Version trialVersion;

    LicensesMetadata(License license, Version trialVersion) {
        this.license = license;
        this.trialVersion = trialVersion;
    }

    public License getLicense() {
        return this.license;
    }

    boolean isEligibleForTrial() {
        if (this.trialVersion == null) {
            return true;
        }
        return Version.CURRENT.major > this.trialVersion.major;
    }

    Version getMostRecentTrialVersion() {
        return this.trialVersion;
    }

    public String toString() {
        return "LicensesMetadata{license=" + this.license + ", trialVersion=" + this.trialVersion + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LicensesMetadata that = (LicensesMetadata)o;
        return Objects.equals(this.license, that.license) && Objects.equals(this.trialVersion, that.trialVersion);
    }

    public int hashCode() {
        int result = this.license != null ? this.license.hashCode() : 0;
        result = 31 * result + (this.trialVersion != null ? this.trialVersion.hashCode() : 0);
        return result;
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumCompatibilityVersion();
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return EnumSet.of(Metadata.XContentContext.GATEWAY);
    }

    public static LicensesMetadata fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        License license = LICENSE_TOMBSTONE;
        Version trialLicense = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            String fieldName;
            if (token != XContentParser.Token.FIELD_NAME || (fieldName = parser.currentName()) == null) continue;
            if (fieldName.equals("license")) {
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    license = License.fromXContent(parser);
                    continue;
                }
                if (token != XContentParser.Token.VALUE_NULL) continue;
                license = LICENSE_TOMBSTONE;
                continue;
            }
            if (!fieldName.equals("trial_license")) continue;
            parser.nextToken();
            trialLicense = Version.fromString(parser.text());
        }
        return new LicensesMetadata(license, trialLicense);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.license == LICENSE_TOMBSTONE) {
            builder.nullField("license");
        } else {
            builder.startObject("license");
            this.license.toInnerXContent(builder, params);
            builder.endObject();
        }
        if (this.trialVersion != null) {
            builder.field("trial_license", this.trialVersion.toString());
        }
        return builder;
    }

    @Override
    public void writeTo(StreamOutput streamOutput) throws IOException {
        if (this.license == LICENSE_TOMBSTONE) {
            streamOutput.writeBoolean(false);
        } else {
            streamOutput.writeBoolean(true);
            this.license.writeTo(streamOutput);
        }
        if (streamOutput.getVersion().onOrAfter(Version.V_6_1_0)) {
            if (this.trialVersion == null) {
                streamOutput.writeBoolean(false);
            } else {
                streamOutput.writeBoolean(true);
                Version.writeVersion(this.trialVersion, streamOutput);
            }
        }
    }

    public LicensesMetadata(StreamInput streamInput) throws IOException {
        boolean hasExercisedTrial;
        this.license = streamInput.readBoolean() ? License.readLicense(streamInput) : LICENSE_TOMBSTONE;
        if (streamInput.getVersion().onOrAfter(Version.V_6_1_0) && (hasExercisedTrial = streamInput.readBoolean())) {
            this.trialVersion = Version.readVersion(streamInput);
        }
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput streamInput) throws IOException {
        return LicensesMetadata.readDiffFrom(Metadata.Custom.class, TYPE, streamInput);
    }

    public static License extractLicense(LicensesMetadata licensesMetadata) {
        if (licensesMetadata != null) {
            License license = licensesMetadata.getLicense();
            if (license == LICENSE_TOMBSTONE) {
                return null;
            }
            return license;
        }
        return null;
    }

    @Override
    public LicensesMetadata merge(LicensesMetadata other) {
        if (other.license == null) {
            return this;
        }
        if (this.license == null || License.OperationMode.compare(other.license.operationMode(), this.license.operationMode()) > 0) {
            return other;
        }
        return this;
    }

    private static final class Fields {
        private static final String LICENSE = "license";
        private static final String TRIAL_LICENSE = "trial_license";

        private Fields() {
        }
    }
}

