/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.ingest.IngestStats;

class IngestMetric {
    private final CounterMetric ingestTimeInNanos = new CounterMetric();
    private final AtomicLong ingestCurrent = new AtomicLong();
    private final CounterMetric ingestCount = new CounterMetric();
    private final CounterMetric ingestFailed = new CounterMetric();

    IngestMetric() {
    }

    void preIngest() {
        this.ingestCurrent.incrementAndGet();
    }

    void postIngest(long ingestTimeInNanos) {
        long current = this.ingestCurrent.decrementAndGet();
        assert (current >= 0L) : "ingest metric current count double-decremented";
        this.ingestTimeInNanos.inc(ingestTimeInNanos);
        this.ingestCount.inc();
    }

    void ingestFailed() {
        this.ingestFailed.inc();
    }

    void add(IngestMetric metrics) {
        this.ingestCount.inc(metrics.ingestCount.count());
        this.ingestTimeInNanos.inc(metrics.ingestTimeInNanos.count());
        this.ingestFailed.inc(metrics.ingestFailed.count());
    }

    IngestStats.Stats createStats() {
        long ingestTimeInMillis = TimeUnit.NANOSECONDS.toMillis(this.ingestTimeInNanos.count());
        return new IngestStats.Stats(this.ingestCount.count(), ingestTimeInMillis, this.ingestCurrent.get(), this.ingestFailed.count());
    }
}

