/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceLookup;

public final class StoredValueFetcher
implements ValueFetcher {
    private final SearchLookup lookup;
    private LeafSearchLookup leafSearchLookup;
    private final String fieldname;

    public StoredValueFetcher(SearchLookup lookup, String fieldname) {
        this.lookup = lookup;
        this.fieldname = fieldname;
    }

    @Override
    public void setNextReader(LeafReaderContext context) {
        this.leafSearchLookup = this.lookup.getLeafSearchLookup(context);
    }

    @Override
    public List<Object> fetchValues(SourceLookup lookup, List<Object> ignoredValues) throws IOException {
        this.leafSearchLookup.setDocument(lookup.docId());
        return this.leafSearchLookup.fields().get(this.fieldname).getValues();
    }
}

