/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.util.Arrays;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.script.GeoPointFieldScript;

public final class GeoPointScriptDocValues
extends MultiGeoPointValues {
    private final GeoPointFieldScript script;
    private final GeoPoint point;
    private int cursor;

    GeoPointScriptDocValues(GeoPointFieldScript script) {
        this.script = script;
        this.point = new GeoPoint();
    }

    @Override
    public boolean advanceExact(int docId) {
        this.script.runForDoc(docId);
        if (this.script.count() == 0) {
            return false;
        }
        Arrays.sort(this.script.values(), 0, this.script.count());
        this.cursor = 0;
        return true;
    }

    @Override
    public int docValueCount() {
        return this.script.count();
    }

    @Override
    public GeoPoint nextValue() {
        long value = this.script.values()[this.cursor++];
        int lat = (int)(value >>> 32);
        int lon = (int)(value & 0xFFFFFFFFFFFFFFFFL);
        return this.point.reset(GeoEncodingUtils.decodeLatitude(lat), GeoEncodingUtils.decodeLongitude(lon));
    }
}

