/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.http.HttpPipelinedRequest;
import org.elasticsearch.http.HttpPipelinedResponse;
import org.elasticsearch.http.HttpRequest;

public class HttpPipeliningAggregator<Listener> {
    private final int maxEventsHeld;
    private final PriorityQueue<Tuple<HttpPipelinedResponse, Listener>> outboundHoldingQueue;
    private int readSequence;
    private int writeSequence;

    public HttpPipeliningAggregator(int maxEventsHeld) {
        this.maxEventsHeld = maxEventsHeld;
        this.outboundHoldingQueue = new PriorityQueue<Tuple>(1, Comparator.comparing(Tuple::v1));
    }

    public HttpPipelinedRequest read(HttpRequest request) {
        return new HttpPipelinedRequest(this.readSequence++, request);
    }

    public List<Tuple<HttpPipelinedResponse, Listener>> write(HttpPipelinedResponse response, Listener listener) {
        if (this.outboundHoldingQueue.size() < this.maxEventsHeld) {
            Tuple<HttpPipelinedResponse, Listener> top;
            ArrayList<Tuple<HttpPipelinedResponse, Listener>> readyResponses = new ArrayList<Tuple<HttpPipelinedResponse, Listener>>();
            this.outboundHoldingQueue.add(new Tuple<HttpPipelinedResponse, Listener>(response, listener));
            while (!this.outboundHoldingQueue.isEmpty() && (top = this.outboundHoldingQueue.peek()).v1().getSequence() == this.writeSequence) {
                this.outboundHoldingQueue.poll();
                readyResponses.add(top);
                ++this.writeSequence;
            }
            return readyResponses;
        }
        int eventCount = this.outboundHoldingQueue.size() + 1;
        throw new IllegalStateException("Too many pipelined events [" + eventCount + "]. Max events allowed [" + this.maxEventsHeld + "].");
    }

    public List<Tuple<HttpPipelinedResponse, Listener>> removeAllInflightResponses() {
        ArrayList<Tuple<HttpPipelinedResponse, Listener>> responses = new ArrayList<Tuple<HttpPipelinedResponse, Listener>>(this.outboundHoldingQueue);
        this.outboundHoldingQueue.clear();
        return responses;
    }
}

