/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;
import org.elasticsearch.common.logging.ESLogMessage;

@Plugin(name="RateLimitingFilter", category="Core", elementType="filter")
public class RateLimitingFilter
extends AbstractFilter {
    private volatile boolean useXOpaqueId = true;
    private final Set<String> lruKeyCache = Collections.newSetFromMap(Collections.synchronizedMap(new LinkedHashMap<String, Boolean>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Boolean> eldest) {
            return this.size() > 128;
        }
    }));

    public RateLimitingFilter() {
        this(Filter.Result.ACCEPT, Filter.Result.DENY);
    }

    public RateLimitingFilter(Filter.Result onMatch, Filter.Result onMismatch) {
        super(onMatch, onMismatch);
    }

    public void reset() {
        this.lruKeyCache.clear();
    }

    public Filter.Result filter(Message message) {
        if (message instanceof ESLogMessage) {
            ESLogMessage esLogMessage = (ESLogMessage)message;
            String key = this.getKey(esLogMessage);
            return this.lruKeyCache.add(key) ? Filter.Result.ACCEPT : Filter.Result.DENY;
        }
        return Filter.Result.NEUTRAL;
    }

    private String getKey(ESLogMessage esLogMessage) {
        String key = esLogMessage.getValueFor("key");
        if (this.useXOpaqueId) {
            String xOpaqueId = esLogMessage.getValueFor("x-opaque-id");
            return xOpaqueId + key;
        }
        return key;
    }

    @Override
    public Filter.Result filter(LogEvent event) {
        return this.filter(event.getMessage());
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        return this.filter(msg);
    }

    @PluginFactory
    public static RateLimitingFilter createFilter(@PluginAttribute(value="onMatch") Filter.Result match, @PluginAttribute(value="onMismatch") Filter.Result mismatch) {
        return new RateLimitingFilter(match, mismatch);
    }

    public void setUseXOpaqueId(boolean useXOpaqueId) {
        this.useXOpaqueId = useXOpaqueId;
    }
}

