/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.util.Objects;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.elasticsearch.common.logging.HeaderWarning;

@Plugin(category="Converter", name="ProductOriginConverter")
@ConverterKeys(value={"product_origin"})
public final class ProductOriginConverter
extends LogEventPatternConverter {
    public static ProductOriginConverter newInstance(String[] options) {
        return new ProductOriginConverter();
    }

    public ProductOriginConverter() {
        super("product_origin", "product_origin");
    }

    public static String getProductOrigin() {
        return HeaderWarning.THREAD_CONTEXT.stream().map(t -> t.getHeader("X-elastic-product-origin")).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        String productOrigin = ProductOriginConverter.getProductOrigin();
        if (productOrigin != null) {
            toAppendTo.append(productOrigin);
        }
    }
}

