/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.DeprecatedMessage;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.HeaderWarning;

public class DeprecationLogger {
    public static Level CRITICAL = Level.forName("CRITICAL", Level.WARN.intLevel() - 1);
    private final Logger logger;

    public static DeprecationLogger getLogger(Class<?> aClass) {
        return DeprecationLogger.getLogger(DeprecationLogger.toLoggerName(aClass));
    }

    public static DeprecationLogger getLogger(String name) {
        return new DeprecationLogger(name);
    }

    private DeprecationLogger(String parentLoggerName) {
        this.logger = LogManager.getLogger(DeprecationLogger.getLoggerName(parentLoggerName));
    }

    private static String getLoggerName(String name) {
        name = name.startsWith("org.elasticsearch") ? name.replace("org.elasticsearch.", "org.elasticsearch.deprecation.") : "deprecation." + name;
        return name;
    }

    private static String toLoggerName(Class<?> cls) {
        String canonicalName = cls.getCanonicalName();
        return canonicalName != null ? canonicalName : cls.getName();
    }

    public DeprecationLogger critical(DeprecationCategory category, String key, String msg, Object ... params) {
        return this.logDeprecation(CRITICAL, category, key, msg, params);
    }

    public DeprecationLogger warn(DeprecationCategory category, String key, String msg, Object ... params) {
        return this.logDeprecation(Level.WARN, category, key, msg, params);
    }

    private DeprecationLogger logDeprecation(Level level, DeprecationCategory category, String key, String msg, Object[] params) {
        String opaqueId = HeaderWarning.getXOpaqueId();
        String productOrigin = HeaderWarning.getProductOrigin();
        DeprecatedMessage deprecationMessage = new DeprecatedMessage(category, key, opaqueId, productOrigin, msg, params);
        this.logger.log(level, deprecationMessage);
        return this;
    }
}

