/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.filesystem;

import com.sun.jna.Native;
import com.sun.jna.WString;
import com.sun.jna.ptr.IntByReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.OptionalLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Constants;
import org.elasticsearch.common.filesystem.FileSystemNatives;

final class WindowsFileSystemNatives
implements FileSystemNatives.Provider {
    private static final Logger logger = LogManager.getLogger(WindowsFileSystemNatives.class);
    private static final WindowsFileSystemNatives INSTANCE = new WindowsFileSystemNatives();
    private static final int INVALID_FILE_SIZE = -1;
    private static final int NO_ERROR = 0;

    private WindowsFileSystemNatives() {
        assert (Constants.WINDOWS) : Constants.OS_NAME;
        try {
            Native.register("kernel32");
            logger.debug("windows/Kernel32 library loaded");
        }
        catch (LinkageError e) {
            logger.warn("unable to link Windows/Kernel32 library. native methods and handlers will be disabled.", (Throwable)e);
            throw e;
        }
    }

    static WindowsFileSystemNatives getInstance() {
        return INSTANCE;
    }

    private native int GetCompressedFileSizeW(WString var1, IntByReference var2);

    @Override
    public OptionalLong allocatedSizeInBytes(Path path) {
        int err;
        IntByReference lpFileSizeHigh;
        assert (Files.isRegularFile(path, new LinkOption[0])) : path;
        WString fileName = new WString("\\\\?\\" + path);
        int lpFileSizeLow = this.GetCompressedFileSizeW(fileName, lpFileSizeHigh = new IntByReference());
        if (lpFileSizeLow == -1 && (err = Native.getLastError()) != 0) {
            logger.warn("error [{}] when executing native method GetCompressedFileSizeW for file [{}]", (Object)err, (Object)path);
            return OptionalLong.empty();
        }
        long allocatedSize = (long)lpFileSizeHigh.getValue() << 32 | Integer.toUnsignedLong(lpFileSizeLow);
        if (logger.isTraceEnabled()) {
            logger.trace("executing native method GetCompressedFileSizeW returned [high={}, low={}, allocated={}] for file [{}]", (Object)lpFileSizeHigh, (Object)lpFileSizeLow, (Object)allocatedSize, (Object)path);
        }
        return OptionalLong.of(allocatedSize);
    }
}

