/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.routing.allocation.ShardAllocationDecision;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ShutdownShardMigrationStatus
implements Writeable,
ToXContentObject {
    private static final Version ALLOCATION_DECISION_ADDED_VERSION = Version.V_7_16_0;
    private final SingleNodeShutdownMetadata.Status status;
    private final long shardsRemaining;
    @Nullable
    private final String explanation;
    @Nullable
    private final ShardAllocationDecision allocationDecision;

    public ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status status, long shardsRemaining) {
        this(status, shardsRemaining, null, null);
    }

    public ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status status, long shardsRemaining, @Nullable String explanation) {
        this(status, shardsRemaining, explanation, null);
    }

    public ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status status, long shardsRemaining, @Nullable String explanation, @Nullable ShardAllocationDecision allocationDecision) {
        this.status = Objects.requireNonNull(status, "status must not be null");
        this.shardsRemaining = shardsRemaining;
        this.explanation = explanation;
        this.allocationDecision = allocationDecision;
    }

    public ShutdownShardMigrationStatus(StreamInput in) throws IOException {
        this.status = in.readEnum(SingleNodeShutdownMetadata.Status.class);
        this.shardsRemaining = in.readLong();
        this.explanation = in.readOptionalString();
        this.allocationDecision = in.getVersion().onOrAfter(ALLOCATION_DECISION_ADDED_VERSION) ? in.readOptionalWriteable(ShardAllocationDecision::new) : null;
    }

    public long getShardsRemaining() {
        return this.shardsRemaining;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public SingleNodeShutdownMetadata.Status getStatus() {
        return this.status;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("status", this.status);
        builder.field("shard_migrations_remaining", this.shardsRemaining);
        if (Objects.nonNull(this.explanation)) {
            builder.field("explanation", this.explanation);
        }
        if (Objects.nonNull(this.allocationDecision)) {
            builder.startObject("node_allocation_decision");
            this.allocationDecision.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this.status);
        out.writeLong(this.shardsRemaining);
        out.writeOptionalString(this.explanation);
        if (out.getVersion().onOrAfter(ALLOCATION_DECISION_ADDED_VERSION)) {
            out.writeOptionalWriteable(this.allocationDecision);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShutdownShardMigrationStatus)) {
            return false;
        }
        ShutdownShardMigrationStatus that = (ShutdownShardMigrationStatus)o;
        return this.shardsRemaining == that.shardsRemaining && this.status == that.status && Objects.equals(this.explanation, that.explanation) && Objects.equals(this.allocationDecision, that.allocationDecision);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.shardsRemaining, this.explanation, this.allocationDecision});
    }

    public String toString() {
        return Strings.toString(this);
    }
}

