/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.concurrent.Future;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.threadpool.ThreadPool;

public final class ThreadedActionListener<Response>
extends ActionListener.Delegating<Response, Response> {
    private final Logger logger;
    private final ThreadPool threadPool;
    private final String executor;
    private final boolean forceExecution;

    public ThreadedActionListener(Logger logger, ThreadPool threadPool, String executor, ActionListener<Response> listener, boolean forceExecution) {
        super(listener);
        this.logger = logger;
        this.threadPool = threadPool;
        this.executor = executor;
        this.forceExecution = forceExecution;
    }

    @Override
    public void onResponse(final Response response) {
        this.threadPool.executor(this.executor).execute(new ActionRunnable<Response>(this.delegate){

            @Override
            public boolean isForceExecution() {
                return ThreadedActionListener.this.forceExecution;
            }

            @Override
            protected void doRun() {
                this.listener.onResponse(response);
            }
        });
    }

    @Override
    public void onFailure(final Exception e) {
        this.threadPool.executor(this.executor).execute(new AbstractRunnable(){

            @Override
            public boolean isForceExecution() {
                return ThreadedActionListener.this.forceExecution;
            }

            @Override
            protected void doRun() throws Exception {
                ThreadedActionListener.this.delegate.onFailure(e);
            }

            @Override
            public void onFailure(Exception e2) {
                ThreadedActionListener.this.logger.warn(() -> new ParameterizedMessage("failed to execute failure callback on [{}]", (Object)ThreadedActionListener.this.delegate), (Throwable)e2);
            }
        });
    }

    public static class Wrapper {
        private final Logger logger;
        private final ThreadPool threadPool;
        private final boolean threadedListener;

        public Wrapper(Logger logger, Settings settings, ThreadPool threadPool) {
            this.logger = logger;
            this.threadPool = threadPool;
            this.threadedListener = "transport".equals(Client.CLIENT_TYPE_SETTING_S.get(settings));
        }

        public <Response> ActionListener<Response> wrap(ActionListener<Response> listener) {
            if (!this.threadedListener) {
                return listener;
            }
            if (listener instanceof Future) {
                return listener;
            }
            if (listener instanceof ThreadedActionListener) {
                return listener;
            }
            return new ThreadedActionListener<Response>(this.logger, this.threadPool, "listener", listener, false);
        }
    }
}

