/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.shard.ShardId;

class FieldCapabilitiesNodeRequest
extends ActionRequest
implements IndicesRequest {
    private final List<ShardId> shardIds;
    private final String[] fields;
    private final OriginalIndices originalIndices;
    private final QueryBuilder indexFilter;
    private final long nowInMillis;
    private final Map<String, Object> runtimeFields;

    FieldCapabilitiesNodeRequest(StreamInput in) throws IOException {
        super(in);
        this.shardIds = in.readList(ShardId::new);
        this.fields = in.readStringArray();
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
        this.indexFilter = in.readOptionalNamedWriteable(QueryBuilder.class);
        this.nowInMillis = in.readLong();
        this.runtimeFields = in.readMap();
    }

    FieldCapabilitiesNodeRequest(List<ShardId> shardIds, String[] fields, OriginalIndices originalIndices, QueryBuilder indexFilter, long nowInMillis, Map<String, Object> runtimeFields) {
        this.shardIds = Objects.requireNonNull(shardIds);
        this.fields = fields;
        this.originalIndices = originalIndices;
        this.indexFilter = indexFilter;
        this.nowInMillis = nowInMillis;
        this.runtimeFields = runtimeFields;
    }

    public String[] fields() {
        return this.fields;
    }

    public OriginalIndices originalIndices() {
        return this.originalIndices;
    }

    @Override
    public String[] indices() {
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.originalIndices.indicesOptions();
    }

    public QueryBuilder indexFilter() {
        return this.indexFilter;
    }

    public Map<String, Object> runtimeFields() {
        return this.runtimeFields;
    }

    public List<ShardId> shardIds() {
        return this.shardIds;
    }

    public long nowInMillis() {
        return this.nowInMillis;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeList(this.shardIds);
        out.writeStringArray(this.fields);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
        out.writeOptionalNamedWriteable(this.indexFilter);
        out.writeLong(this.nowInMillis);
        out.writeMap(this.runtimeFields);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCapabilitiesNodeRequest that = (FieldCapabilitiesNodeRequest)o;
        return this.nowInMillis == that.nowInMillis && this.shardIds.equals(that.shardIds) && Arrays.equals(this.fields, that.fields) && Objects.equals(this.originalIndices, that.originalIndices) && Objects.equals(this.indexFilter, that.indexFilter) && Objects.equals(this.runtimeFields, that.runtimeFields);
    }

    public int hashCode() {
        int result = Objects.hash(this.originalIndices, this.indexFilter, this.nowInMillis, this.runtimeFields);
        result = 31 * result + this.shardIds.hashCode();
        result = 31 * result + Arrays.hashCode(this.fields);
        return result;
    }
}

