/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.type;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.xpack.ql.type.StringUtils;

public final class DateUtils {
    public static final ZoneId UTC = ZoneId.of("Z");
    private static final DateTimeFormatter DATE_OPTIONAL_TIME_FORMATTER_WHITESPACE = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendZoneOrOffsetId().optionalEnd().toFormatter().withZone(UTC);
    private static final DateTimeFormatter DATE_OPTIONAL_TIME_FORMATTER_T_LITERAL = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendZoneOrOffsetId().optionalEnd().toFormatter().withZone(UTC);

    private DateUtils() {
    }

    public static ZonedDateTime asDateTime(long millis) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), UTC);
    }

    public static ZonedDateTime asDateTime(String dateFormat) {
        int separatorIdx = dateFormat.indexOf(45);
        if (separatorIdx == 0) {
            separatorIdx = dateFormat.indexOf(45, 1);
        }
        if ((separatorIdx = dateFormat.indexOf(45, separatorIdx + 1) + 3) >= dateFormat.length() || dateFormat.charAt(separatorIdx) == 'T') {
            return DateFormatters.from((TemporalAccessor)DATE_OPTIONAL_TIME_FORMATTER_T_LITERAL.parse(dateFormat)).withZoneSameInstant(UTC);
        }
        return DateFormatters.from((TemporalAccessor)DATE_OPTIONAL_TIME_FORMATTER_WHITESPACE.parse(dateFormat)).withZoneSameInstant(UTC);
    }

    public static String toString(ZonedDateTime dateTime) {
        return StringUtils.toString(dateTime);
    }
}

