/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.notifications;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditMessage;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditMessageFactory;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditor;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.ml.MlIndexTemplateRegistry;

abstract class AbstractMlAuditor<T extends AbstractAuditMessage>
extends AbstractAuditor<T> {
    private static final Logger logger = LogManager.getLogger(AbstractMlAuditor.class);
    private volatile boolean isResetMode;

    protected AbstractMlAuditor(Client client, AbstractAuditMessageFactory<T> messageFactory, ClusterService clusterService) {
        super(new OriginSettingClient(client, "ml"), ".ml-notifications-000002", MlIndexTemplateRegistry.COMPOSABLE_TEMPLATE_SWITCH_VERSION, MlIndexTemplateRegistry.NOTIFICATIONS_LEGACY_TEMPLATE, MlIndexTemplateRegistry.NOTIFICATIONS_TEMPLATE, clusterService.getNodeName(), messageFactory, clusterService);
        clusterService.addListener(event -> {
            if (event.metadataChanged()) {
                this.setResetMode(MlMetadata.getMlMetadata((ClusterState)event.state()).isResetMode());
            }
        });
    }

    private void setResetMode(boolean value) {
        this.isResetMode = value;
    }

    protected void indexDoc(ToXContent toXContent) {
        if (this.isResetMode) {
            logger.trace("Skipped writing the audit message backlog as reset_mode is enabled");
        } else {
            super.indexDoc(toXContent);
        }
    }

    protected void writeBacklog() {
        if (this.isResetMode) {
            logger.trace("Skipped writing the audit message backlog as reset_mode is enabled");
            this.clearBacklog();
        } else {
            super.writeBacklog();
        }
    }
}

