/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.categorization;

import java.util.Arrays;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

class TextCategorization
implements Accountable {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(TextCategorization.class);
    private final long id;
    private final int[] categorization;
    private final long[] tokenCounts;
    private long count;
    long bucketOrd;

    TextCategorization(int[] tokenIds, long count, long id) {
        this.id = id;
        this.categorization = tokenIds;
        this.count = count;
        this.tokenCounts = new long[tokenIds.length];
        Arrays.fill(this.tokenCounts, count);
    }

    public long getId() {
        return this.id;
    }

    int[] getCategorization() {
        return this.categorization;
    }

    public long getCount() {
        return this.count;
    }

    Similarity calculateSimilarity(int[] tokenIds) {
        assert (tokenIds.length == this.categorization.length);
        int eqParams = 0;
        long tokenCount = 0L;
        long tokensKept = 0L;
        for (int i = 0; i < tokenIds.length; ++i) {
            if (tokenIds[i] == this.categorization[i]) {
                tokensKept += this.tokenCounts[i];
                tokenCount += this.tokenCounts[i];
                continue;
            }
            if (this.categorization[i] == -1) {
                ++eqParams;
                continue;
            }
            tokenCount += this.tokenCounts[i];
        }
        return new Similarity((double)tokensKept / (double)tokenCount, eqParams);
    }

    void addTokens(int[] tokenIds, long docCount) {
        assert (tokenIds.length == this.categorization.length);
        for (int i = 0; i < tokenIds.length; ++i) {
            if (tokenIds[i] != this.categorization[i]) {
                this.categorization[i] = -1;
                continue;
            }
            int n = i;
            this.tokenCounts[n] = this.tokenCounts[n] + docCount;
        }
        this.count += docCount;
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + RamUsageEstimator.sizeOf((int[])this.categorization) + RamUsageEstimator.sizeOf((long[])this.tokenCounts);
    }

    static class Similarity
    implements Comparable<Similarity> {
        private final double similarity;
        private final int wildCardCount;

        private Similarity(double similarity, int wildCardCount) {
            this.similarity = similarity;
            this.wildCardCount = wildCardCount;
        }

        @Override
        public int compareTo(Similarity o) {
            int d = Double.compare(this.similarity, o.similarity);
            if (d != 0) {
                return d;
            }
            return Integer.compare(this.wildCardCount, o.wildCardCount);
        }

        public double getSimilarity() {
            return this.similarity;
        }

        public int getWildCardCount() {
            return this.wildCardCount;
        }
    }
}

