/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.OptionalLong;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.MlInfoAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisLimits;
import org.elasticsearch.xpack.core.ml.job.config.CategorizationAnalyzerConfig;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.process.NativeController;
import org.elasticsearch.xpack.ml.process.NativeControllerHolder;
import org.elasticsearch.xpack.ml.utils.NativeMemoryCalculator;

public class TransportMlInfoAction
extends HandledTransportAction<MlInfoAction.Request, MlInfoAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportMlInfoAction.class);
    private final ClusterService clusterService;
    private final NamedXContentRegistry xContentRegistry;
    private final Map<String, Object> nativeCodeInfo;

    @Inject
    public TransportMlInfoAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, NamedXContentRegistry xContentRegistry, Environment env) {
        super("cluster:monitor/xpack/ml/info/get", transportService, actionFilters, MlInfoAction.Request::new);
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        try {
            NativeController nativeController = NativeControllerHolder.getNativeController(clusterService.getNodeName(), env);
            this.nativeCodeInfo = nativeController != null ? nativeController.getNativeCodeInfo() : Collections.emptyMap();
        }
        catch (IOException e) {
            throw new IllegalStateException("native controller failed to load", e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Could not get native code info from native controller", e);
        }
    }

    protected void doExecute(Task task, MlInfoAction.Request request, ActionListener<MlInfoAction.Response> listener) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("defaults", this.defaults());
        info.put("limits", this.limits());
        info.put("native_code", this.nativeCodeInfo);
        info.put(MlMetadata.UPGRADE_MODE.getPreferredName(), this.upgradeMode());
        listener.onResponse((Object)new MlInfoAction.Response(info));
    }

    private Map<String, Object> defaults() {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put("anomaly_detectors", this.anomalyDetectorsDefaults());
        defaults.put("datafeeds", this.datafeedsDefaults());
        return defaults;
    }

    private boolean upgradeMode() {
        return MlMetadata.getMlMetadata((ClusterState)this.clusterService.state()).isUpgradeMode();
    }

    private Map<String, Object> anomalyDetectorsDefaults() {
        LinkedHashMap<String, Object> defaults = new LinkedHashMap<String, Object>();
        defaults.put(AnalysisLimits.MODEL_MEMORY_LIMIT.getPreferredName(), this.defaultModelMemoryLimit());
        defaults.put(AnalysisLimits.CATEGORIZATION_EXAMPLES_LIMIT.getPreferredName(), 4L);
        defaults.put(Job.MODEL_SNAPSHOT_RETENTION_DAYS.getPreferredName(), 10L);
        defaults.put(Job.DAILY_MODEL_SNAPSHOT_RETENTION_AFTER_DAYS.getPreferredName(), 1L);
        try {
            defaults.put(CategorizationAnalyzerConfig.CATEGORIZATION_ANALYZER.getPreferredName(), CategorizationAnalyzerConfig.buildStandardCategorizationAnalyzer(Collections.emptyList()).asMap(this.xContentRegistry).get(CategorizationAnalyzerConfig.CATEGORIZATION_ANALYZER.getPreferredName()));
        }
        catch (IOException e) {
            logger.error("failed to convert default categorization analyzer to map", (Throwable)e);
        }
        return defaults;
    }

    private ByteSizeValue defaultModelMemoryLimit() {
        ByteSizeValue defaultLimit = ByteSizeValue.ofMb((long)1024L);
        ByteSizeValue maxModelMemoryLimit = (ByteSizeValue)this.clusterService.getClusterSettings().get(MachineLearningField.MAX_MODEL_MEMORY_LIMIT);
        if (maxModelMemoryLimit != null && maxModelMemoryLimit.getBytes() > 0L && maxModelMemoryLimit.getBytes() < defaultLimit.getBytes()) {
            return maxModelMemoryLimit;
        }
        return defaultLimit;
    }

    private Map<String, Object> datafeedsDefaults() {
        HashMap<String, Object> anomalyDetectorsDefaults = new HashMap<String, Object>();
        anomalyDetectorsDefaults.put(DatafeedConfig.SCROLL_SIZE.getPreferredName(), 1000);
        return anomalyDetectorsDefaults;
    }

    static ByteSizeValue calculateTotalMlMemory(ClusterSettings clusterSettings, DiscoveryNodes nodes) {
        long totalMlMemory = 0L;
        for (DiscoveryNode node : nodes) {
            OptionalLong limit = NativeMemoryCalculator.allowedBytesForMl(node, clusterSettings);
            if (!limit.isPresent()) continue;
            totalMlMemory += limit.getAsLong();
        }
        return ByteSizeValue.ofMb((long)ByteSizeUnit.BYTES.toMB(totalMlMemory));
    }

    static ByteSizeValue calculateEffectiveMaxModelMemoryLimit(ClusterSettings clusterSettings, DiscoveryNodes nodes) {
        long maxMlMemory = -1L;
        int numMlNodes = 0;
        for (DiscoveryNode node : nodes) {
            OptionalLong limit = NativeMemoryCalculator.allowedBytesForMl(node, clusterSettings);
            if (!limit.isPresent()) continue;
            maxMlMemory = Math.max(maxMlMemory, limit.getAsLong());
            ++numMlNodes;
        }
        long maxMlNodeSize = ((ByteSizeValue)clusterSettings.get(MachineLearning.MAX_ML_NODE_SIZE)).getBytes();
        int maxLazyNodes = (Integer)clusterSettings.get(MachineLearning.MAX_LAZY_ML_NODES);
        if (maxMlNodeSize > 0L && numMlNodes < maxLazyNodes) {
            maxMlMemory = Math.max(maxMlMemory, NativeMemoryCalculator.allowedBytesForMl(maxMlNodeSize, (int)((Integer)clusterSettings.get(MachineLearning.MAX_MACHINE_MEMORY_PERCENT)), (boolean)((Boolean)clusterSettings.get(MachineLearning.USE_AUTO_MACHINE_MEMORY_PERCENT))));
        }
        if (maxMlMemory <= 0L) {
            return null;
        }
        maxMlMemory -= Math.max(Job.PROCESS_MEMORY_OVERHEAD.getBytes(), DataFrameAnalyticsConfig.PROCESS_MEMORY_OVERHEAD.getBytes());
        return ByteSizeValue.ofMb((long)ByteSizeUnit.BYTES.toMB(Math.max(0L, maxMlMemory -= MachineLearning.NATIVE_EXECUTABLE_CODE_OVERHEAD.getBytes())));
    }

    private Map<String, Object> limits() {
        HashMap<String, Object> limits = new HashMap<String, Object>();
        ByteSizeValue effectiveMaxModelMemoryLimit = TransportMlInfoAction.calculateEffectiveMaxModelMemoryLimit(this.clusterService.getClusterSettings(), this.clusterService.state().getNodes());
        ByteSizeValue maxModelMemoryLimit = (ByteSizeValue)this.clusterService.getClusterSettings().get(MachineLearningField.MAX_MODEL_MEMORY_LIMIT);
        if (maxModelMemoryLimit != null && maxModelMemoryLimit.getBytes() > 0L) {
            limits.put("max_model_memory_limit", maxModelMemoryLimit.getStringRep());
            if (effectiveMaxModelMemoryLimit == null || effectiveMaxModelMemoryLimit.compareTo(maxModelMemoryLimit) > 0) {
                effectiveMaxModelMemoryLimit = maxModelMemoryLimit;
            }
        }
        if (effectiveMaxModelMemoryLimit != null) {
            limits.put("effective_max_model_memory_limit", effectiveMaxModelMemoryLimit.getStringRep());
        }
        limits.put("total_ml_memory", TransportMlInfoAction.calculateTotalMlMemory(this.clusterService.getClusterSettings(), this.clusterService.state().getNodes()).getStringRep());
        return limits;
    }
}

