/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.SharedGroupFactory;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.netty4.Netty4Transport;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class Netty4Plugin
extends Plugin
implements NetworkPlugin {
    public static final String NETTY_TRANSPORT_NAME = "netty4";
    public static final String NETTY_HTTP_TRANSPORT_NAME = "netty4";
    private final SetOnce<SharedGroupFactory> groupFactory = new SetOnce();

    public List<Setting<?>> getSettings() {
        return Arrays.asList(Netty4HttpServerTransport.SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS, Netty4HttpServerTransport.SETTING_HTTP_WORKER_COUNT, Netty4HttpServerTransport.SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE, Netty4Transport.WORKER_COUNT, Netty4Transport.NETTY_RECEIVE_PREDICTOR_SIZE, Netty4Transport.NETTY_RECEIVE_PREDICTOR_MIN, Netty4Transport.NETTY_RECEIVE_PREDICTOR_MAX, Netty4Transport.NETTY_BOSS_COUNT);
    }

    public Settings additionalSettings() {
        return Settings.builder().put(NetworkModule.HTTP_DEFAULT_TYPE_SETTING.getKey(), "netty4").put(NetworkModule.TRANSPORT_DEFAULT_TYPE_SETTING.getKey(), "netty4").build();
    }

    public Map<String, Supplier<Transport>> getTransports(Settings settings, ThreadPool threadPool, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService) {
        return Collections.singletonMap("netty4", () -> new Netty4Transport(settings, Version.CURRENT, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, this.getSharedGroupFactory(settings)));
    }

    public Map<String, Supplier<HttpServerTransport>> getHttpTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedXContentRegistry xContentRegistry, NetworkService networkService, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings) {
        return Collections.singletonMap("netty4", () -> new Netty4HttpServerTransport(settings, networkService, bigArrays, threadPool, xContentRegistry, dispatcher, clusterSettings, this.getSharedGroupFactory(settings)));
    }

    private SharedGroupFactory getSharedGroupFactory(Settings settings) {
        SharedGroupFactory groupFactory = (SharedGroupFactory)this.groupFactory.get();
        if (groupFactory != null) {
            assert (groupFactory.getSettings().equals((Object)settings)) : "Different settings than originally provided";
            return groupFactory;
        }
        this.groupFactory.set((Object)new SharedGroupFactory(settings));
        return (SharedGroupFactory)this.groupFactory.get();
    }
}

