/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.deprecation;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class DeprecationIssue
implements Writeable,
ToXContentObject {
    private final Level level;
    private final String message;
    private final String url;
    private final String details;
    private final boolean resolveDuringRollingUpgrade;
    private final Map<String, Object> meta;

    public DeprecationIssue(Level level, String message, String url, @Nullable String details, boolean resolveDuringRollingUpgrade, @Nullable Map<String, Object> meta) {
        this.level = level;
        this.message = message;
        this.url = url;
        this.details = details;
        this.resolveDuringRollingUpgrade = resolveDuringRollingUpgrade;
        this.meta = meta;
    }

    public DeprecationIssue(StreamInput in) throws IOException {
        this.level = Level.readFromStream(in);
        this.message = in.readString();
        this.url = in.readString();
        this.details = in.readOptionalString();
        this.resolveDuringRollingUpgrade = in.getVersion().onOrAfter(Version.V_7_15_0) && in.readBoolean();
        this.meta = in.getVersion().onOrAfter(Version.V_7_14_0) ? in.readMap() : null;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDetails() {
        return this.details;
    }

    public boolean isResolveDuringRollingUpgrade() {
        return this.resolveDuringRollingUpgrade;
    }

    public Map<String, Object> getMeta() {
        return this.meta;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.level.writeTo(out);
        out.writeString(this.message);
        out.writeString(this.url);
        out.writeOptionalString(this.details);
        if (out.getVersion().onOrAfter(Version.V_7_15_0)) {
            out.writeBoolean(this.resolveDuringRollingUpgrade);
        }
        if (out.getVersion().onOrAfter(Version.V_7_14_0)) {
            out.writeMap(this.meta);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("level", (Enum)this.level).field("message", this.message).field("url", this.url);
        if (this.details != null) {
            builder.field("details", this.details);
        }
        builder.field("resolve_during_rolling_upgrade", this.resolveDuringRollingUpgrade);
        if (this.meta != null) {
            builder.field("_meta", this.meta);
        }
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeprecationIssue that = (DeprecationIssue)o;
        return Objects.equals((Object)this.level, (Object)that.level) && Objects.equals(this.message, that.message) && Objects.equals(this.url, that.url) && Objects.equals(this.details, that.details) && Objects.equals(this.resolveDuringRollingUpgrade, that.resolveDuringRollingUpgrade) && Objects.equals(this.meta, that.meta);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.level, this.message, this.url, this.details, this.resolveDuringRollingUpgrade, this.meta});
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static enum Level implements Writeable
    {
        WARNING,
        CRITICAL;


        public static Level fromString(String value) {
            return Level.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public static Level readFromStream(StreamInput in) throws IOException {
            int ordinal = in.readVInt();
            if (ordinal < 0 || ordinal >= Level.values().length) {
                throw new IOException("Unknown Level ordinal [" + ordinal + "]");
            }
            return Level.values()[ordinal];
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.ordinal());
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

