/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions;

import java.io.IOException;
import java.time.Clock;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.routing.Preference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.core.watcher.transport.actions.activate.ActivateWatchRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.activate.ActivateWatchResponse;
import org.elasticsearch.xpack.core.watcher.watch.Watch;
import org.elasticsearch.xpack.core.watcher.watch.WatchField;
import org.elasticsearch.xpack.core.watcher.watch.WatchStatus;
import org.elasticsearch.xpack.watcher.transport.actions.WatcherTransportAction;
import org.elasticsearch.xpack.watcher.watch.WatchParser;

public class TransportActivateWatchAction
extends WatcherTransportAction<ActivateWatchRequest, ActivateWatchResponse> {
    private final Clock clock;
    private final WatchParser parser;
    private final Client client;

    @Inject
    public TransportActivateWatchAction(TransportService transportService, ActionFilters actionFilters, Clock clock, XPackLicenseState licenseState, WatchParser parser, Client client) {
        super("cluster:admin/xpack/watcher/watch/activate", transportService, actionFilters, licenseState, ActivateWatchRequest::new);
        this.clock = clock;
        this.parser = parser;
        this.client = client;
    }

    @Override
    protected void doExecute(ActivateWatchRequest request, ActionListener<ActivateWatchResponse> listener) {
        try {
            ZonedDateTime now = this.clock.instant().atZone(ZoneOffset.UTC);
            UpdateRequest updateRequest = new UpdateRequest(".watches", request.getWatchId());
            updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            XContentBuilder builder = this.activateWatchBuilder(request.isActivate(), now);
            updateRequest.doc(builder);
            updateRequest.retryOnConflict(2);
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"watcher", (ActionRequest)updateRequest, (ActionListener)ActionListener.wrap(updateResponse -> {
                GetRequest getRequest = new GetRequest(".watches", request.getWatchId()).preference(Preference.LOCAL.type()).realtime(true);
                ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"watcher", (ActionRequest)getRequest, (ActionListener)ActionListener.wrap(getResponse -> {
                    if (getResponse.isExists()) {
                        Watch watch = this.parser.parseWithSecrets(request.getWatchId(), true, getResponse.getSourceAsBytesRef(), now, XContentType.JSON, getResponse.getSeqNo(), getResponse.getPrimaryTerm());
                        watch.status().version(getResponse.getVersion());
                        listener.onResponse((Object)new ActivateWatchResponse(watch.status()));
                    } else {
                        listener.onFailure((Exception)new ResourceNotFoundException("Watch with id [{}] does not exist", new Object[]{request.getWatchId()}));
                    }
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1));
            }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).update(arg_0, arg_1));
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
        }
    }

    private XContentBuilder activateWatchBuilder(boolean active, ZonedDateTime now) throws IOException {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            builder.startObject().startObject(WatchField.STATUS.getPreferredName()).startObject(WatchStatus.Field.STATE.getPreferredName()).field(WatchStatus.Field.ACTIVE.getPreferredName(), active);
            WatcherDateTimeUtils.writeDate((String)WatchStatus.Field.TIMESTAMP.getPreferredName(), (XContentBuilder)builder, (ZonedDateTime)now);
            builder.endObject().endObject().endObject();
            XContentBuilder xContentBuilder = builder;
            return xContentBuilder;
        }
    }
}

