/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PerformanceUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PerformanceUtils.class);

    public static long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public static void logMbps(long startTime, long endTime, long totalBytes, String objName, boolean isPutCommand) {
        double time = endTime - startTime == 0L ? 1.0 : (double)(endTime - startTime) / 1000.0;
        double content = PerformanceUtils.convertBytesToMegaBytes(totalBytes);
        double mbps = content / time;
        String messagePrefix = PerformanceUtils.getMessagePrefix(isPutCommand);
        LOG.info("{}", (Object)String.format("%s %s statistics: Length (%.03f MB), Time (%.03f sec), MBps (%.03f)", messagePrefix, objName, content, time, mbps));
    }

    public static void logMbpsStatus(long startTime, long curTime, long curBytes, String objName, boolean isPutCommand) {
        double time = curTime - startTime == 0L ? 0.0 : (double)(curTime - startTime) / 1000.0;
        double curMegaBytes = PerformanceUtils.convertBytesToMegaBytes(curBytes);
        String messagePrefix = PerformanceUtils.getMessagePrefix(isPutCommand);
        LOG.info("{}", (Object)String.format("%s %s status: Transferred (%.03f MB), Time (%.03f sec)", messagePrefix, objName, curMegaBytes, time));
    }

    private static String getMessagePrefix(boolean isPutCommand) {
        if (isPutCommand) {
            return "Putting";
        }
        return "Getting";
    }

    private static double convertBytesToMegaBytes(long bytes) {
        return (double)bytes / 1024.0 / 1024.0;
    }
}

