/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.utils;

import com.spectralogic.ds3client.helpers.UnrecoverableIOException;
import com.spectralogic.ds3client.utils.PerformanceUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.http.ConnectionClosedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtils {
    private static final Logger LOG = LoggerFactory.getLogger(IOUtils.class);

    public static long copy(InputStream inputStream, OutputStream outputStream, int bufferSize, String objName, boolean isPutCommand) throws IOException {
        int len;
        long startTime;
        byte[] buffer = new byte[bufferSize];
        long totalBytes = 0L;
        long statusUpdateTime = startTime = PerformanceUtils.getCurrentTime();
        while ((len = inputStream.read(buffer)) != -1) {
            totalBytes += (long)len;
            outputStream.write(buffer, 0, len);
            long curTime = PerformanceUtils.getCurrentTime();
            if (statusUpdateTime > curTime) continue;
            PerformanceUtils.logMbpsStatus(startTime, curTime, totalBytes, objName, isPutCommand);
            statusUpdateTime = (long)((double)statusUpdateTime + 60000.0);
        }
        return totalBytes;
    }

    public static long copy(InputStream inputStream, WritableByteChannel writableByteChannel, int bufferSize, String objName, boolean isPutCommand) throws IOException {
        long startTime;
        byte[] buffer = new byte[bufferSize];
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        long totalBytes = 0L;
        long statusUpdateTime = startTime = PerformanceUtils.getCurrentTime();
        try {
            int len;
            while ((len = inputStream.read(buffer)) != -1) {
                totalBytes += (long)len;
                try {
                    byteBuffer.position(0);
                    byteBuffer.limit(len);
                    writableByteChannel.write(byteBuffer);
                }
                catch (Throwable t) {
                    throw new UnrecoverableIOException(t);
                }
                long curTime = PerformanceUtils.getCurrentTime();
                if (statusUpdateTime > curTime) continue;
                PerformanceUtils.logMbpsStatus(startTime, curTime, totalBytes, objName, isPutCommand);
                statusUpdateTime = (long)((double)statusUpdateTime + 60000.0);
            }
        }
        catch (ConnectionClosedException e) {
            LOG.error("Connection closed trying to copy from stream to channel.", (Throwable)e);
        }
        return totalBytes;
    }
}

