/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.util;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.UnmodifiableIterator;
import com.spectralogic.ds3client.models.BulkObject;
import com.spectralogic.ds3client.models.Objects;
import com.spectralogic.ds3client.models.bulk.Ds3Object;
import com.spectralogic.ds3client.models.bulk.PartialDs3Object;
import com.spectralogic.ds3client.models.common.Range;
import com.spectralogic.ds3client.utils.Guard;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PartialObjectHelpers {
    private PartialObjectHelpers() {
    }

    public static ImmutableMultimap<String, Range> getPartialObjectsRanges(Iterable<Ds3Object> objects) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Ds3Object obj : objects) {
            if (!(obj instanceof PartialDs3Object)) continue;
            PartialDs3Object partialDs3Object = (PartialDs3Object)obj;
            builder.put((Object)partialDs3Object.getName(), (Object)partialDs3Object.getRange());
        }
        return builder.build();
    }

    public static ImmutableMap<String, ImmutableMultimap<BulkObject, Range>> mapRangesToBlob(List<Objects> chunks, ImmutableMultimap<String, Range> partialObjects) {
        HashMap<String, ImmutableMultimap.Builder<BulkObject, Range>> objectMapperBuilders = new HashMap<String, ImmutableMultimap.Builder<BulkObject, Range>>();
        for (Objects chunk : chunks) {
            for (BulkObject blob : chunk.getObjects()) {
                ImmutableCollection ranges = partialObjects.get((Object)blob.getName());
                if (Guard.isNullOrEmpty((Collection)ranges)) continue;
                ImmutableList<Range> rangesForBlob = PartialObjectHelpers.getRangesForBlob(blob, (ImmutableCollection<Range>)ranges);
                ImmutableList<Range> nonDuplicateRanges = PartialObjectHelpers.dedupRanges(rangesForBlob);
                PartialObjectHelpers.getMultiMapBuilder(objectMapperBuilders, blob.getName()).putAll((Object)blob, nonDuplicateRanges);
            }
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : objectMapperBuilders.entrySet()) {
            builder.put(entry.getKey(), (Object)((ImmutableMultimap.Builder)entry.getValue()).build());
        }
        return builder.build();
    }

    static ImmutableList<Range> dedupRanges(ImmutableList<Range> rangesForBlob) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableSortedSet sortedRanges = ImmutableSortedSet.copyOf(rangesForBlob);
        Range currentRange = null;
        UnmodifiableIterator unmodifiableIterator = sortedRanges.iterator();
        while (unmodifiableIterator.hasNext()) {
            Range sortedRange;
            Range nextRange = sortedRange = (Range)unmodifiableIterator.next();
            if (currentRange == null) {
                currentRange = nextRange;
                continue;
            }
            if (currentRange.getEnd() >= nextRange.getStart()) {
                long start = Math.min(currentRange.getStart(), nextRange.getStart());
                long end = Math.max(currentRange.getEnd(), nextRange.getEnd());
                currentRange = Range.byPosition(start, end);
                continue;
            }
            builder.add((Object)currentRange);
            currentRange = nextRange;
        }
        if (currentRange != null) {
            builder.add(currentRange);
        }
        return Ordering.natural().immutableSortedCopy((Iterable)builder.build());
    }

    private static ImmutableMultimap.Builder<BulkObject, Range> getMultiMapBuilder(Map<String, ImmutableMultimap.Builder<BulkObject, Range>> mapper, String file) {
        if (mapper.containsKey(file)) {
            return mapper.get(file);
        }
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        mapper.put(file, (ImmutableMultimap.Builder<BulkObject, Range>)builder);
        return builder;
    }

    private static ImmutableList<Range> getRangesForBlob(BulkObject object, ImmutableCollection<Range> ranges) {
        ImmutableList.Builder builder = ImmutableList.builder();
        long start = object.getOffset();
        long end = start + object.getLength() - 1L;
        for (Range range : ranges) {
            long rangeStart = range.getStart();
            long rangeEnd = range.getEnd();
            if (rangeStart > end || rangeEnd < start) continue;
            if (rangeStart >= start && rangeEnd <= end) {
                builder.add((Object)range);
                continue;
            }
            builder.add((Object)Range.byPosition(Math.max(rangeStart, start), Math.min(end, rangeEnd)));
        }
        return builder.build();
    }
}

