/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.networking.HttpVerb;
import com.spectralogic.ds3client.utils.Guard;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;

public class GetBlobPersistenceSpectraS3Request
extends AbstractRequest {
    private final String requestPayload;
    private long size = 0L;

    public GetBlobPersistenceSpectraS3Request(String requestPayload) {
        this.requestPayload = requestPayload;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/_rest_/blob_persistence";
    }

    @Override
    public InputStream getStream() {
        if (Guard.isStringNullOrEmpty((String)this.requestPayload)) {
            return null;
        }
        byte[] stringBytes = this.requestPayload.getBytes(Charset.forName("UTF-8"));
        this.size = stringBytes.length;
        return new ByteArrayInputStream(stringBytes);
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public String getRequestPayload() {
        return this.requestPayload;
    }
}

