/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.RegisterS3TargetSpectraS3Response;
import com.spectralogic.ds3client.models.S3Target;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class RegisterS3TargetSpectraS3ResponseParser
extends AbstractResponseParser<RegisterS3TargetSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{201};

    @Override
    public RegisterS3TargetSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 201: {
                    try (InputStream inputStream = response.getResponseStream();){
                        S3Target result = XmlOutput.fromXml(inputStream, S3Target.class);
                        RegisterS3TargetSpectraS3Response registerS3TargetSpectraS3Response = new RegisterS3TargetSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return registerS3TargetSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

