/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.PutS3TargetReadPreferenceSpectraS3Response;
import com.spectralogic.ds3client.models.S3TargetReadPreference;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class PutS3TargetReadPreferenceSpectraS3ResponseParser
extends AbstractResponseParser<PutS3TargetReadPreferenceSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{201};

    @Override
    public PutS3TargetReadPreferenceSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 201: {
                    try (InputStream inputStream = response.getResponseStream();){
                        S3TargetReadPreference result = XmlOutput.fromXml(inputStream, S3TargetReadPreference.class);
                        PutS3TargetReadPreferenceSpectraS3Response putS3TargetReadPreferenceSpectraS3Response = new PutS3TargetReadPreferenceSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return putS3TargetReadPreferenceSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

