/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.GetS3TargetFailureNotificationRegistrationsSpectraS3Response;
import com.spectralogic.ds3client.models.S3TargetFailureNotificationRegistrationList;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class GetS3TargetFailureNotificationRegistrationsSpectraS3ResponseParser
extends AbstractResponseParser<GetS3TargetFailureNotificationRegistrationsSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public GetS3TargetFailureNotificationRegistrationsSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        Integer pagingTruncated = this.parseIntHeader("page-truncated");
        Integer pagingTotalResultCount = this.parseIntHeader("total-result-count");
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        S3TargetFailureNotificationRegistrationList result = XmlOutput.fromXml(inputStream, S3TargetFailureNotificationRegistrationList.class);
                        GetS3TargetFailureNotificationRegistrationsSpectraS3Response getS3TargetFailureNotificationRegistrationsSpectraS3Response = new GetS3TargetFailureNotificationRegistrationsSpectraS3Response(result, pagingTotalResultCount, pagingTruncated, this.getChecksum(), this.getChecksumType());
                        return getS3TargetFailureNotificationRegistrationsSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

